/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPrettyPrinter {
    private static final Log log = LogFactory.getLog(XMLPrettyPrinter.class);
    private static final String prettyPrintStylesheet = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'  xmlns:xalan='http://xml.apache.org/xslt'  exclude-result-prefixes='xalan'>  <xsl:output method='xml' indent='yes' xalan:indent-amount='4'/>  <xsl:strip-space elements='*'/>  <xsl:template match='/'>    <xsl:apply-templates/>  </xsl:template>  <xsl:template match='node() | @*'>        <xsl:copy>          <xsl:apply-templates select='node() | @*'/>        </xsl:copy>  </xsl:template></xsl:stylesheet>";

    public static void prettify(final File file) {
        block26: {
            InputStream inputStream = null;
            FileOutputStream outputStream = null;
            byte[] byteArray = null;
            try {
                try {
                    FileInputStream fin = new FileInputStream(file);
                    byteArray = IOUtils.toByteArray((InputStream)fin);
                    fin.close();
                    inputStream = new ByteArrayInputStream(byteArray);
                    outputStream = new FileOutputStream(file);
                    StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(prettyPrintStylesheet.getBytes()));
                    StreamSource xmlSource = new StreamSource(inputStream);
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Templates templates = tf.newTemplates(stylesheetSource);
                    Transformer transformer = templates.newTransformer();
                    transformer.setErrorListener(new ErrorListener(){

                        @Override
                        public void warning(TransformerException exception) throws TransformerException {
                            log.warn((Object)("Exception occurred while trying to pretty print file " + file), (Throwable)exception);
                        }

                        @Override
                        public void error(TransformerException exception) throws TransformerException {
                            log.error((Object)("Exception occurred while trying to pretty print file " + file), (Throwable)exception);
                        }

                        @Override
                        public void fatalError(TransformerException exception) throws TransformerException {
                            log.error((Object)("Exception occurred while trying to pretty print file " + file), (Throwable)exception);
                        }
                    });
                    transformer.transform(xmlSource, new StreamResult(outputStream));
                    inputStream.close();
                    outputStream.close();
                    log.debug((Object)("Pretty printed file : " + file));
                }
                catch (Throwable t) {
                    log.debug((Object)("Exception occurred while trying to pretty print file " + file), t);
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    try {
                        if (byteArray != null) {
                            outputStream = new FileOutputStream(file);
                            outputStream.write(byteArray);
                        }
                    }
                    catch (IOException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (outputStream == null) break block26;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public static void prettify(OMElement wsdlElement, OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wsdlElement.serialize((OutputStream)baos);
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(prettyPrintStylesheet.getBytes()));
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
        TransformerFactory tf = TransformerFactory.newInstance();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(xmlSource, new StreamResult(out));
    }
}

