/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;

public class WSDLSerializationUtil {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_START_REGEX = "<!\\[CDATA\\[";
    public static final String CDATA_END = "]]>";
    public static final String CDATA_END_REGEX = "\\]\\]>";

    public static String getPrefix(String namespace, Map<String, String> nameSpaceMap) {
        Set<String> keySet;
        if (nameSpaceMap != null && (keySet = nameSpaceMap.keySet()) != null) {
            for (String key : keySet) {
                if (!nameSpaceMap.get(key).equals(namespace)) continue;
                return key;
            }
        }
        return null;
    }

    public static String getElementName(AxisMessage axisMessage, Map nameSpaceMap) {
        QName elementQName = axisMessage.getElementQName();
        if (elementQName == null) {
            return "#none";
        }
        if (Constants.XSD_ANY.equals(elementQName)) {
            return "#any";
        }
        String prefix = WSDLSerializationUtil.getPrefix(elementQName.getNamespaceURI(), nameSpaceMap);
        return String.valueOf(prefix) + ":" + elementQName.getLocalPart();
    }

    public static void addSOAPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element, Map nameSpaceMap) {
        int i = 0;
        while (i < list.size()) {
            SOAPHeaderMessage soapHeaderMessage = (SOAPHeaderMessage)list.get(i);
            OMElement soapHeaderElement = omFactory.createOMElement("header", wsoap);
            QName qName = soapHeaderMessage.getElement();
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("element", null, String.valueOf(WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap)) + ":" + qName.getLocalPart()));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("mustUnderstand", null, Boolean.toString(soapHeaderMessage.isMustUnderstand())));
            soapHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, Boolean.toString(soapHeaderMessage.isRequired())));
            element.addChild((OMNode)soapHeaderElement);
            ++i;
        }
    }

    public static void addSOAPModuleElements(OMFactory omFactory, ArrayList list, OMNamespace wsoap, OMElement element) {
        int i = 0;
        while (i < list.size()) {
            SOAPModuleMessage soapModuleMessage = (SOAPModuleMessage)list.get(i);
            OMElement soapModuleElement = omFactory.createOMElement("module", wsoap);
            soapModuleElement.addAttribute(omFactory.createOMAttribute("ref", null, soapModuleMessage.getUri()));
            element.addChild((OMNode)soapModuleElement);
            ++i;
        }
    }

    public static void addHTTPHeaderElements(OMFactory omFactory, ArrayList list, OMNamespace whttp, OMElement element, Map nameSpaceMap) {
        int i = 0;
        while (i < list.size()) {
            HTTPHeaderMessage httpHeaderMessage = (HTTPHeaderMessage)list.get(i);
            OMElement httpHeaderElement = omFactory.createOMElement("header", whttp);
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("name", null, httpHeaderMessage.getName()));
            QName qName = httpHeaderMessage.getqName();
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("type", null, String.valueOf(WSDLSerializationUtil.getPrefix(qName.getNamespaceURI(), nameSpaceMap)) + ":" + qName.getLocalPart()));
            httpHeaderElement.addAttribute(omFactory.createOMAttribute("required", null, Boolean.valueOf(httpHeaderMessage.isRequired()).toString()));
            element.addChild((OMNode)httpHeaderElement);
            ++i;
        }
    }

    public static OMElement generateSOAP11Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, String.valueOf(serviceName) + "SOAP11Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, String.valueOf(tns.getPrefix()) + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.1"));
        binding.addAttribute(fac.createOMAttribute("protocol", wsoap, "http://www.w3.org/2003/05/soap/bindings/HTTP"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateSOAP12Binding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace wsoap, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, String.valueOf(serviceName) + "SOAP12Binding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, String.valueOf(tns.getPrefix()) + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/soap"));
        binding.addAttribute(fac.createOMAttribute("version", wsoap, "1.2"));
        binding.addAttribute(fac.createOMAttribute("protocol", wsoap, "http://www.w3.org/2003/05/soap/bindings/HTTP"));
        WSDLSerializationUtil.generateDefaultSOAPBindingOperations(axisService, fac, binding, wsdl, tns, wsoap);
        return binding;
    }

    public static OMElement generateHTTPBinding(OMFactory fac, AxisService axisService, OMNamespace wsdl, OMNamespace whttp, OMNamespace tns, String serviceName) {
        OMElement binding = fac.createOMElement("binding", wsdl);
        binding.addAttribute(fac.createOMAttribute("name", null, String.valueOf(serviceName) + "HttpBinding"));
        binding.addAttribute(fac.createOMAttribute("interface", null, String.valueOf(tns.getPrefix()) + ":" + "ServiceInterface"));
        binding.addAttribute(fac.createOMAttribute("type", null, "http://www.w3.org/ns/wsdl/http"));
        Iterator<? extends AxisDescription> iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            OMElement opElement = fac.createOMElement("operation", wsdl);
            binding.addChild((OMNode)opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(fac.createOMAttribute("ref", null, String.valueOf(tns.getPrefix()) + ":" + name));
            opElement.addAttribute(fac.createOMAttribute("location", whttp, name));
        }
        return binding;
    }

    private static void generateDefaultSOAPBindingOperations(AxisService axisService, OMFactory omFactory, OMElement binding, OMNamespace wsdl, OMNamespace tns, OMNamespace wsoap) {
        Iterator<? extends AxisDescription> iterator = axisService.getChildren();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.isControlOperation()) continue;
            OMElement opElement = omFactory.createOMElement("operation", wsdl);
            binding.addChild((OMNode)opElement);
            String name = axisOperation.getName().getLocalPart();
            opElement.addAttribute(omFactory.createOMAttribute("ref", null, String.valueOf(tns.getPrefix()) + ":" + name));
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) continue;
            opElement.addAttribute(omFactory.createOMAttribute("action", wsoap, soapAction));
        }
    }

    public static void populateNamespaces(OMElement descriptionElement, Map nameSpaceMap) {
        if (nameSpaceMap != null) {
            for (String key : nameSpaceMap.keySet()) {
                if ("".equals(key)) {
                    descriptionElement.declareDefaultNamespace((String)nameSpaceMap.get(key));
                    continue;
                }
                descriptionElement.declareNamespace((String)nameSpaceMap.get(key), key);
            }
        }
    }

    public static void addWSAWActionAttribute(OMElement element, String action, OMNamespace wsaw) {
        if (action == null || action.length() == 0 || "\\\"\\\"".equals(action)) {
            return;
        }
        element.addAttribute("Action", action, wsaw);
    }

    public static void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)extElement);
        extElement.addAttribute(att1Name, att1Value, null);
    }

    public static void addWSAddressingToBinding(String addressingFlag, OMFactory omFactory, OMElement bindingElement, OMNamespace wsaw) {
        if (addressingFlag.equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsaw);
        } else if (addressingFlag.equals("required")) {
            WSDLSerializationUtil.addExtensionElement(omFactory, bindingElement, "UsingAddressing", "required", "true", wsaw);
        }
    }

    public static void addWSDLDocumentationElement(AxisDescription axisDescription, OMElement omElement, OMFactory omFactory, OMNamespace wsdl) {
        OMElement documentation = WSDLSerializationUtil.generateDocumentationElement(axisDescription, omFactory, wsdl);
        if (documentation != null) {
            omElement.addChild((OMNode)documentation);
        }
    }

    public static OMElement generateDocumentationElement(AxisDescription axisDescription, OMFactory omFactory, OMNamespace wsdl) {
        OMNode documentationNode = axisDescription.getDocumentationNode();
        if (documentationNode != null) {
            OMElement documentation = omFactory.createOMElement("documentation", wsdl);
            documentation.addChild(documentationNode);
            return documentation;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void addPoliciesAsExtensibleElement(AxisDescription description, OMElement descriptionElement) {
        PolicySubject policySubject = description.getPolicySubject();
        Collection<PolicyComponent> attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        ArrayList<Object> policies = new ArrayList<Object>();
        for (PolicyComponent policyElement : attachPolicyComponents) {
            void var7_7;
            AxisService service;
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                policies.add(policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            String string = ((PolicyReference)policyElement).getURI();
            if (string.startsWith("#")) {
                String string2 = string.substring(string.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(service = WSDLSerializationUtil.getAxisService(description))).lookup((String)var7_7)) == null) continue;
            policies.add(p);
        }
        ExternalPolicySerializer filter = null;
        if (!policies.isEmpty()) {
            filter = new ExternalPolicySerializer();
            AxisConfiguration axisConfiguration = description.getAxisConfiguration();
            if (axisConfiguration != null) {
                filter.setAssertionsToFilter(axisConfiguration.getLocalPolicyAssertions());
            }
        }
        for (Policy policy : policies) {
            OMElement policyElement;
            try {
                policyElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policy, filter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            OMNode firstChild = descriptionElement.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore((OMNode)policyElement);
                continue;
            }
            descriptionElement.addChild((OMNode)policyElement);
        }
    }

    private static AxisService getAxisService(AxisDescription description) {
        if (description == null || description instanceof AxisService) {
            return (AxisService)description;
        }
        return WSDLSerializationUtil.getAxisService(description.getParent());
    }

    public static String extractHostIP(String serviceURL) {
        int ipindex;
        String ip = null;
        if (serviceURL != null && (ipindex = serviceURL.indexOf("//")) >= 0) {
            ip = serviceURL.substring(ipindex + 2, serviceURL.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            ip = seperatorIndex >= 0 ? ip.substring(0, seperatorIndex) : ip.substring(0, slashIndex);
        }
        return ip;
    }
}

