/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ThreadContextMigrator;

public class ThreadContextMigratorUtil {
    public static void addThreadContextMigrator(ConfigurationContext configurationContext, String threadContextMigratorListID, ThreadContextMigrator migrator) throws AxisFault {
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        ThreadContextMigratorUtil.addThreadContextMigrator(axisConfiguration, threadContextMigratorListID, migrator);
    }

    public static void addThreadContextMigrator(AxisConfiguration axisConfiguration, String threadContextMigratorListID, ThreadContextMigrator migrator) throws AxisFault {
        Parameter param = axisConfiguration.getParameter(threadContextMigratorListID);
        if (param == null) {
            param = new Parameter(threadContextMigratorListID, new LinkedList());
            axisConfiguration.addParameter(param);
        }
        List migratorList = (List)param.getValue();
        migratorList.add(migrator);
    }

    public static void performMigrationToThread(String threadContextMigratorListID, MessageContext msgContext) throws AxisFault {
        if (msgContext == null) {
            return;
        }
        AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisConfiguration.getParameter(threadContextMigratorListID);
        if (param != null) {
            List migratorList = (List)param.getValue();
            int size = migratorList.size();
            int i = 0;
            while (i < size) {
                ((ThreadContextMigrator)migratorList.get(i)).migrateContextToThread(msgContext);
                ++i;
            }
        }
    }

    public static void performThreadCleanup(String threadContextMigratorListID, MessageContext msgContext) {
        if (msgContext == null) {
            return;
        }
        AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisConfiguration.getParameter(threadContextMigratorListID);
        if (param != null) {
            List migratorList = (List)param.getValue();
            int size = migratorList.size();
            int i = 0;
            while (i < size) {
                ((ThreadContextMigrator)migratorList.get(i)).cleanupThread(msgContext);
                ++i;
            }
        }
    }

    public static void performMigrationToContext(String threadContextMigratorListID, MessageContext msgContext) throws AxisFault {
        if (msgContext == null) {
            return;
        }
        AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisConfiguration.getParameter(threadContextMigratorListID);
        if (param != null) {
            List migratorList = (List)param.getValue();
            int size = migratorList.size();
            int i = 0;
            while (i < size) {
                ((ThreadContextMigrator)migratorList.get(i)).migrateThreadToContext(msgContext);
                ++i;
            }
        }
    }

    public static void performContextCleanup(String threadContextMigratorListID, MessageContext msgContext) {
        if (msgContext == null) {
            return;
        }
        AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
        Parameter param = axisConfiguration.getParameter(threadContextMigratorListID);
        if (param != null) {
            List migratorList = (List)param.getValue();
            int size = migratorList.size();
            int i = 0;
            while (i < size) {
                ((ThreadContextMigrator)migratorList.get(i)).cleanupContext(msgContext);
                ++i;
            }
        }
    }
}

