/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;

public class SchemaUtil {
    private static final Log log = LogFactory.getLog(SchemaUtil.class);

    public static XmlSchema[] getAllSchemas(XmlSchema schema) {
        HashMap map = new HashMap();
        SchemaUtil.traverseSchemas(schema, map);
        return map.values().toArray(new XmlSchema[map.values().size()]);
    }

    private static void traverseSchemas(XmlSchema schema, HashMap map) {
        String key = String.valueOf(schema.getTargetNamespace()) + ":" + schema.getSourceURI();
        if (map.containsKey(key)) {
            return;
        }
        map.put(key, schema);
        for (XmlSchemaExternal external : schema.getExternals()) {
            XmlSchema schema1;
            if (external instanceof XmlSchemaImport && (schema1 = external.getSchema()) != null) {
                SchemaUtil.traverseSchemas(schema1, map);
            }
            if (!(external instanceof XmlSchemaInclude) || (schema1 = external.getSchema()) == null) continue;
            SchemaUtil.traverseSchemas(schema1, map);
        }
    }
}

