/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import org.apache.axis2.util.CommandLineOptionConstants;

public class CommandLineOption
implements CommandLineOptionConstants {
    private String type;
    private ArrayList optionValues;

    public CommandLineOption(String type, String[] values) {
        this.setOptionType(type);
        ArrayList<String> arrayList = new ArrayList<String>(values.length);
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                values[i] = values[i].trim();
            }
            arrayList.add(values[i]);
            ++i;
        }
        this.optionValues = arrayList;
    }

    private void setOptionType(String type) {
        if (type.startsWith("--")) {
            type = type.replaceFirst("--", "");
        }
        if (type.startsWith("-")) {
            type = type.replaceFirst("-", "");
        }
        this.type = type;
    }

    public CommandLineOption(String type, ArrayList values) {
        this.setOptionType(type);
        if (values != null) {
            this.optionValues = values;
        }
    }

    public String getOptionType() {
        return this.type;
    }

    public String getOptionValue() {
        if (this.optionValues != null && this.optionValues.size() > 0) {
            return (String)this.optionValues.get(0);
        }
        return null;
    }

    public ArrayList getOptionValues() {
        return this.optionValues;
    }
}

