/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.phaseresolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.phaseresolver.PhaseException;
import org.apache.axis2.phaseresolver.PhaseHolder;

public class PhaseResolver {
    private static final int IN_FLOW = 1;
    private static final int OUT_FAULT_FLOW = 5;
    private AxisConfiguration axisConfig;
    private PhaseHolder phaseHolder;

    public PhaseResolver(AxisConfiguration axisconfig) {
        this.axisConfig = axisconfig;
    }

    private void engageModuleToFlow(Flow flow, List handlerChain) throws PhaseException {
        this.phaseHolder = new PhaseHolder(handlerChain);
        if (flow != null) {
            int j = 0;
            while (j < flow.getHandlerCount()) {
                HandlerDescription metadata = flow.getHandler(j);
                this.phaseHolder.addHandler(metadata);
                ++j;
            }
        }
    }

    private void engageModuleToOperation(AxisOperation axisOperation, AxisModule axisModule, int flowType) throws PhaseException {
        ArrayList<Phase> phases = new ArrayList<Phase>();
        Flow flow = null;
        switch (flowType) {
            case 1: {
                phases.addAll(this.axisConfig.getInFlowPhases());
                phases.addAll(axisOperation.getRemainingPhasesInFlow());
                flow = axisModule.getInFlow();
                break;
            }
            case 2: {
                phases.addAll(axisOperation.getPhasesOutFlow());
                phases.addAll(this.axisConfig.getOutFlowPhases());
                flow = axisModule.getOutFlow();
                break;
            }
            case 4: {
                phases.addAll(axisOperation.getPhasesOutFaultFlow());
                phases.addAll(this.axisConfig.getOutFaultFlowPhases());
                flow = axisModule.getFaultOutFlow();
                break;
            }
            case 3: {
                phases.addAll(axisOperation.getPhasesInFaultFlow());
                phases.addAll(this.axisConfig.getInFaultFlowPhases());
                flow = axisModule.getFaultInFlow();
            }
        }
        this.engageModuleToFlow(flow, phases);
    }

    public void engageModuleToOperation(AxisOperation axisOperation, AxisModule module) throws PhaseException {
        int type = 1;
        while (type < 5) {
            this.engageModuleToOperation(axisOperation, module, type);
            ++type;
        }
    }

    public void disengageModuleFromGlobalChains(AxisModule module) {
        HandlerDescription handler;
        int j;
        Flow flow = module.getInFlow();
        if (flow != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getInFlowPhases());
                ++j;
            }
        }
        if ((flow = module.getOutFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getOutFlowPhases());
                ++j;
            }
        }
        if ((flow = module.getFaultInFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getInFaultFlowPhases());
                ++j;
            }
        }
        if ((flow = module.getFaultOutFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, this.axisConfig.getOutFaultFlowPhases());
                ++j;
            }
        }
    }

    public void disengageModuleFromOperationChain(AxisModule module, AxisOperation operation) {
        HandlerDescription handler;
        int j;
        Flow flow = module.getInFlow();
        if (flow != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getRemainingPhasesInFlow());
                ++j;
            }
        }
        if ((flow = module.getOutFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesOutFlow());
                ++j;
            }
        }
        if ((flow = module.getFaultInFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesInFaultFlow());
                ++j;
            }
        }
        if ((flow = module.getFaultOutFlow()) != null) {
            j = 0;
            while (j < flow.getHandlerCount()) {
                handler = flow.getHandler(j);
                this.removeHandlerfromaPhase(handler, operation.getPhasesOutFaultFlow());
                ++j;
            }
        }
    }

    private void removeHandlerfromaPhase(HandlerDescription handler, List<Phase> phaseList) {
        String phaseName = handler.getRules().getPhaseName();
        for (Phase phase : phaseList) {
            if (!phase.getPhaseName().equals(phaseName)) continue;
            phase.removeHandler(handler);
            break;
        }
    }

    public void engageModuleToMessage(AxisMessage axisMessage, AxisModule axisModule) throws PhaseException {
        String direction = axisMessage.getDirection();
        AxisOperation axisOperation = axisMessage.getAxisOperation();
        if ("Out".equalsIgnoreCase(direction)) {
            this.engageModuleToOperation(axisOperation, axisModule, 2);
        } else if ("In".equalsIgnoreCase(direction)) {
            this.engageModuleToOperation(axisOperation, axisModule, 1);
        } else {
            "Fault".equals(direction);
        }
    }
}

