/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.kernel.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.kernel.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;

public class XFormURLEncodedFormatter
implements MessageFormatter {
    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
        if (omElement != null) {
            try {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "utf-8");
                boolean first = true;
                Iterator it = omElement.getChildElements();
                while (it.hasNext()) {
                    OMElement child = (OMElement)it.next();
                    if (first) {
                        first = false;
                    } else {
                        writer.write(38);
                    }
                    writer.write(child.getLocalName());
                    writer.write(61);
                    child.writeTextTo((Writer)writer, preserve);
                }
                writer.flush();
            }
            catch (IOException e) {
                throw new AxisFault("An error occured while writing the request");
            }
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = "application/x-www-form-urlencoded";
        if (encoding != null) {
            contentType = String.valueOf(contentType) + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = String.valueOf(contentType) + ";action=\"" + soapAction + "\";";
        }
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, true);
        String ignoreUncited = (String)messageContext.getProperty("whttp:ignoreUncited");
        if (ignoreUncited == null || !JavaUtils.isTrueExplicitly(ignoreUncited)) {
            String httpMethod = (String)messageContext.getProperty("HTTP_METHOD");
            if ("GET".equals(httpMethod) || "DELETE".equals(httpMethod)) {
                targetURL = URLTemplatingUtil.appendQueryParameters(messageContext, targetURL);
            }
        } else {
            messageContext.getEnvelope().getBody().getFirstElement().detach();
        }
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }
}

