/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.kernel.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.kernel.MessageFormatter;
import org.apache.axis2.kernel.http.util.URLTemplatingUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageFormatter
implements MessageFormatter {
    private static final Log log = LogFactory.getLog(SOAPMessageFormatter.class);

    @Override
    public void writeTo(MessageContext msgCtxt, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        int optimizedThreshold;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeTo()");
            log.debug((Object)("  preserve=" + preserve));
            log.debug((Object)("  isOptimized=" + format.isOptimized()));
            log.debug((Object)("  isDoingSWA=" + format.isDoingSWA()));
        }
        if (msgCtxt.isDoingMTOM() && (optimizedThreshold = Utils.getMtomThreshold(msgCtxt)) > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting MTOM optimized Threshold Value on OMOutputFormat");
            }
            format.setOptimizedThreshold(optimizedThreshold);
        }
        try {
            try {
                if (!format.isOptimized() && format.isDoingSWA()) {
                    this.writeSwAMessage(msgCtxt, out, format, preserve);
                } else {
                    SOAPMessage message;
                    SOAPEnvelope envelope = msgCtxt.getEnvelope();
                    OMContainer parent = envelope.getParent();
                    if (parent instanceof SOAPMessage) {
                        message = (SOAPMessage)parent;
                    } else {
                        message = ((SOAPFactory)envelope.getOMFactory()).createSOAPMessage();
                        message.setSOAPEnvelope(envelope);
                    }
                    message.serialize(out, format, preserve);
                }
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)"end writeTo()");
            }
        }
    }

    @Override
    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType from the OMOutputFormat =" + contentType));
        }
        if (encoding != null && contentType != null && contentType.indexOf("multipart/related") == -1) {
            contentType = String.valueOf(contentType) + "; charset=" + encoding;
        }
        if (!(msgCtxt.isSOAP11() || soapActionString == null || "".equals(soapActionString.trim()) || "\"\"".equals(soapActionString.trim()))) {
            contentType = String.valueOf(contentType) + "; action=\"" + soapActionString + "\"";
        }
        if ((contentType = contentType.trim()).lastIndexOf(";") == contentType.length() - 1) {
            contentType = contentType.substring(0, contentType.length() - 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("contentType returned =" + contentType));
        }
        return contentType;
    }

    @Override
    public String formatSOAPAction(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        if (msgCtxt.isSOAP11()) {
            if ("".equals(soapActionString)) {
                return "\"\"";
            }
            if (soapActionString != null && !soapActionString.startsWith("\"")) {
                soapActionString = "\"" + soapActionString + "\"";
            }
            return soapActionString;
        }
        return null;
    }

    @Override
    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, msgCtxt, false);
        return targetURL;
    }

    private void writeSwAMessage(MessageContext msgCtxt, OutputStream outputStream, OMOutputFormat format, boolean preserve) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start writeSwAMessage()");
        }
        Object property = msgCtxt.getProperty("MM7Compatible");
        boolean MM7CompatMode = false;
        if (property != null) {
            MM7CompatMode = JavaUtils.isTrueExplicitly(property);
        }
        try {
            OutputStream innerOutputStream;
            OMMultipartWriter attachmentsWriter;
            OMMultipartWriter mpw = new OMMultipartWriter(outputStream, format);
            OutputStream rootPartOutputStream = mpw.writeRootPart();
            SOAPEnvelope element = msgCtxt.getEnvelope();
            if (preserve) {
                element.serialize(rootPartOutputStream, format);
            } else {
                element.serializeAndConsume(rootPartOutputStream, format);
            }
            rootPartOutputStream.close();
            if (!MM7CompatMode) {
                attachmentsWriter = mpw;
                innerOutputStream = null;
            } else {
                Object innerBoundaryProperty = msgCtxt.getProperty("MM7InnerBoundary");
                String innerBoundary = innerBoundaryProperty != null ? (String)innerBoundaryProperty : "innerBoundary" + UIDGenerator.generateMimeBoundary();
                Object partCIDProperty = msgCtxt.getProperty("MM7PartCID");
                String partCID = partCIDProperty != null ? (String)partCIDProperty : "innerCID" + UIDGenerator.generateContentId();
                OMOutputFormat innerFormat = new OMOutputFormat(format);
                innerFormat.setMimeBoundary(innerBoundary);
                innerOutputStream = mpw.writePart("multipart/related; boundary=\"" + innerBoundary + "\"", partCID);
                attachmentsWriter = new OMMultipartWriter(innerOutputStream, innerFormat);
            }
            Attachments attachments = msgCtxt.getAttachmentMap();
            String[] stringArray = attachments.getAllContentIDs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentID = stringArray[n2];
                attachmentsWriter.writePart(attachments.getDataHandler(contentID), contentID);
                ++n2;
            }
            if (MM7CompatMode) {
                attachmentsWriter.complete();
                innerOutputStream.close();
            }
            mpw.complete();
        }
        catch (IOException ex) {
            throw AxisFault.makeFault(ex);
        }
        catch (XMLStreamException ex) {
            throw AxisFault.makeFault(ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end writeSwAMessage()");
        }
    }
}

