/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.axis2.jaxrs.JAXRSModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRSUtils {
    private static Log log = LogFactory.getLog(JAXRSModel.class);

    public static JAXRSModel getClassModel(Class serviceClass) {
        Annotation[] annotation;
        JAXRSModel model = new JAXRSModel();
        Annotation[] annotationArray = annotation = serviceClass.getAnnotations();
        int n = annotation.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a != null) {
                if (a instanceof Produces) {
                    JAXRSUtils.addProducesToClassModel((Produces)a, model);
                } else if (a instanceof Consumes) {
                    JAXRSUtils.addConsumesToClassModel((Consumes)a, model);
                } else if (a instanceof Path) {
                    JAXRSUtils.addPathToClassModel((Path)a, model);
                } else {
                    System.out.println("Could not identify the Annotation....");
                }
            }
            ++n2;
        }
        return model;
    }

    public static JAXRSModel getMethodModel(JAXRSModel classModel, Method serviceMethod) {
        Annotation[] annotation;
        JAXRSModel model = new JAXRSModel();
        JAXRSUtils.addProducesToMethodModel(classModel, model);
        JAXRSUtils.addConsumesToMethodModel(classModel, model);
        JAXRSUtils.addPathToMethodModel(classModel, model);
        Annotation[] annotationArray = annotation = serviceMethod.getAnnotations();
        int n = annotation.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a != null) {
                if (a instanceof Produces) {
                    JAXRSUtils.addProducesToMethodModel((Produces)a, model);
                } else if (a instanceof Consumes) {
                    JAXRSUtils.addConsumesToMethodModel((Consumes)a, model);
                } else if (a instanceof Path) {
                    JAXRSUtils.addPathToMethodModel((Path)a, model);
                } else {
                    JAXRSUtils.addHTTPMethodToMethodModel(a, model);
                }
            }
            ++n2;
        }
        return model;
    }

    private static void addProducesToClassModel(Produces produces, JAXRSModel classModel) {
        String[] array = null;
        String value = null;
        String[] stringArray = array = produces.value();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            value = value == null ? s : String.valueOf(value) + "," + s;
            ++n2;
        }
        classModel.setProduces(value);
    }

    private static void addConsumesToClassModel(Consumes consumes, JAXRSModel classModel) {
        String[] array = null;
        String value = null;
        String[] stringArray = array = consumes.value();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            value = value == null ? s : String.valueOf(value) + "," + s;
            ++n2;
        }
        classModel.setConsumes(value);
    }

    private static void addPathToClassModel(Path path, JAXRSModel classModel) {
        String value = null;
        value = path.value();
        if (value != null) {
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        classModel.setPath(value);
    }

    private static void addProducesToMethodModel(Produces produces, JAXRSModel methodModel) {
        String value = null;
        String[] stringArray = produces.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            value = value != null ? String.valueOf(value) + s : s;
            methodModel.setProduces(value);
            ++n2;
        }
    }

    private static void addProducesToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getProduces();
        if (value != null) {
            methodModel.setProduces(value);
        }
    }

    private static void addConsumesToMethodModel(Consumes consumes, JAXRSModel methodModel) {
        String value = null;
        String[] stringArray = consumes.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            value = value != null ? String.valueOf(value) + s : s;
            methodModel.setConsumes(value);
            ++n2;
        }
    }

    private static void addConsumesToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getConsumes();
        if (value != null) {
            methodModel.setConsumes(value);
        }
    }

    private static void addHTTPMethodToMethodModel(Annotation annotation, JAXRSModel methodModel) {
        if (annotation instanceof POST) {
            methodModel.setHTTPMethod("POST");
        } else if (annotation instanceof GET) {
            methodModel.setHTTPMethod("GET");
        } else if (annotation instanceof PUT) {
            methodModel.setHTTPMethod("PUT");
        } else if (annotation instanceof DELETE) {
            methodModel.setHTTPMethod("DELETE");
        } else if (annotation instanceof HEAD) {
            log.warn((Object)"HTTP Method HEAD is not supported by AXIS2");
        }
    }

    private static void addPathToMethodModel(Path path, JAXRSModel methodModel) {
        String value = path.value();
        if (value != null) {
            if (value.startsWith("/")) {
                value = value.substring(1);
            }
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        if (methodModel.getPath() != null) {
            methodModel.setPath(String.valueOf(methodModel.getPath()) + "/" + value);
        } else {
            methodModel.setPath(value);
        }
    }

    private static void addPathToMethodModel(JAXRSModel classModel, JAXRSModel methodModel) {
        String value = classModel.getPath();
        if (value != null) {
            methodModel.setPath(value);
        }
    }
}

