/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;

public class DocLitBareSchemaGenerator
extends DefaultSchemaGenerator {
    private static final Log log = LogFactory.getLog(DocLitBareSchemaGenerator.class);
    private HashMap<String, Method> processedParameters = new LinkedHashMap<String, Method>();

    public DocLitBareSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix, AxisService service) throws Exception {
        super(loader, className, schematargetNamespace, schematargetNamespacePrefix, service);
    }

    @Override
    protected Method[] processMethods(Method[] declaredMethods) throws Exception {
        ArrayList<Method> list = new ArrayList<Method>();
        Arrays.sort(declaredMethods, new DefaultSchemaGenerator.MathodComparator());
        LinkedHashMap<String, Method> uniqueMethods = new LinkedHashMap<String, Method>();
        Method[] methodArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName;
            Method jMethod = methodArray[n2];
            if (!(jMethod.isBridge() || jMethod.getDeclaringClass().getName().equals(Object.class.getName()) || this.excludeMethods.contains(methodName = jMethod.getName()))) {
                if (((HashMap)uniqueMethods).get(methodName) != null) {
                    log.warn((Object)("We don't support method overloading. Ignoring [" + methodName + "]"));
                } else if (Modifier.isPublic(jMethod.getModifiers())) {
                    Class<?> methodParameter;
                    XmlSchemaComplexType methodSchemaType;
                    XmlSchemaSequence sequence;
                    boolean addToService = false;
                    AxisOperation axisOperation = this.service.getOperation(new QName(methodName));
                    if (axisOperation == null) {
                        AxisMessage outMessage;
                        axisOperation = Utils.getAxisOperationForJmethod(jMethod);
                        if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(axisOperation.getMessageExchangePattern()) && (outMessage = axisOperation.getMessage("Out")) != null) {
                            outMessage.setName(String.valueOf(methodName) + "Result");
                        }
                        addToService = true;
                    }
                    list.add(jMethod);
                    this.processException(jMethod, axisOperation);
                    uniqueMethods.put(methodName, jMethod);
                    uniqueMethods.put(methodName, jMethod);
                    Class<?>[] paras = jMethod.getParameterTypes();
                    Type[] genericParameterTypes = jMethod.getGenericParameterTypes();
                    String[] parameterNames = this.methodTable.getParameterNames(methodName);
                    AxisMessage inMessage = axisOperation.getMessage("In");
                    if (inMessage != null) {
                        inMessage.setName(String.valueOf(methodName) + "RequestMessage");
                    }
                    Annotation[][] parameterAnnotation = jMethod.getParameterAnnotations();
                    if (paras.length > 1) {
                        sequence = new XmlSchemaSequence();
                        methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                        methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                        inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                        this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                        inMessage.setPartName(methodName);
                        int j = 0;
                        while (j < paras.length) {
                            methodParameter = paras[j];
                            String parameterName = this.getParameterName(parameterAnnotation, j, parameterNames);
                            if (!this.generateRequestSchema(methodParameter, parameterName, jMethod, sequence, genericParameterTypes[j])) {
                                ++j;
                                continue;
                            }
                            break;
                        }
                    } else if (paras.length == 1) {
                        if (paras[0].isArray()) {
                            sequence = new XmlSchemaSequence();
                            methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                            methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                            Class<?> methodParameter2 = paras[0];
                            inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                            this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                            inMessage.setPartName(methodName);
                            String parameterName = this.getParameterName(parameterAnnotation, 0, parameterNames);
                            if (this.generateRequestSchema(methodParameter2, parameterName, jMethod, sequence, genericParameterTypes[0])) {
                                break;
                            }
                        } else {
                            String parameterName = this.getParameterName(parameterAnnotation, 0, parameterNames);
                            methodParameter = paras[0];
                            Method processMethod = this.processedParameters.get(parameterName);
                            if (processMethod != null) {
                                throw new AxisFault("Inavalid Java class, there are two methods [" + processMethod.getName() + " and " + jMethod.getName() + " ]which have the same parameter names");
                            }
                            this.processedParameters.put(parameterName, jMethod);
                            if (methodParameter != null && Map.class.isAssignableFrom(methodParameter)) {
                                this.generateBareSchemaTypeForMap(parameterName, genericParameterTypes[0], null);
                            } else if (methodParameter != null && Collection.class.isAssignableFrom(methodParameter)) {
                                sequence = new XmlSchemaSequence();
                                methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                                methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                                this.generateBareSchemaTypeForCollection(sequence, genericParameterTypes[0], parameterName, methodName);
                                parameterName = methodName;
                            } else if (methodParameter != null && Document.class.isAssignableFrom(methodParameter)) {
                                this.generateBareSchemaTypeForDocument(null, parameterName);
                            } else {
                                this.generateSchemaForType(null, methodParameter, parameterName);
                            }
                            inMessage.setElementQName(this.typeTable.getQNamefortheType(parameterName));
                            inMessage.setPartName(parameterName);
                            inMessage.setWrapped(false);
                            this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(parameterName), axisOperation);
                        }
                    }
                    Class<?> returnType = jMethod.getReturnType();
                    Type genericReturnType = jMethod.getGenericReturnType();
                    String methodTypeName = String.valueOf(jMethod.getName()) + "Result";
                    String returnName = "return";
                    if (!"void".equals(jMethod.getReturnType().getName())) {
                        AxisMessage outMessage = axisOperation.getMessage("Out");
                        if (returnType.isArray()) {
                            methodSchemaType = this.createSchemaTypeForMethodPart(methodTypeName);
                            sequence = new XmlSchemaSequence();
                            methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                            if (this.nonRpcMethods.contains(methodName)) {
                                this.generateSchemaForType(sequence, null, returnName);
                            } else {
                                this.generateSchemaForType(sequence, returnType, returnName);
                            }
                        } else {
                            if (returnType != null && Document.class.isAssignableFrom(returnType)) {
                                this.generateBareSchemaTypeForDocument(null, methodTypeName);
                            } else if (returnType != null && Map.class.isAssignableFrom(returnType)) {
                                this.generateBareSchemaTypeForMap(methodTypeName, genericReturnType, null);
                            } else if (returnType != null && Collection.class.isAssignableFrom(returnType)) {
                                sequence = new XmlSchemaSequence();
                                methodSchemaType = this.createSchemaTypeForMethodPart(methodTypeName);
                                methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                                this.generateBareSchemaTypeForCollection(sequence, genericReturnType, returnName, methodName);
                            } else {
                                this.generateSchemaForType(null, returnType, methodTypeName);
                            }
                            outMessage.setWrapped(false);
                        }
                        outMessage.setElementQName(this.typeTable.getQNamefortheType(methodTypeName));
                        outMessage.setName(String.valueOf(methodName) + "ResponseMessage");
                        outMessage.setPartName(methodTypeName);
                        this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(methodTypeName), axisOperation);
                    }
                    if (addToService) {
                        this.service.addOperation(axisOperation);
                    }
                }
            }
            ++n2;
        }
        return list.toArray(new Method[list.size()]);
    }

    private boolean generateRequestSchema(Class<?> methodParameter, String parameterName, Method jMethod, XmlSchemaSequence sequence, Type genericParameterType) throws Exception {
        if (this.nonRpcMethods.contains(jMethod.getName())) {
            this.generateSchemaForType(sequence, null, jMethod.getName());
            return true;
        }
        if (methodParameter != null && Map.class.isAssignableFrom(methodParameter)) {
            this.generateBareSchemaTypeForMap(parameterName, genericParameterType, sequence);
        } else if (methodParameter != null && Collection.class.isAssignableFrom(methodParameter)) {
            this.generateBareSchemaTypeForCollection(sequence, genericParameterType, parameterName, jMethod.getName());
        } else if (methodParameter != null && Document.class.isAssignableFrom(methodParameter)) {
            this.generateBareSchemaTypeForDocument(sequence, parameterName);
        } else {
            this.generateSchemaForType(sequence, methodParameter, parameterName);
        }
        return false;
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, Class<?> type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArray();
        }
        if (isArrayType) {
            type = type.getComponentType();
        }
        if (AxisFault.class.getName().equals(type)) {
            return null;
        }
        String classTypeName = type == null ? "java.lang.Object" : type.getName();
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if (this.isDataHandler(type)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null && type != null) {
            schemaTypeName = this.generateSchema(type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
            if (sequence == null) {
                this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType);
            }
        } else if (sequence == null) {
            this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
        return schemaTypeName;
    }

    protected void generateSchemaForSingleElement(QName schemaTypeName, String paraName, boolean isArray) throws Exception {
        XmlSchemaElement elt1 = new XmlSchemaElement(this.getXmlSchema(this.schemaTargetNameSpace), false);
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        elt1.setNillable(true);
        QName elementName = new QName(this.schemaTargetNameSpace, paraName, this.schema_namespace_prefix);
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        xmlSchema.getElements().put(elementName, elt1);
        xmlSchema.getItems().add(elt1);
        this.typeTable.addComplexSchema(paraName, elementName);
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema, false);
            XmlSchemaElement globalElement = new XmlSchemaElement(xmlSchema, false);
            globalElement.setSchemaType((XmlSchemaType)complexType);
            globalElement.setName(localPartName);
            xmlSchema.getItems().add(globalElement);
            xmlSchema.getElements().put(elementName, globalElement);
        }
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    @Override
    protected XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
            xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        }
        return xmlSchema;
    }

    private void generateBareSchemaTypeForMap(String paraName, Type genericParameterType, XmlSchemaSequence sequence) throws Exception {
        QName schemaTypeName = this.generateSchemaTypeForMap(sequence, genericParameterType, paraName, false);
        if (sequence != null) {
            return;
        }
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaElement elt1 = new XmlSchemaElement(xmlSchema, false);
        elt1.setSchemaTypeName(schemaTypeName);
        elt1.setName(paraName);
        elt1.setNillable(true);
        QName elementName = new QName(this.schemaTargetNameSpace, paraName, this.schema_namespace_prefix);
        xmlSchema.getElements().put(elementName, elt1);
        xmlSchema.getItems().add(elt1);
        this.typeTable.addComplexSchema(paraName, elementName);
    }

    private void generateBareSchemaTypeForCollection(XmlSchemaSequence sequence, Type genericType, String partName, String methodName) throws Exception {
        QName schemaTypeName = this.generateSchemaForCollection(sequence, genericType, partName);
    }

    private void generateBareSchemaTypeForDocument(XmlSchemaSequence sequence, String parameterName) {
        QName schemaTypeName = this.generateSchemaTypeForDocument(sequence, parameterName);
        if (sequence != null) {
            return;
        }
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaElement elt1 = new XmlSchemaElement(xmlSchema, false);
        elt1.setSchemaTypeName(schemaTypeName);
        elt1.setName(parameterName);
        elt1.setNillable(true);
        QName elementName = new QName(this.schemaTargetNameSpace, parameterName, this.schema_namespace_prefix);
        xmlSchema.getElements().put(elementName, elt1);
        xmlSchema.getItems().add(elt1);
        this.typeTable.addComplexSchema(parameterName, elementName);
    }
}

