/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;

public class Version
implements Serializable,
Comparable<Version> {
    private static final String S_SNAPSHOT = "SNAPSHOT";
    public static final Version SNAPSHOT = new Version(null, "SNAPSHOT");
    private final int[] components;
    private final String qualifier;

    public Version(int[] components, String qualifier) {
        this.components = components == null ? null : (int[])components.clone();
        this.qualifier = qualifier;
    }

    public Version(String versionString) throws ParseException {
        if (versionString.equals(S_SNAPSHOT)) {
            this.components = null;
            this.qualifier = S_SNAPSHOT;
        } else {
            int dashIndex = versionString.indexOf(45);
            if (dashIndex != -1) {
                this.qualifier = versionString.substring(dashIndex + 1);
                versionString = versionString.substring(0, dashIndex);
            } else if (versionString.endsWith(".SNAPSHOT")) {
                this.qualifier = S_SNAPSHOT;
                versionString = versionString.substring(0, versionString.indexOf(".SNAPSHOT"));
            } else {
                this.qualifier = null;
            }
            String[] componentStrings = versionString.split("\\.");
            int l = componentStrings.length;
            this.components = new int[l];
            int i = 0;
            while (i < l) {
                this.components[i] = Integer.parseInt(componentStrings[i]);
                ++i;
            }
        }
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.components) + (this.qualifier == null ? 0 : this.qualifier.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return Arrays.equals(this.components, other.components) && (this.qualifier == other.qualifier || this.qualifier != null && this.qualifier.equals(other.qualifier));
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.components != null) {
            int i = 0;
            while (i < this.components.length) {
                if (i > 0) {
                    buffer.append('.');
                }
                buffer.append(this.components[i]);
                ++i;
            }
        }
        if (this.qualifier != null) {
            if (this.components != null) {
                buffer.append('-');
            }
            buffer.append(this.qualifier);
        }
        return buffer.toString();
    }

    @Override
    public int compareTo(Version o) {
        if (this.components == null && o.components != null) {
            return 1;
        }
        if (this.components != null && o.components == null) {
            return -1;
        }
        if (this.components == null && o.components == null) {
            return 0;
        }
        int l = Math.min(this.components.length, o.components.length);
        int i = 0;
        while (i < l) {
            int c = this.components[i] - o.components[i];
            if (c != 0) {
                return c;
            }
            ++i;
        }
        int c = this.components.length - o.components.length;
        if (c != 0) {
            return c;
        }
        if (this.qualifier == null && o.qualifier != null) {
            return 1;
        }
        if (this.qualifier != null && o.qualifier == null) {
            return -1;
        }
        if (this.qualifier == null && o.qualifier == null) {
            return 0;
        }
        boolean thisIsSnapshot = this.qualifier.equals(S_SNAPSHOT);
        boolean otherIsSnapshot = o.qualifier.equals(S_SNAPSHOT);
        if (thisIsSnapshot && !otherIsSnapshot) {
            return 1;
        }
        if (!thisIsSnapshot && thisIsSnapshot) {
            return -1;
        }
        if (thisIsSnapshot && otherIsSnapshot) {
            return 0;
        }
        return this.qualifier.compareToIgnoreCase(o.qualifier);
    }
}

