/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperationClient;
import org.apache.axis2.i18n.Messages;

public class OutOnlyAxisOperation
extends AxisOperation {
    protected static final String OUT_MESSAGE_KEY = "outMessage";
    private AxisMessage inFaultMessage;
    private ArrayList inPhases;
    private AxisMessage outFaultMessage;

    public OutOnlyAxisOperation() {
        QName tmpName = new QName(String.valueOf(this.getClass().getName()) + "_" + UIDGenerator.generateUID());
        this.setName(tmpName);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/out-only");
    }

    public OutOnlyAxisOperation(QName name) {
        super(name);
        this.createMessage();
        this.setMessageExchangePattern("http://www.w3.org/ns/wsdl/out-only");
    }

    @Override
    public void addMessage(AxisMessage message, String label) {
        if (!"Out".equals(label)) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.addChild(OUT_MESSAGE_KEY, message);
    }

    @Override
    public void addMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        if (opContext.isComplete()) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        opContext.getMessageContexts().put("Out", msgContext);
        opContext.setComplete(true);
    }

    @Override
    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap<String, MessageContext> mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    private void createMessage() {
        AxisMessage outMessage = new AxisMessage();
        outMessage.setDirection("out");
        outMessage.setParent(this);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.inPhases = new ArrayList();
        this.addChild(OUT_MESSAGE_KEY, outMessage);
    }

    private AxisMessage getOutMessage() {
        return (AxisMessage)this.getChild(OUT_MESSAGE_KEY);
    }

    @Override
    public AxisMessage getMessage(String label) {
        if ("Out".equals(label)) {
            return this.getOutMessage();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    @Override
    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    @Override
    public ArrayList getPhasesOutFlow() {
        return this.getOutMessage().getMessageFlow();
    }

    @Override
    public ArrayList getRemainingPhasesInFlow() {
        return this.inPhases;
    }

    @Override
    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    @Override
    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    @Override
    public void setPhasesOutFlow(ArrayList list) {
        this.getOutMessage().setMessageFlow(list);
    }

    @Override
    public void setRemainingPhasesInFlow(ArrayList list) {
        this.inPhases = list;
    }

    @Override
    public OperationClient createClient(ServiceContext sc, Options options) {
        return new OutOnlyAxisOperationClient(this, sc, options);
    }
}

