/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.ExcludeInfo;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.TempFileManager;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxrs.JAXRSModel;
import org.apache.axis2.util.FaultyServiceData;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.utils.NamespaceMap;

public class Utils {
    public static String defaultEncoding = new OutputStreamWriter(System.out).getEncoding();
    private static Log log = LogFactory.getLog(Utils.class);

    public static void addFlowHandlers(Flow flow, ClassLoader clsLoader) throws AxisFault {
        int count = flow.getHandlerCount();
        int j = 0;
        while (j < count) {
            HandlerDescription handlermd = flow.getHandler(j);
            final Class handlerClass = Utils.getHandlerClass(handlermd.getClassName(), clsLoader);
            try {
                Handler handler = (Handler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstantiationException, IllegalAccessException {
                        return handlerClass.newInstance();
                    }
                });
                handler.init(handlermd);
                handlermd.setHandler(handler);
            }
            catch (PrivilegedActionException e) {
                throw AxisFault.makeFault(e);
            }
            ++j;
        }
    }

    public static boolean loadHandler(ClassLoader loader1, HandlerDescription desc) throws DeploymentException {
        String handlername = desc.getClassName();
        try {
            final Class handlerClass = Loader.loadClass(loader1, handlername);
            Package aPackage = (Package)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return handlerClass.getPackage();
                }
            });
            if (aPackage != null && aPackage.getName().equals("org.apache.axis2.engine")) {
                String name = handlerClass.getName();
                log.warn((Object)("Dispatcher " + name + " is now deprecated."));
                if (name.indexOf("InstanceDispatcher") != -1) {
                    log.warn((Object)("Please remove the entry for " + handlerClass.getName() + "from axis2.xml"));
                } else {
                    log.warn((Object)"Please edit axis2.xml and replace with the same class in org.apache.axis2.dispatchers package");
                }
            }
            Handler handler = (Handler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException {
                    return handlerClass.newInstance();
                }
            });
            handler.init(desc);
            desc.setHandler(handler);
        }
        catch (ClassNotFoundException e) {
            if (handlername.indexOf("jaxws") > 0) {
                log.warn((Object)("[JAXWS] - unable to load " + handlername));
                return false;
            }
            throw new DeploymentException(e);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return true;
    }

    public static URL[] getURLsForAllJars(URL url, File tmpDir) {
        InputStream in = null;
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            ArrayList<URL> array = new ArrayList<URL>();
            in = url.openStream();
            if (url.getProtocol().equals("file")) {
                array.add(url);
            } else {
                String fileName = url.getFile();
                int index = fileName.lastIndexOf(47);
                if (index != -1) {
                    fileName = fileName.substring(index + 1);
                }
                final File f = Utils.createTempFile(fileName, in, tmpDir);
                in.close();
                in = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws FileNotFoundException {
                        return new FileInputStream(f);
                    }
                });
                array.add(f.toURI().toURL());
            }
            zin = new ZipInputStream(in);
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (entryName == null || !entryName.toLowerCase().startsWith("lib/") || !entryName.toLowerCase().endsWith(".jar")) continue;
                String suffix = entryName.substring(4);
                File f2 = Utils.createTempFile(suffix, zin, tmpDir);
                array.add(f2.toURI().toURL());
            }
            URL[] uRLArray = array.toArray(new URL[array.size()]);
            return uRLArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static File createTempFile(String suffix, InputStream in, File tmpDir) throws IOException {
        data = new byte[2048];
        f2 = f = TempFileManager.createTempFile("axis2", suffix);
        try {
            out = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(f2);
                }
            });
            if (true) ** GOTO lbl10
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        do {
            out.write(data, 0, count);
lbl10:
            // 2 sources

        } while ((count = in.read(data, 0, 2048)) != -1);
        out.close();
        return f;
    }

    public static ClassLoader getClassLoader(ClassLoader parent, String path, boolean isChildFirstClassLoading) throws DeploymentException {
        return Utils.getClassLoader(parent, new File(path), isChildFirstClassLoading);
    }

    public static ClassLoader getClassLoader(ClassLoader parent, File file, boolean isChildFirstClassLoading) throws DeploymentException {
        if (file == null) {
            return null;
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(file.toURI().toURL());
            File libfiles = new File(file, "lib");
            if (!Utils.addFiles(urls, libfiles)) {
                libfiles = new File(file, "Lib");
                Utils.addFiles(urls, libfiles);
            }
            URL[] urllist = new URL[urls.size()];
            int i = 0;
            while (i < urls.size()) {
                urllist[i] = urls.get(i);
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating class loader with the following libraries: " + Arrays.asList(urllist)));
            }
            return Utils.createDeploymentClassLoader(urllist, parent, isChildFirstClassLoading);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
    }

    private static boolean addFiles(ArrayList<URL> urls, final File libfiles) throws MalformedURLException {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return libfiles.exists();
            }
        });
        if (exists.booleanValue()) {
            urls.add(libfiles.toURI().toURL());
            File[] jarfiles = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return libfiles.listFiles();
                }
            });
            int i = 0;
            while (i < jarfiles.length) {
                File jarfile = jarfiles[i];
                if (jarfile.getName().endsWith(".jar")) {
                    urls.add(jarfile.toURI().toURL());
                }
                ++i;
            }
        }
        return exists;
    }

    private static Class getHandlerClass(String className, ClassLoader loader1) throws AxisFault {
        Class handlerClass;
        try {
            handlerClass = Loader.loadClass(loader1, className);
        }
        catch (ClassNotFoundException e) {
            throw AxisFault.makeFault(e);
        }
        return handlerClass;
    }

    public static void fillAxisService(AxisService axisService, AxisConfiguration axisConfig, ArrayList<String> excludeOperations, ArrayList<String> nonRpcMethods) throws Exception {
        Class<?> serviceClass = org.apache.axis2.util.Utils.getServiceClass(axisService);
        if (serviceClass == null) {
            return;
        }
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        Parameter generateBare = axisService.getParameter("doclitBare");
        DefaultSchemaGenerator schemaGenerator = generateBare != null && "true".equals(generateBare.getValue()) ? new DocLitBareSchemaGenerator(serviceClassLoader, serviceClass.getName(), axisService.getSchemaTargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService) : new DefaultSchemaGenerator(serviceClassLoader, serviceClass.getName(), axisService.getSchemaTargetNamespace(), axisService.getSchemaTargetNamespacePrefix(), axisService);
        schemaGenerator.setExcludeMethods(excludeOperations);
        schemaGenerator.setNonRpcMethods(nonRpcMethods);
        if (!axisService.isElementFormDefault()) {
            schemaGenerator.setElementFormDefault("unqualified");
        }
        schemaGenerator.setPkg2nsmap(axisService.getP2nMap());
        Collection<XmlSchema> schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if ("http://ws.apache.org/axis2".equals(axisService.getTargetNamespace())) {
            axisService.setTargetNamespace(schemaGenerator.getTargetNamespace());
        }
        Method[] method = schemaGenerator.getMethods();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        Method[] methodArray = method;
        int n = method.length;
        int n2 = 0;
        while (n2 < n) {
            MessageReceiver mr;
            Method jmethod = methodArray[n2];
            String opName = jmethod.getName();
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation == null) {
                operation = axisService.getOperation(new QName(jmethod.getName()));
            }
            if ((mr = axisService.getMessageReceiver(operation.getMessageExchangePattern())) == null) {
                mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
            }
            if (operation.getMessageReceiver() == null) {
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
            if (operation.getSoapAction() == null) {
                operation.setSoapAction("urn:" + opName);
            }
            ++n2;
        }
    }

    public static AxisOperation getAxisOperationForJmethod(Method method) throws AxisFault {
        AxisOperation operation = "void".equals(method.getReturnType().getName()) ? (method.getExceptionTypes().length > 0 ? AxisOperationFactory.getAxisOperation(12) : AxisOperationFactory.getAxisOperation(10)) : AxisOperationFactory.getAxisOperation(12);
        String opName = method.getName();
        operation.setName(new QName(opName));
        return operation;
    }

    public static OMElement getParameter(String name, String value, boolean locked) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement parameter = fac.createOMElement("parameter", null);
        parameter.addAttribute("name", name, null);
        parameter.addAttribute("locked", Boolean.toString(locked), null);
        parameter.setText(value);
        return parameter;
    }

    public static void deployModuleServices(AxisModule module, ConfigurationContext configCtx) throws AxisFault {
        try {
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            ArchiveReader archiveReader = new ArchiveReader();
            PhasesInfo phasesInfo = axisConfig.getPhasesInfo();
            final ClassLoader moduleClassLoader = module.getModuleClassLoader();
            ArrayList<String> services = new ArrayList<String>();
            final InputStream in = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return moduleClassLoader.getResourceAsStream("aars/aars.list");
                }
            });
            if (in != null) {
                try {
                    String line;
                    BufferedReader bufferedReader = new BufferedReader((InputStreamReader)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return new InputStreamReader(in);
                        }
                    }));
                    while ((line = bufferedReader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                        services.add(line);
                    }
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (services.size() > 0) {
                for (Object e : services) {
                    final String servicename = (String)e;
                    if (servicename == null || "".equals(servicename)) continue;
                    InputStream fin = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return moduleClassLoader.getResourceAsStream("aars/" + servicename);
                        }
                    });
                    if (fin == null) {
                        throw new AxisFault("No service archive found : " + servicename);
                    }
                    File inputFile = Utils.createTempFile(servicename, fin, (File)axisConfig.getParameterValue("artifactsDIR"));
                    DeploymentFileData filedata = new DeploymentFileData(inputFile);
                    filedata.setClassLoader(false, moduleClassLoader, (File)axisConfig.getParameterValue("artifactsDIR"), axisConfig.isChildFirstClassLoading());
                    HashMap<String, AxisService> wsdlservice = archiveReader.processWSDLs(filedata);
                    if (wsdlservice != null && wsdlservice.size() > 0) {
                        for (AxisService service : wsdlservice.values()) {
                            Iterator<AxisOperation> operations = service.getOperations();
                            while (operations.hasNext()) {
                                AxisOperation axisOperation = operations.next();
                                phasesInfo.setOperationPhases(axisOperation);
                            }
                        }
                    }
                    AxisServiceGroup serviceGroup = new AxisServiceGroup(axisConfig);
                    serviceGroup.setServiceGroupClassLoader(filedata.getClassLoader());
                    ArrayList<AxisService> serviceList = archiveReader.processServiceGroup(filedata.getAbsolutePath(), filedata, serviceGroup, false, wsdlservice, configCtx);
                    Iterator<AxisService> iterator = serviceList.iterator();
                    while (iterator.hasNext()) {
                        AxisService aServiceList;
                        AxisService axisService = aServiceList = iterator.next();
                        Parameter moduleService = new Parameter();
                        moduleService.setValue("true");
                        moduleService.setName("moduleService");
                        axisService.addParameter(moduleService);
                        serviceGroup.addService(axisService);
                    }
                    axisConfig.addServiceGroup(serviceGroup);
                    fin.close();
                }
            }
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static String normalize(String uri) {
        if ("".equals(uri)) {
            return uri;
        }
        int leadingSlashes = 0;
        while (leadingSlashes < uri.length() && uri.charAt(leadingSlashes) == '/') {
            ++leadingSlashes;
        }
        boolean isDir = uri.charAt(uri.length() - 1) == '/';
        StringTokenizer st = new StringTokenizer(uri, "/");
        LinkedList<String> clean = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("..".equals(token)) {
                if (!clean.isEmpty() && !"..".equals(clean.getLast())) {
                    clean.removeLast();
                    if (st.hasMoreTokens()) continue;
                    isDir = true;
                    continue;
                }
                clean.add("..");
                continue;
            }
            if (".".equals(token) || "".equals(token)) continue;
            clean.add(token);
        }
        StringBuffer sb = new StringBuffer();
        while (leadingSlashes-- > 0) {
            sb.append('/');
        }
        Iterator it = clean.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append('/');
        }
        if (isDir && sb.length() > 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    public static String getPath(String parent, String childPath) {
        String value;
        int n;
        int n2;
        String[] stringArray;
        String[] values;
        Stack<String> parentStack = new Stack<String>();
        Stack<String> childStack = new Stack<String>();
        if (parent != null && (values = parent.split("/")).length > 0) {
            stringArray = values;
            n2 = values.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                parentStack.push(value);
                ++n;
            }
        }
        if ((values = childPath.split("/")).length > 0) {
            stringArray = values;
            n2 = values.length;
            n = 0;
            while (n < n2) {
                value = stringArray[n];
                childStack.push(value);
                ++n;
            }
        }
        String filepath = "";
        while (!childStack.isEmpty()) {
            String value2 = (String)childStack.pop();
            if ("..".equals(value2)) {
                parentStack.pop();
                continue;
            }
            if ("".equals(value2)) continue;
            filepath = "".equals(filepath) ? value2 : String.valueOf(value2) + "/" + filepath;
        }
        while (!parentStack.isEmpty()) {
            String value3 = (String)parentStack.pop();
            if ("".equals(value3)) continue;
            filepath = String.valueOf(value3) + "/" + filepath;
        }
        return filepath;
    }

    public static void addExcludeMethods(List<String> excludeList) {
        excludeList.add("init");
        excludeList.add("setOperationContext");
        excludeList.add("startUp");
        excludeList.add("destroy");
        excludeList.add("shutDown");
    }

    public static DeploymentClassLoader createClassLoader(File serviceFile, boolean isChildFirstClassLoading) throws MalformedURLException {
        ClassLoader contextClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return Utils.createDeploymentClassLoader(new URL[]{serviceFile.toURI().toURL()}, contextClassLoader, isChildFirstClassLoading);
    }

    public static File toFile(URL url) throws UnsupportedEncodingException {
        String path = URLDecoder.decode(url.getPath(), defaultEncoding);
        return new File(path.replace('/', File.separatorChar).replace('|', ':'));
    }

    public static ClassLoader createClassLoader(URL archiveUrl, URL[] extraUrls, ClassLoader serviceClassLoader, File tmpDir, boolean isChildFirstClassLoading) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(Arrays.asList(Utils.getURLsForAllJars(archiveUrl, tmpDir)));
        if (extraUrls != null) {
            urls.addAll(Arrays.asList(extraUrls));
        }
        return Utils.createDeploymentClassLoader(urls.toArray(new URL[urls.size()]), serviceClassLoader, isChildFirstClassLoading);
    }

    private static DeploymentClassLoader createDeploymentClassLoader(final URL[] urls, final ClassLoader serviceClassLoader, final boolean isChildFirstClassLoading) {
        return java.security.AccessController.doPrivileged(new PrivilegedAction<DeploymentClassLoader>(){

            @Override
            public DeploymentClassLoader run() {
                return new DeploymentClassLoader(urls, serviceClassLoader, isChildFirstClassLoading);
            }
        });
    }

    public static void processBeanPropertyExclude(AxisService service) {
        Parameter excludeBeanProperty = service.getParameter("beanPropertyRules");
        if (excludeBeanProperty != null) {
            OMElement parameterElement = excludeBeanProperty.getParameterElement();
            Iterator bneasItr = parameterElement.getChildrenWithName(new QName("bean"));
            ExcludeInfo excludeInfo = new ExcludeInfo();
            while (bneasItr.hasNext()) {
                OMElement bean = (OMElement)bneasItr.next();
                String clazz = bean.getAttributeValue(new QName("class"));
                String excludePropertees = bean.getAttributeValue(new QName("excludeProperties"));
                String includeProperties = bean.getAttributeValue(new QName("includeProperties"));
                excludeInfo.putBeanInfo(clazz, new BeanExcludeInfo(excludePropertees, includeProperties));
            }
            service.setExcludeInfo(excludeInfo);
        }
    }

    public static String getShortFileName(String filename) {
        File file = new File(filename);
        return file.getName();
    }

    public static void addEndpointsToService(AxisService axisService) throws AxisFault {
        String serviceName = axisService.getName();
        Iterator<String> transportInValues = null;
        if (axisService.isEnableAllTransports()) {
            AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
            if (axisConfiguration != null) {
                ArrayList<String> transports = new ArrayList<String>();
                Iterator<TransportInDescription> iterator = axisConfiguration.getTransportsIn().values().iterator();
                while (iterator.hasNext()) {
                    TransportInDescription o;
                    TransportInDescription transportInDescription = o = iterator.next();
                    transports.add(transportInDescription.getName());
                }
                transportInValues = transports.iterator();
            }
        } else {
            transportInValues = axisService.getExposedTransports().iterator();
        }
        HashMap bindingCache = new HashMap();
        if (transportInValues != null) {
            while (transportInValues.hasNext()) {
                String transportName = transportInValues.next();
                String protocol = String.valueOf(transportName.substring(0, 1).toUpperCase()) + transportName.substring(1, transportName.length()).toLowerCase();
                String soap11EndpointName = String.valueOf(serviceName) + protocol + "Soap11Endpoint";
                AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
                httpSoap11Endpoint.setName(soap11EndpointName);
                httpSoap11Endpoint.setParent(axisService);
                httpSoap11Endpoint.setTransportInDescription(transportName);
                Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, bindingCache);
                axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
                axisService.setEndpointName(soap11EndpointName);
                String soap12EndpointName = String.valueOf(serviceName) + protocol + "Soap12Endpoint";
                AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
                httpSoap12Endpoint.setName(soap12EndpointName);
                httpSoap12Endpoint.setParent(axisService);
                httpSoap12Endpoint.setTransportInDescription(transportName);
                Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, bindingCache);
                axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
                if (!"http".equals(transportName)) continue;
                String httpEndpointName = String.valueOf(serviceName) + protocol + "Endpoint";
                AxisEndpoint httpEndpoint = new AxisEndpoint();
                httpEndpoint.setName(httpEndpointName);
                httpEndpoint.setParent(axisService);
                httpEndpoint.setTransportInDescription(transportName);
                Utils.populateHttpEndpoint(axisService, httpEndpoint, bindingCache);
                axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
            }
        }
    }

    public static void setEndpointsToAllUsedBindings(AxisService axisService) {
        HashMap<QName, AxisBinding> usedBindings = new HashMap<QName, AxisBinding>();
        AxisBinding axisBinding = null;
        for (AxisEndpoint axisEndpoint : axisService.getEndpoints().values()) {
            axisBinding = axisEndpoint.getBinding();
            if (usedBindings.containsKey(axisBinding.getName())) continue;
            usedBindings.put(axisBinding.getName(), axisBinding);
        }
        axisService.getEndpoints().clear();
        List<Object> availableTransports = new ArrayList();
        if (axisService.isEnableAllTransports()) {
            AxisConfiguration axisConfiguration = axisService.getAxisConfiguration();
            for (TransportInDescription transportIn : axisConfiguration.getTransportsIn().values()) {
                availableTransports.add(transportIn.getName());
            }
        } else {
            availableTransports = axisService.getExposedTransports();
        }
        for (AxisBinding usedAxisBinding : usedBindings.values()) {
            for (String string : availableTransports) {
                String bindingType = usedAxisBinding.getType();
                if ("http://www.w3.org/ns/wsdl/http".equals(bindingType) && !string.startsWith("http")) continue;
                AxisEndpoint axisEndpoint = new AxisEndpoint();
                axisEndpoint.setName(String.valueOf(axisService.getName()) + string + usedAxisBinding.getName().getLocalPart() + "Endpoint");
                axisEndpoint.setBinding(usedAxisBinding);
                axisEndpoint.setTransportInDescription(string);
                axisEndpoint.setParent(axisService);
                axisService.addEndpoint(axisEndpoint.getName(), axisEndpoint);
                axisService.setEndpointName(axisEndpoint.getName());
            }
        }
    }

    public static void addEndpointsToService(AxisService axisService, AxisConfiguration axisConfiguration) throws AxisFault {
        String serviceName = axisService.getName();
        Iterator transportInValues = null;
        if (axisConfiguration != null) {
            ArrayList<String> transports = new ArrayList<String>();
            Iterator<TransportInDescription> iterator = axisConfiguration.getTransportsIn().values().iterator();
            while (iterator.hasNext()) {
                TransportInDescription o;
                TransportInDescription transportInDescription = o = iterator.next();
                transports.add(transportInDescription.getName());
            }
            transportInValues = transports.iterator();
        }
        HashMap bindingCache = new HashMap();
        if (transportInValues != null) {
            while (transportInValues.hasNext()) {
                String transportName = (String)transportInValues.next();
                String protocol = String.valueOf(transportName.substring(0, 1).toUpperCase()) + transportName.substring(1, transportName.length()).toLowerCase();
                boolean disableREST = false;
                Parameter disableRESTParameter = axisService.getParameter("disableREST");
                if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
                    disableREST = true;
                }
                boolean disableSOAP11 = false;
                Parameter disableSOAP11Parameter = axisService.getParameter("disableSOAP11");
                if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP11Parameter.getValue())) {
                    disableSOAP11 = true;
                }
                boolean disableSOAP12 = false;
                Parameter disableSOAP12Parameter = axisService.getParameter("disableSOAP12");
                if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
                    disableSOAP12 = true;
                }
                if (!disableSOAP11) {
                    String soap11EndpointName = String.valueOf(serviceName) + protocol + "Soap11Endpoint";
                    AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
                    httpSoap11Endpoint.setName(soap11EndpointName);
                    httpSoap11Endpoint.setParent(axisService);
                    httpSoap11Endpoint.setTransportInDescription(transportName);
                    Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, bindingCache);
                    axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
                    axisService.setEndpointName(soap11EndpointName);
                }
                if (!disableSOAP12) {
                    String soap12EndpointName = String.valueOf(serviceName) + protocol + "Soap12Endpoint";
                    AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
                    httpSoap12Endpoint.setName(soap12EndpointName);
                    httpSoap12Endpoint.setParent(axisService);
                    httpSoap12Endpoint.setTransportInDescription(transportName);
                    Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, bindingCache);
                    axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
                }
                if (!"http".equals(transportName) && !"https".equals(transportName) || disableREST) continue;
                String httpEndpointName = String.valueOf(serviceName) + protocol + "Endpoint";
                AxisEndpoint httpEndpoint = new AxisEndpoint();
                httpEndpoint.setName(httpEndpointName);
                httpEndpoint.setParent(axisService);
                httpEndpoint.setTransportInDescription(transportName);
                Utils.populateHttpEndpoint(axisService, httpEndpoint, bindingCache);
                axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
            }
        }
    }

    private static String getEndpointName(AxisService axisService, String protocol, String soapVersion) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(axisService.getName());
        buffer.append(protocol.substring(0, 1).toUpperCase());
        buffer.append(protocol.substring(1, protocol.length()).toLowerCase());
        if (soapVersion != null) {
            buffer.append(soapVersion);
        }
        buffer.append("Endpoint");
        return buffer.toString();
    }

    public static void addSoap11Endpoint(AxisService axisService, String url) throws Exception {
        String protocol = org.apache.axis2.util.Utils.getURIScheme(url);
        String soap11EndpointName = Utils.getEndpointName(axisService, protocol, "Soap11");
        AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
        httpSoap11Endpoint.setName(soap11EndpointName);
        httpSoap11Endpoint.setParent(axisService);
        httpSoap11Endpoint.setEndpointURL(url.toString());
        httpSoap11Endpoint.setTransportInDescription(protocol);
        Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, null);
        axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
        axisService.setEndpointName(soap11EndpointName);
    }

    public static void addSoap11Endpoint(AxisService axisService, String protocol, String endpointName) throws Exception {
        AxisEndpoint httpSoap11Endpoint = new AxisEndpoint();
        httpSoap11Endpoint.setName(endpointName);
        httpSoap11Endpoint.setParent(axisService);
        httpSoap11Endpoint.setTransportInDescription(protocol);
        Utils.populateSoap11Endpoint(axisService, httpSoap11Endpoint, null);
        axisService.addEndpoint(httpSoap11Endpoint.getName(), httpSoap11Endpoint);
        axisService.setEndpointName(endpointName);
    }

    public static void addSoap12Endpoint(AxisService axisService, String url) throws Exception {
        String protocol = org.apache.axis2.util.Utils.getURIScheme(url);
        String soap12EndpointName = Utils.getEndpointName(axisService, protocol, "Soap12");
        AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
        httpSoap12Endpoint.setName(soap12EndpointName);
        httpSoap12Endpoint.setParent(axisService);
        httpSoap12Endpoint.setEndpointURL(url.toString());
        httpSoap12Endpoint.setTransportInDescription(protocol);
        Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, null);
        axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
    }

    public static void addSoap12Endpoint(AxisService axisService, String protocol, String endpointName) throws Exception {
        AxisEndpoint httpSoap12Endpoint = new AxisEndpoint();
        httpSoap12Endpoint.setName(endpointName);
        httpSoap12Endpoint.setParent(axisService);
        httpSoap12Endpoint.setTransportInDescription(protocol);
        Utils.populateSoap12Endpoint(axisService, httpSoap12Endpoint, null);
        axisService.addEndpoint(httpSoap12Endpoint.getName(), httpSoap12Endpoint);
    }

    public static void addHttpEndpoint(AxisService axisService, String url) {
        String protocol = org.apache.axis2.util.Utils.getURIScheme(url);
        String httpEndpointName = Utils.getEndpointName(axisService, protocol, null);
        AxisEndpoint httpEndpoint = new AxisEndpoint();
        httpEndpoint.setName(httpEndpointName);
        httpEndpoint.setParent(axisService);
        httpEndpoint.setEndpointURL(url.toString());
        httpEndpoint.setTransportInDescription(protocol);
        Utils.populateHttpEndpoint(axisService, httpEndpoint, null);
        axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
    }

    public static void addHttpEndpoint(AxisService axisService, String protocol, String endpointName) {
        AxisEndpoint httpEndpoint = new AxisEndpoint();
        httpEndpoint.setName(endpointName);
        httpEndpoint.setParent(axisService);
        httpEndpoint.setTransportInDescription(protocol);
        Utils.populateHttpEndpoint(axisService, httpEndpoint, null);
        axisService.addEndpoint(httpEndpoint.getName(), httpEndpoint);
    }

    public static void processPolicyAttachments(Iterator attachmentElements, AxisService service) throws XMLStreamException, FactoryConfigurationError {
        HashMap attachmentsMap = new HashMap();
        while (attachmentElements.hasNext()) {
            OMElement attachmentElement = (OMElement)attachmentElements.next();
            OMElement appliesToElem = null;
            Iterator it = attachmentElement.getChildElements();
            while (it.hasNext()) {
                OMElement elem = (OMElement)it.next();
                if (!Constants.isPolicyNS((String)elem.getNamespaceURI()) || !elem.getLocalName().equals("AppliesTo")) continue;
                appliesToElem = elem;
                break;
            }
            ArrayList<Object> policyComponents = new ArrayList<Object>();
            Iterator<OMElement> policyElements = PolicyUtil.getPolicyChildren(attachmentElement);
            while (policyElements.hasNext()) {
                Policy policy = PolicyUtil.getPolicyFromOMElement(policyElements.next());
                policyComponents.add(policy);
            }
            Iterator<OMElement> policyRefElements = PolicyUtil.getPolicyRefChildren(attachmentElement);
            while (policyRefElements.hasNext()) {
                PolicyReference policyRef = PolicyUtil.getPolicyReferenceFromOMElement(policyRefElements.next());
                policyComponents.add(policyRef);
            }
            Iterator policySubjects = appliesToElem.getChildrenWithName(new QName("policy-subject"));
            while (policySubjects.hasNext()) {
                OMElement policySubject = (OMElement)policySubjects.next();
                String identifier = policySubject.getAttributeValue(new QName("identifier"));
                ArrayList values = (ArrayList)attachmentsMap.get(identifier);
                if (values == null) {
                    values = new ArrayList();
                    attachmentsMap.put(identifier, values);
                }
                values.addAll(policyComponents);
            }
        }
        for (Object o : attachmentsMap.keySet()) {
            String identifier = (String)o;
            if (!identifier.startsWith("binding:soap")) continue;
            Utils.processSoapAttachments(identifier, (List)attachmentsMap.get(identifier), service);
        }
    }

    private static void populateSoap11Endpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = String.valueOf(serviceName) + "Soap11Binding";
        Parameter parameter = axisService.getParameter("soap11BindingName");
        if (parameter != null) {
            name = (String)parameter.getValue();
        }
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://schemas.xmlsoap.org/soap/http");
            axisBinding.setProperty("style", "document");
            axisBinding.setProperty("wsoap:version", "http://schemas.xmlsoap.org/soap/envelope/");
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                axisBindingOperation.setName(operation.getName());
                axisBindingOperation.setAxisOperation(operation);
                String soapAction = operation.getSoapAction();
                if (soapAction != null) {
                    axisBindingOperation.setProperty("wsoap:action", soapAction);
                }
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateSoap12Endpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = String.valueOf(serviceName) + "Soap12Binding";
        Parameter parameter = axisService.getParameter("soap12BindingName");
        if (parameter != null) {
            name = (String)parameter.getValue();
        }
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://schemas.xmlsoap.org/soap/http");
            axisBinding.setProperty("style", "document");
            axisBinding.setProperty("wsoap:version", "http://www.w3.org/2003/05/soap-envelope");
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                axisBindingOperation.setName(operation.getName());
                axisBindingOperation.setAxisOperation(operation);
                String soapAction = operation.getSoapAction();
                if (soapAction != null) {
                    axisBindingOperation.setProperty("wsoap:action", soapAction);
                }
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateHttpEndpoint(AxisService axisService, AxisEndpoint axisEndpoint, HashMap bindingCache) {
        AxisBinding axisBinding;
        String serviceName = axisService.getName();
        String name = String.valueOf(serviceName) + "HttpBinding";
        Parameter param = axisService.getParameter("restBindingName");
        if (param != null) {
            name = (String)param.getValue();
        }
        QName bindingName = new QName(name);
        AxisBinding axisBinding2 = axisBinding = bindingCache != null ? (AxisBinding)bindingCache.get(name) : null;
        if (axisBinding == null) {
            axisBinding = new AxisBinding();
            axisBinding.setName(bindingName);
            axisBinding.setType("http://www.w3.org/ns/wsdl/http");
            axisBinding.setProperty("whttp:method", "POST");
            TreeMap<String, AxisOperation> httpLocationMap = new TreeMap<String, AxisOperation>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return -1 * ((Comparable)o1).compareTo(o2);
                }
            });
            Iterator<? extends AxisDescription> iterator = axisService.getChildren();
            while (iterator.hasNext()) {
                AxisOperation operation = (AxisOperation)iterator.next();
                AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
                QName operationQName = operation.getName();
                axisBindingOperation.setName(operationQName);
                axisBindingOperation.setAxisOperation(operation);
                String httpLocation = operationQName.getLocalPart();
                String tempParam = null;
                String tempHTTPMethodParam = null;
                String tempHTTPLocationParam = null;
                Parameter parameter = operation.getParameter("JAXRSAnnotaion");
                JAXRSModel methodModel = parameter != null && parameter.getValue() instanceof JAXRSModel ? (JAXRSModel)parameter.getValue() : null;
                tempParam = Utils.getHTTPOutputSerializationFromservicesXML(operation);
                if (tempParam != null) {
                    axisBindingOperation.setProperty("whttp:outputSerialization", tempParam);
                } else if (methodModel != null && methodModel.getProduces() != null) {
                    axisBindingOperation.setProperty("whttp:outputSerialization", methodModel.getProduces());
                }
                tempParam = Utils.getHTTPInputSerializationFromServicesXML(operation);
                if (tempParam != null) {
                    axisBindingOperation.setProperty("whttp:inputSerialization", tempParam);
                } else if (methodModel != null && methodModel.getConsumes() != null) {
                    axisBindingOperation.setProperty("whttp:inputSerialization", methodModel.getConsumes());
                }
                tempHTTPMethodParam = Utils.getHTTPMethodFromServicesXML(operation);
                if (tempHTTPMethodParam != null) {
                    axisBindingOperation.setProperty("whttp:method", tempHTTPMethodParam);
                } else if (methodModel != null && (tempHTTPMethodParam = methodModel.getHTTPMethod()) != null) {
                    if (tempHTTPMethodParam.equals("HEAD")) {
                        log.warn((Object)("[JAXRS] http method HEAD is not supported by AXIS2  " + operation.getName()));
                        tempHTTPMethodParam = null;
                    } else {
                        axisBindingOperation.setProperty("whttp:method", tempHTTPMethodParam);
                    }
                }
                tempHTTPLocationParam = Utils.getHTTPLoacationFromServicesXML(operation);
                if (tempHTTPLocationParam == null) {
                    String string = tempHTTPLocationParam = methodModel != null ? methodModel.getPath() : null;
                }
                if (tempHTTPLocationParam != null && tempHTTPMethodParam != null) {
                    axisBindingOperation.setProperty("whttp:location", tempHTTPLocationParam);
                    httpLocationMap.put(WSDLUtil.getConstantFromHTTPLocation(tempHTTPLocationParam, tempHTTPMethodParam), operation);
                } else if (tempHTTPLocationParam != null && tempHTTPMethodParam == null) {
                    axisBindingOperation.setProperty("whttp:location", tempHTTPLocationParam);
                    httpLocationMap.put(WSDLUtil.getConstantFromHTTPLocation(tempHTTPLocationParam, "POST"), operation);
                } else if (tempHTTPLocationParam == null && tempHTTPMethodParam != null) {
                    axisBindingOperation.setProperty("whttp:location", httpLocation);
                    httpLocationMap.put(WSDLUtil.getConstantFromHTTPLocation(httpLocation, tempHTTPMethodParam), operation);
                } else {
                    axisBindingOperation.setProperty("whttp:location", httpLocation);
                }
                axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
                Utils.populateBindingOperation(axisBinding, axisBindingOperation);
                tempParam = null;
                tempHTTPMethodParam = null;
                tempHTTPLocationParam = null;
            }
            if (!httpLocationMap.isEmpty()) {
                axisBinding.setProperty("HTTPLocationTable", httpLocationMap);
            }
            if (bindingCache != null) {
                bindingCache.put(name, axisBinding);
            }
        }
        axisBinding.setParent(axisEndpoint);
        axisEndpoint.setBinding(axisBinding);
    }

    private static void populateBindingOperation(AxisBinding axisBinding, AxisBindingOperation axisBindingOperation) {
        AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
        if (WSDLUtil.isInputPresentForMEP(axisOperation.getMessageExchangePattern())) {
            AxisMessage axisInMessage = axisOperation.getMessage("In");
            AxisBindingMessage axisBindingInMessage = new AxisBindingMessage();
            axisBindingInMessage.setName(axisInMessage.getName());
            axisBindingInMessage.setDirection(axisInMessage.getDirection());
            axisBindingInMessage.setAxisMessage(axisInMessage);
            axisBindingInMessage.setParent(axisBindingOperation);
            axisBindingOperation.addChild("In", axisBindingInMessage);
        }
        if (WSDLUtil.isOutputPresentForMEP(axisOperation.getMessageExchangePattern())) {
            AxisMessage axisOutMessage = axisOperation.getMessage("Out");
            AxisBindingMessage axisBindingOutMessage = new AxisBindingMessage();
            axisBindingOutMessage.setName(axisOutMessage.getName());
            axisBindingOutMessage.setDirection(axisOutMessage.getDirection());
            axisBindingOutMessage.setAxisMessage(axisOutMessage);
            axisBindingOutMessage.setParent(axisBindingOperation);
            axisBindingOperation.addChild("Out", axisBindingOutMessage);
        }
        ArrayList<AxisMessage> faultMessagesList = axisOperation.getFaultMessages();
        Iterator<AxisMessage> iterator = faultMessagesList.iterator();
        while (iterator.hasNext()) {
            AxisMessage aFaultMessagesList;
            AxisMessage axisFaultMessage = aFaultMessagesList = iterator.next();
            AxisBindingMessage axisBindingFaultMessage = new AxisBindingMessage();
            axisBindingFaultMessage.setName(axisFaultMessage.getName());
            axisBindingFaultMessage.setFault(true);
            axisBindingFaultMessage.setAxisMessage(axisFaultMessage);
            axisBindingFaultMessage.setParent(axisBindingOperation);
            axisBindingOperation.addFault(axisBindingFaultMessage);
            axisBinding.addFault(axisBindingFaultMessage);
        }
        axisBindingOperation.setAxisOperation(axisOperation);
        axisBindingOperation.setParent(axisBinding);
    }

    private static void processSoapAttachments(String identifier, List policyComponents, AxisService service) {
        Map<String, AxisEndpoint> map = service.getEndpoints();
        String soapVersion = identifier.indexOf("soap12") > -1 ? "http://www.w3.org/2003/05/soap-envelope" : "http://schemas.xmlsoap.org/soap/envelope/";
        for (AxisEndpoint o : map.values()) {
            AxisEndpoint axisEndpoint = o;
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String wsoap = (String)axisBinding.getProperty("wsoap:version");
            if (!soapVersion.equals(wsoap)) continue;
            String[] identifiers = identifier.split("/");
            int key = identifiers.length;
            if (key == 1) {
                axisBinding.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if (key != 2 && key != 3) break;
            String opName = identifiers[1];
            opName = opName.substring(opName.indexOf(":") + 1, opName.length());
            AxisBindingOperation bindingOperation = null;
            boolean found = false;
            Iterator<AxisBindingOperation> i = axisBinding.getChildren();
            while (i.hasNext()) {
                bindingOperation = i.next();
                if (!opName.equals(bindingOperation.getName().getLocalPart())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("Invalid binding operation " + opName);
            }
            if (key == 2) {
                bindingOperation.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if ("in".equals(identifiers[2])) {
                AxisBindingMessage bindingInMessage = (AxisBindingMessage)bindingOperation.getChild("In");
                bindingInMessage.getPolicySubject().attachPolicyComponents(policyComponents);
                break;
            }
            if (!"out".equals(identifiers[2])) break;
            AxisBindingMessage bindingOutMessage = (AxisBindingMessage)bindingOperation.getChild("Out");
            bindingOutMessage.getPolicySubject().attachPolicyComponents(policyComponents);
            break;
        }
    }

    public static boolean isSoap11Binding(AxisBinding binding) {
        String v;
        String type = binding.getType();
        return ("http://schemas.xmlsoap.org/soap/http".equals(type) || "http://www.w3.org/ns/wsdl/soap".equals(type)) && "http://schemas.xmlsoap.org/soap/envelope/".equals(v = (String)binding.getProperty("wsoap:version"));
    }

    public static boolean isSoap12Binding(AxisBinding binding) {
        String v;
        String type = binding.getType();
        return ("http://schemas.xmlsoap.org/soap/http".equals(type) || "http://www.w3.org/ns/wsdl/soap".equals(type)) && "http://www.w3.org/2003/05/soap-envelope".equals(v = (String)binding.getProperty("wsoap:version"));
    }

    public static boolean isHttpBinding(AxisBinding binding) {
        String type = binding.getType();
        return "http://www.w3.org/ns/wsdl/http".equals(type);
    }

    public static AxisBinding getSoap11Binding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isSoap11Binding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBinding getSoap12Binding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isSoap12Binding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBinding getHttpBinding(AxisService service) {
        for (AxisEndpoint o : service.getEndpoints().values()) {
            AxisEndpoint endpoint = o;
            AxisBinding binding = endpoint.getBinding();
            if (!Utils.isHttpBinding(binding)) continue;
            return binding;
        }
        return null;
    }

    public static AxisBindingOperation getBindingOperation(AxisBinding binding, AxisOperation operation) {
        QName opName = operation.getName();
        Iterator<AxisBindingOperation> bindingOps = binding.getChildren();
        while (bindingOps.hasNext()) {
            AxisBindingOperation bindingOp = bindingOps.next();
            if (!opName.equals(bindingOp.getName())) continue;
            return bindingOp;
        }
        return null;
    }

    public static AxisBindingMessage getBindingMessage(AxisBindingOperation bindingOperation, AxisMessage message) {
        String msgName = message.getName();
        Iterator<? extends AxisDescription> bindingMessages = bindingOperation.getChildren();
        while (bindingMessages.hasNext()) {
            AxisBindingMessage bindingMessage = (AxisBindingMessage)bindingMessages.next();
            if (!msgName.equals(bindingMessage.getName())) continue;
            return bindingMessage;
        }
        return null;
    }

    public static String getHTTPLoacationFromServicesXML(AxisOperation operation) {
        Parameter locationParam = operation.getParameter("RESTLocation");
        if (locationParam != null && locationParam.getValue() != null && locationParam.getValue() instanceof String) {
            String location = ((String)locationParam.getValue()).trim();
            if (location.equals("")) {
                return null;
            }
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            return location;
        }
        return null;
    }

    public static String getHTTPMethodFromServicesXML(AxisOperation operation) {
        Parameter methodParam = operation.getParameter("RESTMethod");
        if (methodParam != null && methodParam.getValue() != null && methodParam.getValue() instanceof String) {
            String method = ((String)methodParam.getValue()).trim();
            if (method.equals("")) {
                return null;
            }
            if (method.equals("GET") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE")) {
                return method;
            }
            if (method.equals("HEAD")) {
                log.warn((Object)"Axis2 doesn't support httpMethod HEAD ");
                return null;
            }
            log.warn((Object)"cannot identify the HTTP method");
            return null;
        }
        return null;
    }

    public static String getHTTPInputSerializationFromServicesXML(AxisOperation operation) {
        Parameter inputSerializationParam = operation.getParameter("RESTInputSerialization");
        if (inputSerializationParam != null && inputSerializationParam.getValue() != null && inputSerializationParam.getValue() instanceof String) {
            String inputSerialization = ((String)inputSerializationParam.getValue()).trim();
            if (inputSerialization.equals("")) {
                return null;
            }
            String[] array = inputSerialization.split(",");
            if (array.length > 1) {
                log.warn((Object)"WSDL2 supports only one input-serialization");
                return array[0];
            }
            return array[0];
        }
        return null;
    }

    public static String getHTTPOutputSerializationFromservicesXML(AxisOperation operation) {
        Parameter outputSerializationParam = operation.getParameter("RESTOutputSerialization");
        if (outputSerializationParam != null && outputSerializationParam.getValue() != null && outputSerializationParam.getValue() instanceof String) {
            String outputSerialization = ((String)outputSerializationParam.getValue()).trim();
            if (outputSerialization.equals("")) {
                return null;
            }
            String[] array = outputSerialization.split(",");
            if (array.length > 1) {
                log.warn((Object)"WSDL2 supports only one input-serialization");
                return array[0];
            }
            return array[0];
        }
        return null;
    }

    public static void logFaultyServiceInfo(AxisConfiguration axisConfig) {
        Map<String, Map<String, FaultyServiceData>> faultyServices = axisConfig.getFaultyServicesDuetoModules();
        if (faultyServices != null && !faultyServices.isEmpty()) {
            for (String moduleName : faultyServices.keySet()) {
                Map<String, FaultyServiceData> faultyServicesDueToModule = faultyServices.get(moduleName);
                for (String s : faultyServicesDueToModule.keySet()) {
                    log.warn((Object)("Service :" + s + " is faulty, due to unavailability of the module :" + moduleName));
                }
            }
        }
    }

    public static String getServiceHierarchy(String filePath, String serviceDir) {
        if (filePath == null || serviceDir == null) {
            return "";
        }
        filePath = Utils.formatPath(filePath);
        String[] splited = filePath.split("/" + serviceDir + "/");
        String serviceHierarchy = null;
        if (splited.length > 1) {
            String temp = splited[splited.length - 1];
            if (temp.endsWith("/")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            if (temp.lastIndexOf(47) == -1) {
                return "";
            }
            serviceHierarchy = temp.substring(0, temp.lastIndexOf(47) + 1);
        }
        return serviceHierarchy;
    }

    public static String formatPath(String path) {
        path = path.replaceAll("\\b\\s+\\b", "%20");
        return path.replace('\\', '/');
    }

    public static String getClassNameFromResourceName(String resourceName) {
        if (!resourceName.endsWith(".class")) {
            throw new IllegalArgumentException("The resource name doesn't refer to a class file");
        }
        return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> getListOfClasses(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            ArrayList<String> classList = null;
            if (DeploymentFileData.isServiceArchiveFile(deploymentFileData.getAbsolutePath())) {
                try (FileInputStream fin = new FileInputStream(deploymentFileData.getAbsolutePath());){
                    ArrayList<String> arrayList;
                    ZipInputStream zin = new ZipInputStream(fin);
                    try {
                        ZipEntry entry;
                        classList = new ArrayList();
                        while ((entry = zin.getNextEntry()) != null) {
                            String name = entry.getName();
                            if (!name.endsWith(".class")) continue;
                            classList.add(Utils.getClassNameFromResourceName(name));
                        }
                        arrayList = classList;
                    }
                    catch (Throwable throwable) {
                        zin.close();
                        throw throwable;
                    }
                    zin.close();
                    return arrayList;
                }
            }
            File directory = deploymentFileData.getFile();
            classList = new ArrayList<String>();
            Iterator fileItr = FileUtils.iterateFiles((File)directory, (String[])new String[]{"class"}, (boolean)true);
            while (fileItr.hasNext()) {
                String fileName = ((File)fileItr.next()).getPath();
                String className = Utils.getClassNameFromResourceName(fileName.replace(directory.getPath(), "").substring(1));
                classList.add(className);
            }
            return classList;
        }
        catch (IOException e) {
            log.debug((Object)Messages.getMessage("deployingexception", e.getMessage()), (Throwable)e);
            throw new DeploymentException(e);
        }
    }
}

