/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileManager {
    private static final String TEMP_DIR_PREFIX = "axis2-tmp-";
    private static File sTmpDir = null;

    static {
        FileFilter tmpDirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith(TempFileManager.TEMP_DIR_PREFIX);
            }
        };
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File[] tmpFiles = tmpDir.listFiles(tmpDirFilter);
        if (tmpFiles != null) {
            File[] fileArray = tmpFiles;
            int n = tmpFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File tmpFile = fileArray[n2];
                File lockFile = new File(tmpFile.getParent(), String.valueOf(tmpFile.getName()) + ".lck");
                if (!lockFile.exists()) {
                    Logger.getLogger("default").log(Level.FINE, "TempFileManager::deleting old temp directory " + tmpFile);
                    try {
                        TempFileManager.recursiveDelete(tmpFile);
                    }
                    catch (IOException ex) {
                        Logger.getLogger("default").log(Level.INFO, "TempFileManager::unable to delete " + tmpFile.getAbsolutePath());
                        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                        ex.printStackTrace(new PrintStream(ostream));
                        Logger.getLogger("default").log(Level.FINE, ostream.toString());
                    }
                }
                ++n2;
            }
        }
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        if (sTmpDir == null) {
            String tmpDirName = System.getProperty("java.io.tmpdir");
            File tmpDir = File.createTempFile(TEMP_DIR_PREFIX, ".tmp", new File(tmpDirName));
            tmpDir.delete();
            File lockFile = new File(tmpDirName, String.valueOf(tmpDir.getName()) + ".lck");
            lockFile.createNewFile();
            lockFile.deleteOnExit();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Unable to create temporary directory:" + tmpDir.getAbsolutePath());
            }
            sTmpDir = tmpDir;
        }
        return File.createTempFile(prefix, suffix, sTmpDir);
    }

    public static void main(String[] args) {
        try {
            Class.forName(TempFileManager.class.getName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private static void recursiveDelete(File rootDir) throws IOException {
        File[] files = rootDir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    TempFileManager.recursiveDelete(file);
                } else if (!file.delete()) {
                    throw new IOException("Could not delete: " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
        if (!rootDir.delete()) {
            throw new IOException("Could not delete: " + rootDir.getAbsolutePath());
        }
    }
}

