/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.phaseresolver.PhaseException;

public class PhasesInfo {
    private List<Phase> INPhases = new ArrayList<Phase>();
    private List<Phase> IN_FaultPhases = new ArrayList<Phase>();
    private List<Phase> OUTPhases = new ArrayList<Phase>();
    private List<Phase> OUT_FaultPhases = new ArrayList<Phase>();

    private Phase copyPhase(Phase phase) throws DeploymentException {
        Phase newPhase = new Phase(phase.getPhaseName());
        Iterator<Handler> handlers = phase.getHandlers().iterator();
        while (handlers.hasNext()) {
            try {
                Handler handlerDescription = handlers.next();
                newPhase.addHandler(handlerDescription.getHandlerDesc());
            }
            catch (PhaseException e) {
                throw new DeploymentException(e);
            }
        }
        return newPhase;
    }

    HandlerDescription makeHandler(OMElement handlerElement) {
        String name = handlerElement.getAttributeValue(new QName("name"));
        QName qname = handlerElement.resolveQName(name);
        HandlerDescription desc = new HandlerDescription(qname.getLocalPart());
        String className = handlerElement.getAttributeValue(new QName("class"));
        desc.setClassName(className);
        return desc;
    }

    public Phase makePhase(OMElement phaseElement) throws PhaseException {
        String phaseName = phaseElement.getAttributeValue(new QName("name"));
        Phase phase = new Phase(phaseName);
        Iterator children = phaseElement.getChildElements();
        while (children.hasNext()) {
            OMElement handlerElement = (OMElement)children.next();
            HandlerDescription handlerDesc = this.makeHandler(handlerElement);
            phase.addHandler(handlerDesc);
        }
        return phase;
    }

    public List<Phase> getGlobalInflow() throws DeploymentException {
        ArrayList<Phase> globalphase = new ArrayList<Phase>();
        boolean foundDispatchPhase = false;
        int i = 0;
        while (i < this.INPhases.size()) {
            Phase phase = this.INPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!foundDispatchPhase) {
                if ("Dispatch".equals(phaseName)) {
                    foundDispatchPhase = true;
                }
                globalphase.add(phase);
            }
            ++i;
        }
        if (!foundDispatchPhase) {
            throw new DeploymentException(Messages.getMessage("dispatchPhaseNotFoundOnInflow"));
        }
        return globalphase;
    }

    public List<Phase> getGlobalOutPhaseList() throws DeploymentException {
        ArrayList<Phase> globalPhaseList = new ArrayList<Phase>();
        boolean messageOut = false;
        int i = 0;
        while (i < this.OUTPhases.size()) {
            Phase phase = this.OUTPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!messageOut) {
                if ("MessageOut".equals(phaseName)) {
                    messageOut = true;
                    globalPhaseList.add(this.copyPhase(phase));
                }
            } else {
                globalPhaseList.add(phase);
            }
            ++i;
        }
        return globalPhaseList;
    }

    public List<Phase> getINPhases() {
        return this.INPhases;
    }

    public List<Phase> getIN_FaultPhases() {
        return this.IN_FaultPhases;
    }

    public List<Phase> getOUTPhases() {
        return this.OUTPhases;
    }

    public List<Phase> getOutFaultPhaseList() {
        return this.OUT_FaultPhases;
    }

    public List<Phase> getOUT_FaultPhases() throws DeploymentException {
        ArrayList<Phase> globalPhaseList = new ArrayList<Phase>();
        boolean messageOut = false;
        int i = 0;
        while (i < this.OUT_FaultPhases.size()) {
            Phase phase = this.OUT_FaultPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!messageOut) {
                if ("MessageOut".equals(phaseName)) {
                    messageOut = true;
                    globalPhaseList.add(this.copyPhase(phase));
                }
            } else {
                globalPhaseList.add(this.copyPhase(phase));
            }
            ++i;
        }
        return globalPhaseList;
    }

    public List<Phase> getOperationInFaultPhases() throws DeploymentException {
        ArrayList<Phase> operationINPhases = new ArrayList<Phase>();
        boolean foundDispathPhase = false;
        int i = 0;
        while (i < this.IN_FaultPhases.size()) {
            Phase phase = this.IN_FaultPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (foundDispathPhase) {
                operationINPhases.add(this.copyPhase(phase));
            }
            if ("Dispatch".equals(phaseName)) {
                foundDispathPhase = true;
            }
            ++i;
        }
        return operationINPhases;
    }

    public List<Phase> getGlobalInFaultPhases() throws DeploymentException {
        ArrayList<Phase> globalInfaultphase = new ArrayList<Phase>();
        boolean foundDispatchPhase = false;
        int i = 0;
        while (i < this.IN_FaultPhases.size()) {
            Phase phase = this.IN_FaultPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (!foundDispatchPhase) {
                if ("Dispatch".equals(phaseName)) {
                    foundDispatchPhase = true;
                }
                globalInfaultphase.add(phase);
            }
            ++i;
        }
        if (!foundDispatchPhase) {
            throw new DeploymentException(Messages.getMessage("dispatchPhaseNotFoundOnInflow"));
        }
        return globalInfaultphase;
    }

    public ArrayList<Phase> getOperationInPhases() throws DeploymentException {
        ArrayList<Phase> operationINPhases = new ArrayList<Phase>();
        boolean foundDispathPhase = false;
        int i = 0;
        while (i < this.INPhases.size()) {
            Phase phase = this.INPhases.get(i);
            String phaseName = phase.getPhaseName();
            if (foundDispathPhase) {
                operationINPhases.add(this.copyPhase(phase));
            }
            if ("Dispatch".equals(phaseName)) {
                foundDispathPhase = true;
            }
            ++i;
        }
        return operationINPhases;
    }

    public ArrayList<Phase> getOperationOutFaultPhases() throws DeploymentException {
        ArrayList<Phase> operationFaultOutPhases = new ArrayList<Phase>();
        int i = 0;
        while (i < this.OUT_FaultPhases.size()) {
            Phase phase = this.OUT_FaultPhases.get(i);
            String phaseName = phase.getPhaseName();
            if ("MessageOut".equals(phaseName)) break;
            operationFaultOutPhases.add(this.copyPhase(phase));
            ++i;
        }
        return operationFaultOutPhases;
    }

    public ArrayList<Phase> getOperationOutPhases() throws DeploymentException {
        ArrayList<Phase> oprationOUTPhases = new ArrayList<Phase>();
        int i = 0;
        while (i < this.OUTPhases.size()) {
            Phase phase = this.OUTPhases.get(i);
            String phaseName = phase.getPhaseName();
            if ("MessageOut".equals(phaseName)) break;
            oprationOUTPhases.add(this.copyPhase(phase));
            ++i;
        }
        return oprationOUTPhases;
    }

    public void setINPhases(List<Phase> INPhases) {
        this.INPhases = INPhases;
    }

    public void setIN_FaultPhases(List<Phase> IN_FaultPhases) {
        this.IN_FaultPhases = IN_FaultPhases;
    }

    public void setOUTPhases(List<Phase> OUTPhases) {
        this.OUTPhases = OUTPhases;
    }

    public void setOUT_FaultPhases(List<Phase> OUT_FaultPhases) {
        this.OUT_FaultPhases = OUT_FaultPhases;
    }

    public void setOperationPhases(AxisOperation axisOperation) throws AxisFault {
        if (axisOperation != null) {
            try {
                axisOperation.setRemainingPhasesInFlow(this.getOperationInPhases());
                axisOperation.setPhasesOutFlow(this.getOperationOutPhases());
                axisOperation.setPhasesInFaultFlow(new ArrayList<Phase>(this.getOperationInFaultPhases()));
                axisOperation.setPhasesOutFaultFlow(this.getOperationOutFaultPhases());
            }
            catch (DeploymentException e) {
                throw AxisFault.makeFault(e);
            }
        }
    }
}

