/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Deployable;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModuleBuilder
extends DescriptionBuilder {
    private static final Log log = LogFactory.getLog(ModuleBuilder.class);
    private AxisModule module;

    public ModuleBuilder(InputStream serviceInputStream, AxisModule module, AxisConfiguration axisConfig) {
        super(serviceInputStream, axisConfig);
        this.module = module;
    }

    private void loadModuleClass(AxisModule module, String moduleClassName) throws DeploymentException {
        block4: {
            try {
                Class moduleClass;
                if (moduleClassName == null || "".equals(moduleClassName)) break block4;
                final Class fmoduleClass = moduleClass = Loader.loadClass(module.getModuleClassLoader(), moduleClassName);
                final AxisModule fmodule = module;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IllegalAccessException, InstantiationException {
                            Module new_module = (Module)fmoduleClass.newInstance();
                            fmodule.setModule(new_module);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (Exception e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    public void populateModule() throws DeploymentException {
        try {
            OMElement localPolicyAssertionElement;
            Iterator<OMElement> policyRefElements;
            OMElement descriptionElement;
            String moduleName;
            OMAttribute nameAtt;
            String moduleClass;
            OMElement moduleElement = this.buildOM();
            OMAttribute moduleClassAtt = moduleElement.getAttribute(new QName("class"));
            Iterator itr = moduleElement.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, this.module, this.module.getParent());
            Parameter childFirstClassLoading = this.module.getParameter("EnableChildFirstClassLoading");
            if (childFirstClassLoading != null) {
                DeploymentClassLoader deploymentClassLoader = (DeploymentClassLoader)this.module.getModuleClassLoader();
                if (JavaUtils.isTrueExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(true);
                } else if (JavaUtils.isFalseExplicitly(childFirstClassLoading.getValue())) {
                    deploymentClassLoader.setChildFirstClassLoading(false);
                }
            }
            if (moduleClassAtt != null && (moduleClass = moduleClassAtt.getAttributeValue()) != null && !"".equals(moduleClass)) {
                this.loadModuleClass(this.module, moduleClass);
            }
            if ((nameAtt = moduleElement.getAttribute(new QName("name"))) != null && (moduleName = nameAtt.getAttributeValue()) != null && !"".equals(moduleName)) {
                this.module.setName(moduleName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("populateModule: Building module description for: " + this.module.getName()));
            }
            if ((descriptionElement = moduleElement.getFirstChildWithName(new QName("description"))) == null) {
                descriptionElement = moduleElement.getFirstChildWithName(new QName("Description"));
            }
            if (descriptionElement != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize((Writer)writer);
                    writer.flush();
                    this.module.setModuleDescription(writer.toString());
                } else {
                    this.module.setModuleDescription(descriptionElement.getText());
                }
            } else {
                this.module.setModuleDescription("module description not found");
            }
            Iterator phaseItr = moduleElement.getChildrenWithName(new QName("phase"));
            this.processModulePhase(phaseItr);
            Iterator<OMElement> policyElements = PolicyUtil.getPolicyChildren(moduleElement);
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, this.module.getPolicySubject());
            }
            if ((policyRefElements = PolicyUtil.getPolicyRefChildren(moduleElement)) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, this.module.getPolicySubject());
            }
            Iterator flows = moduleElement.getChildElements();
            while (flows.hasNext()) {
                OMElement flowElement = (OMElement)flows.next();
                String flowName = flowElement.getLocalName();
                if (flowName.compareToIgnoreCase("InFlow") == 0) {
                    this.module.setInFlow(this.processFlow(flowElement, this.module));
                    continue;
                }
                if (flowName.compareToIgnoreCase("OutFlow") == 0) {
                    this.module.setOutFlow(this.processFlow(flowElement, this.module));
                    continue;
                }
                if (flowName.compareToIgnoreCase("InFaultFlow") == 0) {
                    this.module.setFaultInFlow(this.processFlow(flowElement, this.module));
                    continue;
                }
                if (flowName.compareToIgnoreCase("OutFaultFlow") != 0) continue;
                this.module.setFaultOutFlow(this.processFlow(flowElement, this.module));
            }
            OMElement supportedPolicyNamespaces = moduleElement.getFirstChildWithName(new QName("supported-policy-namespaces"));
            if (supportedPolicyNamespaces != null) {
                this.module.setSupportedPolicyNamespaces(this.processSupportedPolicyNamespaces(supportedPolicyNamespaces));
            }
            if ((localPolicyAssertionElement = moduleElement.getFirstChildWithName(new QName("local-policy-assertions"))) != null) {
                this.module.setLocalPolicyAssertions(this.getLocalPolicyAssertionNames(localPolicyAssertionElement));
            }
            Iterator op_itr = moduleElement.getChildrenWithName(new QName("operation"));
            List<AxisOperation> operations = this.processOperations(op_itr);
            for (AxisOperation op : operations) {
                this.module.addOperation(op);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"populateModule: Done building module description");
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        catch (AxisFault e) {
            throw new DeploymentException(e);
        }
    }

    private List<AxisOperation> processOperations(Iterator<?> operationsIterator) throws DeploymentException {
        ArrayList<AxisOperation> operations = new ArrayList<AxisOperation>();
        while (operationsIterator.hasNext()) {
            Iterator<OMElement> policyRefElements;
            AxisOperation op_descrip;
            OMElement operation = (OMElement)operationsIterator.next();
            String opname = operation.getAttributeValue(new QName("name"));
            if (opname == null) {
                throw new DeploymentException(Messages.getMessage(Messages.getMessage("invalid_op", "operation name missing")));
            }
            String mepURL = operation.getAttributeValue(new QName("mep"));
            if (mepURL == null) {
                op_descrip = new InOnlyAxisOperation();
            } else {
                try {
                    op_descrip = AxisOperationFactory.getOperationDescription(mepURL);
                }
                catch (AxisFault axisFault) {
                    throw new DeploymentException(Messages.getMessage(Messages.getMessage("op_error", axisFault.getMessage())));
                }
            }
            op_descrip.setName(new QName(opname));
            OMAttribute op_allowOverride_att = operation.getAttribute(new QName("allowOverride"));
            if (op_allowOverride_att != null) {
                try {
                    op_descrip.addParameter("allowOverride", op_allowOverride_att.getAttributeValue());
                }
                catch (AxisFault axisFault) {
                    throw new DeploymentException(Messages.getMessage(Messages.getMessage("parameterlockederror", axisFault.getMessage())));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processOperations: allowOverride set to " + op_allowOverride_att.getAttributeValue() + " for operation: " + opname));
                }
            }
            Iterator parameters = operation.getChildrenWithName(new QName("parameter"));
            this.processParameters(parameters, op_descrip, this.module);
            this.processActionMappings(operation, op_descrip);
            OMElement receiverElement = operation.getFirstChildWithName(new QName("messageReceiver"));
            if (receiverElement != null) {
                MessageReceiver messageReceiver = this.loadMessageReceiver(this.module.getModuleClassLoader(), receiverElement);
                op_descrip.setMessageReceiver(messageReceiver);
            } else {
                MessageReceiver msgReceiver = this.loadDefaultMessageReceiver(mepURL, null);
                op_descrip.setMessageReceiver(msgReceiver);
            }
            Iterator modules = operation.getChildrenWithName(new QName("module"));
            this.processOperationModuleRefs(modules, op_descrip);
            Iterator<OMElement> policyElements = PolicyUtil.getPolicyChildren(operation);
            if (policyElements != null && policyElements.hasNext()) {
                this.processPolicyElements(policyElements, op_descrip.getPolicySubject());
            }
            if ((policyRefElements = PolicyUtil.getPolicyRefChildren(operation)) != null && policyRefElements.hasNext()) {
                this.processPolicyRefElements(policyRefElements, this.module.getPolicySubject());
            }
            PhasesInfo info = this.axisConfig.getPhasesInfo();
            try {
                info.setOperationPhases(op_descrip);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException(axisFault);
            }
            operations.add(op_descrip);
        }
        return operations;
    }

    /*
     * Unable to fully structure code
     */
    private void processModulePhase(Iterator<OMElement> phases) throws AxisFault {
        if (phases != null) ** GOTO lbl48
        return;
lbl-1000:
        // 1 sources

        {
            element = phases.next();
            phaseName = element.getAttributeValue(new QName("name"));
            d = new Deployable(phaseName);
            after = element.getAttributeValue(new QName("after"));
            if (after != null) {
                var10_14 = afters = after.split(",");
                var9_11 = afters.length;
                var8_9 = 0;
                while (var8_9 < var9_11) {
                    s = var10_14[var8_9];
                    d.addPredecessor(s);
                    ++var8_9;
                }
            }
            if ((before = element.getAttributeValue(new QName("before"))) != null) {
                var11_17 = befores = before.split(",");
                var10_15 = befores.length;
                var9_11 = 0;
                while (var9_11 < var10_15) {
                    s = var11_17[var9_11];
                    d.addSuccessor(s);
                    ++var9_11;
                }
            }
            if ((flowName = element.getAttributeValue(new QName("flow"))) == null) {
                throw new DeploymentException("Flow can not be null for the phase name " + phaseName);
            }
            var12_18 = flows = flowName.split(",");
            var11_16 = flows.length;
            var10_13 = 0;
            while (var10_13 < var11_16) {
                flow = var12_18[var10_13];
                if ("InFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 1;
                } else if ("OutFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 2;
                } else if ("OutFaultFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 4;
                } else if ("InFaultFlow".equalsIgnoreCase(flow)) {
                    flowIndex = 3;
                } else {
                    throw new DeploymentException("Unknown flow name '" + flow + "'");
                }
                this.axisConfig.insertPhase(d, flowIndex);
                ++var10_13;
            }
lbl48:
            // 2 sources

            ** while (phases.hasNext())
        }
lbl49:
        // 1 sources

    }
}

