/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static final Log log = LogFactory.getLog(FileSystemConfigurator.class);
    private String axis2xml = null;
    private String repoLocation = null;

    public FileSystemConfigurator(String repoLocation, String axis2xml) throws AxisFault {
        if (repoLocation == null) {
            repoLocation = System.getProperty("axis2.repo");
        }
        if (repoLocation != null) {
            File repo = new File(repoLocation);
            if (repo.exists()) {
                this.repoLocation = repo.getAbsolutePath();
            } else {
                log.info((Object)("Couldn't find repository location '" + repoLocation + "'"));
                throw new AxisFault("Couldn't find repository location '" + repoLocation + "'");
            }
        }
        if (axis2xml == null) {
            File configFile;
            axis2xml = System.getProperty("axis2.xml");
            if (axis2xml == null && repoLocation != null) {
                axis2xml = String.valueOf(repoLocation) + File.separator + "axis2.xml";
            }
            if (axis2xml != null && !(configFile = new File(axis2xml)).exists()) {
                log.debug((Object)("Config file '" + axis2xml + "' doesn't exist, ignoring."));
                axis2xml = null;
            }
        }
        this.axis2xml = axis2xml;
    }

    @Override
    public synchronized AxisConfiguration getAxisConfiguration() throws AxisFault {
        InputStream configStream = null;
        try {
            try {
                configStream = this.axis2xml != null && !"".equals(this.axis2xml) ? new FileInputStream(this.axis2xml) : Loader.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
                this.axisConfig = this.populateAxisConfiguration(configStream);
            }
            catch (FileNotFoundException e) {
                throw new AxisFault("System can not find the given axis2.xml " + this.axis2xml);
            }
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    throw AxisFault.makeFault(e);
                }
            }
        }
        Parameter axis2repoPara = this.axisConfig.getParameter("repository");
        if (axis2repoPara != null) {
            this.repoLocation = (String)axis2repoPara.getValue();
        }
        if (this.repoLocation != null && !"".equals(this.repoLocation)) {
            this.loadRepository(this.repoLocation);
        } else {
            this.loadFromClassPath();
        }
        this.axisConfig.setConfigurator(this);
        return this.axisConfig;
    }

    @Override
    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    @Override
    public void loadServices() {
        if (this.repoLocation != null && !"".equals(this.repoLocation)) {
            super.loadServices();
        }
    }
}

