/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.externalize.DebugObjectInput;
import org.apache.axis2.context.externalize.ObjectInputStreamWithCL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeObjectInputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final Log log = LogFactory.getLog(SafeObjectInputStream.class);
    private static final boolean isDebug = log.isDebugEnabled();
    ObjectInput in = null;
    final ObjectInput original;
    private byte[] buffer = null;
    private static final int BUFFER_MIN_SIZE = 4096;

    public static SafeObjectInputStream install(ObjectInput in) {
        if (in instanceof SafeObjectInputStream) {
            return (SafeObjectInputStream)in;
        }
        return new SafeObjectInputStream(in);
    }

    private SafeObjectInputStream(ObjectInput in) {
        this.original = in;
        this.in = log.isDebugEnabled() ? new DebugObjectInput(this.original) : this.original;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.readObjectOverride();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    public HashMap readHashMap() throws IOException {
        HashMap hashMap = new HashMap();
        return (HashMap)this.readMap(hashMap);
    }

    /*
     * Unable to fully structure code
     */
    public Map readMap(Map map) throws IOException {
        isActive = this.in.readBoolean();
        if (isActive) ** GOTO lbl34
        return null;
lbl-1000:
        // 1 sources

        {
            key = null;
            value = null;
            isObjectForm = this.in.readBoolean();
            try {
                if (isObjectForm) {
                    if (SafeObjectInputStream.isDebug) {
                        SafeObjectInputStream.log.debug((Object)" reading using object form");
                    }
                    key = this.in.readObject();
                    value = this.in.readObject();
                } else {
                    if (SafeObjectInputStream.isDebug) {
                        SafeObjectInputStream.log.debug((Object)" reading using byte form");
                    }
                    bais = this.getByteStream(this.in);
                    tempOIS = this.createObjectInputStream(bais);
                    key = tempOIS.readObject();
                    value = tempOIS.readObject();
                    tempOIS.close();
                    bais.close();
                }
                if (SafeObjectInputStream.isDebug) {
                    SafeObjectInputStream.log.debug((Object)("Read key=" + this.valueName(key) + " value=" + this.valueName(value)));
                }
                map.put(key, value);
                continue;
            }
            catch (ClassNotFoundException e) {
                SafeObjectInputStream.log.error((Object)e);
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
lbl34:
            // 3 sources

            ** while (this.in.readBoolean())
        }
lbl35:
        // 1 sources

        return map;
    }

    public ArrayList readArrayList() throws IOException {
        ArrayList ll = new ArrayList();
        return (ArrayList)this.readList(ll);
    }

    public LinkedList readLinkedList() throws IOException {
        LinkedList ll = new LinkedList();
        return (LinkedList)this.readList(ll);
    }

    /*
     * Unable to fully structure code
     */
    public List readList(List list) throws IOException {
        isActive = this.in.readBoolean();
        if (isActive) ** GOTO lbl27
        return null;
lbl-1000:
        // 1 sources

        {
            isObjectForm = this.in.readBoolean();
            try {
                if (isObjectForm) {
                    if (SafeObjectInputStream.isDebug) {
                        SafeObjectInputStream.log.debug((Object)" reading using object form");
                    }
                    value = this.in.readObject();
                } else {
                    if (SafeObjectInputStream.isDebug) {
                        SafeObjectInputStream.log.debug((Object)" reading using byte form");
                    }
                    bais = this.getByteStream(this.in);
                    tempOIS = this.createObjectInputStream(bais);
                    value = tempOIS.readObject();
                    tempOIS.close();
                    bais.close();
                }
                if (SafeObjectInputStream.isDebug) {
                    SafeObjectInputStream.log.debug((Object)("Read value=" + this.valueName(value)));
                }
                list.add(value);
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
lbl27:
            // 2 sources

            ** while (this.in.readBoolean())
        }
lbl28:
        // 1 sources

        return list;
    }

    private Object readObjectOverride() throws IOException, ClassNotFoundException {
        boolean isActive = this.in.readBoolean();
        if (!isActive) {
            if (isDebug) {
                log.debug((Object)"Read object=null");
            }
            return null;
        }
        Object obj = null;
        boolean isObjectForm = this.in.readBoolean();
        if (isObjectForm) {
            if (isDebug) {
                log.debug((Object)" reading using object form");
            }
            obj = this.in.readObject();
        } else {
            if (isDebug) {
                log.debug((Object)" reading using byte form");
            }
            ByteArrayInputStream bais = this.getByteStream(this.in);
            ObjectInputStream tempOIS = this.createObjectInputStream(bais);
            obj = tempOIS.readObject();
            tempOIS.close();
            bais.close();
        }
        if (isDebug) {
            log.debug((Object)("Read object=" + this.valueName(obj)));
        }
        return obj;
    }

    private String valueName(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "Object of class = " + obj.getClass().getName();
    }

    private ByteArrayInputStream getByteStream(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (this.buffer == null || this.buffer.length < size) {
            int allocSize = size > 4096 ? size : 4096;
            this.buffer = new byte[allocSize];
        }
        in.readFully(this.buffer, 0, size);
        return new ByteArrayInputStream(this.buffer, 0, size);
    }

    private ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithCL(is);
    }
}

