/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.kernel.TransportListener;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivateUtils {
    private static final Log log = LogFactory.getLog(ActivateUtils.class);
    private static final String EXTERNALIZED_AXIS_SERVICE_NAME = "org.apache.axis2.context.externalize.AxisServiceName";
    private static String DELIMITER_SERVICE_PORT = " ";

    private ActivateUtils() {
    }

    public static AxisServiceGroup findServiceGroup(AxisConfiguration axisConfig, String serviceGrpClassName, String serviceGrpName) {
        Iterator<AxisServiceGroup> its = axisConfig.getServiceGroups();
        while (its.hasNext()) {
            AxisServiceGroup checkServiceGroup = its.next();
            String tmpSGClassName = checkServiceGroup.getClass().getName();
            String tmpSGName = checkServiceGroup.getServiceGroupName();
            if (!tmpSGClassName.equals(serviceGrpClassName)) continue;
            boolean found = false;
            if (tmpSGName == null && serviceGrpName == null) {
                found = true;
            } else if (tmpSGName != null && tmpSGName.equals(serviceGrpName)) {
                found = true;
            } else if (ActivateUtils.containsExternalizedAxisServiceName(checkServiceGroup, serviceGrpName)) {
                found = true;
            }
            if (!found) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findServiceGroup(): returning  [" + serviceGrpClassName + "]   [" + serviceGrpName + "]"));
            }
            return checkServiceGroup;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findServiceGroup(): [" + serviceGrpClassName + "]   [" + serviceGrpName + "]  returning  [null]"));
        }
        return null;
    }

    private static boolean containsExternalizedAxisServiceName(AxisServiceGroup checkServiceGroup, String serviceGrpName) {
        boolean containsAxisService = false;
        if (serviceGrpName != null && checkServiceGroup != null) {
            Iterator<AxisService> axisServicesInGroup = checkServiceGroup.getServices();
            while (axisServicesInGroup.hasNext()) {
                AxisService checkService = axisServicesInGroup.next();
                String externalizedServiceName = (String)checkService.getParameterValue(EXTERNALIZED_AXIS_SERVICE_NAME);
                if (externalizedServiceName == null || !externalizedServiceName.equals(serviceGrpName)) continue;
                containsAxisService = true;
                break;
            }
        }
        return containsAxisService;
    }

    public static AxisService findService(AxisConfiguration axisConfig, String serviceClassName, String serviceName) {
        return ActivateUtils.findService(axisConfig, serviceClassName, serviceName, null);
    }

    public static AxisService findService(AxisConfiguration axisConfig, String serviceClassName, String serviceName, String extraName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ActivateUtils.findService serviceName: " + serviceName + ", extraName: " + extraName));
        }
        HashMap<String, AxisService> services = axisConfig.getServices();
        Iterator<AxisService> its = services.values().iterator();
        boolean exactServiceNameMatch = false;
        AxisDescription foundService = null;
        while (its.hasNext() && !exactServiceNameMatch) {
            AxisService service = its.next();
            switch (ActivateUtils.checkAxisService(service, serviceClassName, serviceName, extraName)) {
                case NAME_MATCH: {
                    foundService = service;
                    exactServiceNameMatch = true;
                    break;
                }
                case SERVICE_PORT_MATCH: {
                    if (foundService != null) break;
                    foundService = service;
                    break;
                }
            }
        }
        if (foundService != null) {
            block11: {
                try {
                    foundService.addParameter(EXTERNALIZED_AXIS_SERVICE_NAME, serviceName);
                }
                catch (AxisFault e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)("Got fault trying to add parameter org.apache.axis2.context.externalize.AxisServiceName for service name " + serviceName + " to AxisService " + foundService), (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findService(): returning  [" + serviceClassName + "]   [" + serviceName + "] AxisService name [" + ((AxisService)foundService).getName() + "]"));
            }
            return foundService;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findService(): [" + serviceClassName + "]   [" + serviceName + "]  returning  [null]"));
        }
        return null;
    }

    private static MatchType checkAxisService(AxisService serviceToCheck, String serviceClassName, String externalizedServiceName, String externalizedExtraName) {
        MatchType serviceIsSame = MatchType.NONE;
        String checkServiceClassName = serviceToCheck.getClass().getName();
        String checkServiceName = serviceToCheck.getName();
        String checkServiceExtraName = ActivateUtils.getAxisServiceExternalizeExtraName(serviceToCheck);
        if (checkServiceClassName.equals(serviceClassName)) {
            if ((externalizedExtraName == null || checkServiceExtraName == null) && checkServiceName.equals(externalizedServiceName)) {
                serviceIsSame = MatchType.NAME_MATCH;
            } else if (externalizedExtraName != null && checkServiceExtraName != null && checkServiceExtraName.equals(externalizedExtraName)) {
                serviceIsSame = checkServiceName.equals(externalizedServiceName) ? MatchType.NAME_MATCH : MatchType.SERVICE_PORT_MATCH;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No match: checking Externalized AxisService name: " + externalizedServiceName + " and extraName: " + externalizedExtraName + " against existing AxisService name: " + checkServiceName + " and extraName: " + checkServiceExtraName));
            }
        }
        return serviceIsSame;
    }

    public static String getAxisServiceExternalizeExtraName(AxisService axisService) {
        Parameter portNameParameter;
        String extraName = null;
        String serviceQName = null;
        String portName = null;
        Parameter serviceQNameParameter = axisService.getParameter("WSDL_SERVICE_QNAME");
        if (serviceQNameParameter != null) {
            serviceQName = serviceQNameParameter.getValue().toString();
        }
        if ((portNameParameter = axisService.getParameter("WSDL_PORT")) != null) {
            portName = (String)portNameParameter.getValue();
        }
        if (serviceQName != null && portName != null) {
            extraName = String.valueOf(serviceQName) + DELIMITER_SERVICE_PORT + portName;
        }
        return extraName;
    }

    public static AxisOperation findOperation(AxisConfiguration axisConfig, String opClassName, QName opQName) {
        HashMap<String, AxisService> services = axisConfig.getServices();
        for (AxisService service : services.values()) {
            Iterator<AxisOperation> ito = service.getOperations();
            while (ito.hasNext()) {
                AxisOperation operation = ito.next();
                String tmpOpName = operation.getClass().getName();
                QName tmpOpQName = operation.getName();
                if (!tmpOpName.equals(opClassName) || !tmpOpQName.equals(opQName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
                }
                return operation;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(axisCfg): [" + opClassName + "]   [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisOperation findOperation(AxisService service, String opClassName, QName opQName) {
        if (service == null) {
            return null;
        }
        Iterator<AxisOperation> ito = service.getOperations();
        String namespace = opQName.getNamespaceURI();
        boolean ignoreNamespace = false;
        if (namespace == null || "".equals(namespace)) {
            ignoreNamespace = true;
        }
        while (ito.hasNext()) {
            AxisOperation operation = ito.next();
            String tmpOpName = operation.getClass().getName();
            QName tmpOpQName = operation.getName();
            if (!tmpOpName.equals(opClassName) || (!ignoreNamespace || !tmpOpQName.getLocalPart().equals(opQName.getLocalPart())) && !tmpOpQName.equals(opQName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findOperation(service): ignoreNamespace [" + ignoreNamespace + "] returning  [" + opClassName + "]   [" + opQName.toString() + "]"));
            }
            return operation;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findOperation(service): ignoreNamespace [" + ignoreNamespace + " classname [" + opClassName + "]  QName [" + opQName.toString() + "]  returning  [null]"));
        }
        return null;
    }

    public static AxisMessage findMessage(AxisOperation op, String msgName, String msgElementName) {
        boolean matching;
        if (op == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - no AxisOperation"));
            }
            return null;
        }
        if (msgName == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null] - message name is not set"));
            }
            return null;
        }
        String tmpName = null;
        String tmpElementName = null;
        AxisMessage out = null;
        try {
            out = op.getMessage("Out");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out != null) {
            tmpName = out.getName();
            QName tmpQout = out.getElementQName();
            if (tmpQout != null) {
                tmpElementName = tmpQout.toString();
            }
        }
        if (matching = ActivateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning OUT message  [" + msgName + "]  [" + msgElementName + "] "));
            }
            return out;
        }
        AxisMessage in = null;
        try {
            in = op.getMessage("In");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in != null) {
            tmpName = in.getName();
            QName tmpQin = in.getElementQName();
            if (tmpQin != null) {
                tmpElementName = tmpQin.toString();
            }
        } else {
            tmpName = null;
            tmpElementName = null;
        }
        if (matching = ActivateUtils.matchMessageNames(tmpName, tmpElementName, msgName, msgElementName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findMessage(): returning IN message [" + msgName + "]  [" + msgElementName + "] "));
            }
            return in;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ObjectStateUtils:findMessage(): [" + msgName + "]  [" + msgElementName + "] returning  [null]"));
        }
        return null;
    }

    public static Object findHandler(List<Handler> existingHandlers, MetaDataEntry metaDataEntry) {
        String title = "ObjectStateUtils:findHandler(): ";
        String handlerClassName = metaDataEntry.getClassName();
        String qNameAsString = metaDataEntry.getQNameAsString();
        int i = 0;
        while (i < existingHandlers.size()) {
            if (existingHandlers.get(i) != null) {
                String tmpClassName = existingHandlers.get(i).getClass().getName();
                String tmpName = existingHandlers.get(i).getName().toString();
                if (tmpClassName.equals(handlerClassName) && tmpName.equals(qNameAsString)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(String.valueOf(title) + " [" + handlerClassName + "]  name [" + qNameAsString + "]  returned"));
                    }
                    return existingHandlers.get(i);
                }
            }
            ++i;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(String.valueOf(title) + " [" + handlerClassName + "]  name [" + qNameAsString + "] was not found in the existingHandlers list"));
        }
        return null;
    }

    public static TransportListener findTransportListener(AxisConfiguration axisConfig, String listenerClassName) {
        HashMap<String, TransportInDescription> transportsIn = axisConfig.getTransportsIn();
        Collection<TransportInDescription> values = transportsIn.values();
        for (TransportInDescription ti : values) {
            TransportListener tl = ti.getReceiver();
            String tlClassName = tl.getClass().getName();
            if (!tlClassName.equals(listenerClassName)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("ObjectStateUtils:findTransportListener():  [" + listenerClassName + "]  returned"));
            }
            return tl;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:findTransportListener(): returning  [null]");
        }
        return null;
    }

    public static boolean isEquivalent(ArrayList a1, ArrayList a2, boolean strict) {
        if (a1 != null && a2 != null) {
            int size2;
            int size1 = a1.size();
            if (size1 != (size2 = a2.size())) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - size mismatch [" + size1 + "] != [" + size2 + "]"));
                }
                return false;
            }
            if (strict) {
                return a1.equals(a2);
            }
            for (Object obj1 : a1) {
                if (a2.contains(obj1)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch with element [" + obj1.getClass().getName() + "] "));
                }
                return false;
            }
            return true;
        }
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null && a2 == null) {
            return a1.size() == 0;
        }
        if (a1 == null && a2 != null) {
            return a2.size() == 0;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ObjectStateUtils:isEquivalent(ArrayList,ArrayList): FALSE - mismatch in lists");
        }
        return false;
    }

    public static boolean isEquivalent(Map m1, Map m2, boolean strict) {
        if (m1 != null && m2 != null) {
            int size2;
            if (strict) {
                return m1.equals(m2);
            }
            int size1 = m1.size();
            if (size1 != (size2 = m2.size())) {
                return false;
            }
            for (Object key1 : m1.keySet()) {
                if (m2.containsKey(key1)) continue;
                return false;
            }
            return true;
        }
        return m1 == null && m2 == null;
    }

    public static boolean isEquivalent(LinkedList l1, LinkedList l2) {
        if (l1 != null && l2 != null) {
            return l1.equals(l2);
        }
        return l1 == null && l2 == null;
    }

    private static boolean matchMessageNames(String name1, String elementName1, String name2, String elementName2) {
        if (name1 != null && name2 != null && name1.equals(name2)) {
            if (elementName1 == null && elementName2 == null) {
                return true;
            }
            return elementName1 != null && elementName2 != null && elementName1.equals(elementName2);
        }
        return false;
    }

    private static enum MatchType {
        NONE,
        NAME_MATCH,
        SERVICE_PORT_MATCH;

    }
}

