/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.context.externalize.ActivateUtils;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.MetaDataEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceContext
extends AbstractContext
implements Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(ServiceContext.class);
    private static final String myClassName = "ServiceContext";
    private String logCorrelationIDString = null;
    private static final long serialVersionUID = 8265625275015738957L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    public static final String SERVICE_OBJECT = "serviceObject";
    private EndpointReference targetEPR;
    private EndpointReference myEPR;
    private transient AxisService axisService;
    private transient ServiceGroupContext serviceGroupContext;
    private transient ConfigurationContext configContext;
    private boolean cachingOperationContext;
    private transient OperationContext lastOperationContext;
    private transient boolean needsToBeReconciled = false;
    private transient MetaDataEntry metaAxisService = null;
    private transient ServiceGroupContext metaParent = null;

    public ServiceContext() {
    }

    ServiceContext(AxisService axisService, ServiceGroupContext serviceGroupContext) {
        super(serviceGroupContext);
        this.serviceGroupContext = serviceGroupContext;
        this.axisService = axisService;
        this.configContext = (ConfigurationContext)this.parent.getParent();
    }

    public OperationContext createOperationContext(QName name) {
        AxisOperation axisOp = this.axisService.getOperation(name);
        return this.createOperationContext(axisOp);
    }

    public OperationContext createOperationContext(AxisOperation axisOp) {
        OperationContext ctx = new OperationContext(axisOp, this);
        this.configContext.contextCreated(ctx);
        return ctx;
    }

    public AxisService getAxisService() {
        this.checkActivateWarning("getAxisService");
        return this.axisService;
    }

    public ConfigurationContext getConfigurationContext() {
        this.checkActivateWarning("getConfigurationContext");
        return this.configContext;
    }

    public ServiceGroupContext getServiceGroupContext() {
        this.checkActivateWarning("getServiceGroupContext");
        return this.serviceGroupContext;
    }

    public EndpointReference getMyEPR(String transport) throws AxisFault {
        this.axisService.isEnableAllTransports();
        ConfigurationContext configctx = this.configContext;
        if (configctx != null) {
            ListenerManager lm = configctx.getListenerManager();
            if (!lm.isListenerRunning(transport)) {
                TransportInDescription trsin = configctx.getAxisConfiguration().getTransportIn(transport);
                if (trsin != null) {
                    lm.addListener(trsin, false);
                } else {
                    throw new AxisFault(Messages.getMessage("transportnotfound", transport));
                }
            }
            if (!lm.isStopped()) {
                return lm.getEPRforService(this.axisService.getName(), null, transport);
            }
        }
        return null;
    }

    public EndpointReference getTargetEPR() {
        return this.targetEPR;
    }

    public void setTargetEPR(EndpointReference targetEPR) {
        this.targetEPR = targetEPR;
    }

    public void setMyEPR(EndpointReference myEPR) {
        this.myEPR = myEPR;
    }

    public OperationContext getLastOperationContext() {
        return this.lastOperationContext;
    }

    public void setLastOperationContext(OperationContext lastOperationContext) {
        this.lastOperationContext = lastOperationContext;
    }

    public boolean isCachingOperationContext() {
        return this.cachingOperationContext;
    }

    public void setCachingOperationContext(boolean cacheLastOperationContext) {
        this.cachingOperationContext = cacheLastOperationContext;
    }

    public String getName() {
        if (this.axisService != null) {
            return this.axisService.getName();
        }
        if (this.metaAxisService != null) {
            return this.metaAxisService.getName();
        }
        return null;
    }

    public String getGroupName() {
        if (this.serviceGroupContext != null) {
            return this.serviceGroupContext.getId();
        }
        if (this.metaParent != null) {
            return this.metaParent.getId();
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(8265625275015738957L);
        out.writeInt(2);
        out.writeLong(this.getLastTouchedTime());
        out.writeBoolean(this.cachingOperationContext);
        out.writeObject(this.getLogCorrelationIDString());
        out.writeObject(this.targetEPR);
        out.writeObject(this.myEPR);
        out.writeMap(this.getProperties());
        this.metaAxisService = null;
        if (this.axisService != null) {
            String serviceAndPortNames = ActivateUtils.getAxisServiceExternalizeExtraName(this.axisService);
            this.metaAxisService = new MetaDataEntry(this.axisService.getClass().getName(), this.axisService.getName(), serviceAndPortNames);
        }
        out.writeObject(this.metaAxisService);
        out.writeObject(this.getParent());
    }

    @Override
    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        this.needsToBeReconciled = true;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("ServiceContext:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  "));
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8265625275015738957L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        long time = in.readLong();
        this.setLastTouchedTime(time);
        this.cachingOperationContext = in.readBoolean();
        this.logCorrelationIDString = (String)in.readObject();
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("ServiceContext:readExternal():  reading input stream for [" + this.getLogCorrelationIDString() + "]  "));
        }
        this.targetEPR = (EndpointReference)in.readObject();
        this.myEPR = (EndpointReference)in.readObject();
        this.properties = in.readMap(new HashMap());
        this.metaAxisService = (MetaDataEntry)in.readObject();
        this.metaParent = (ServiceGroupContext)in.readObject();
        this.lastOperationContext = null;
    }

    public void activate(ConfigurationContext cc) {
        if (!this.needsToBeReconciled) {
            return;
        }
        this.configContext = cc;
        AxisConfiguration axisConfig = cc.getAxisConfiguration();
        this.axisService = null;
        if (this.metaAxisService != null) {
            this.axisService = ActivateUtils.findService(axisConfig, this.metaAxisService.getClassName(), this.metaAxisService.getQNameAsString(), this.metaAxisService.getExtraName());
        }
        if (this.metaParent != null) {
            String groupName = this.metaParent.getId();
            ServiceGroupContext existingSGC = cc.getServiceGroupContext(groupName);
            if (existingSGC == null) {
                this.metaParent.activate(cc);
                this.setParent(this.metaParent);
            } else {
                this.setParent(existingSGC);
                this.metaParent.putContextProperties(existingSGC);
            }
        } else {
            this.setParent(this.metaParent);
        }
        this.serviceGroupContext = (ServiceGroupContext)this.getParent();
        if (this.serviceGroupContext != null) {
            this.serviceGroupContext.addServiceContext(this);
        }
        this.needsToBeReconciled = false;
        if (this.metaParent != null) {
            this.metaParent.addServiceContext(this);
        }
    }

    public void putContextProperties(ServiceContext context, boolean doParentProperties) {
        if (context != null) {
            Map<String, Object> props = this.getProperties();
            context.mergeProperties(props);
            if (doParentProperties) {
                ServiceGroupContext mySGC = null;
                if (this.serviceGroupContext != null) {
                    mySGC = this.serviceGroupContext;
                } else if (this.metaParent != null) {
                    mySGC = this.metaParent;
                }
                if (mySGC != null) {
                    ServiceGroupContext sgc = context.getServiceGroupContext();
                    mySGC.putContextProperties(sgc);
                }
            }
        }
    }

    public String getLogCorrelationIDString() {
        if (this.logCorrelationIDString == null) {
            this.logCorrelationIDString = "ServiceContext@" + UIDGenerator.generateUID();
        }
        return this.logCorrelationIDString;
    }

    private void checkActivateWarning(String methodname) {
        if (this.needsToBeReconciled && LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(this.getLogCorrelationIDString()) + ":" + methodname + "(): ****WARNING**** " + myClassName + ".activate(configurationContext) needs to be invoked."));
        }
    }

    @Override
    public ConfigurationContext getRootContext() {
        return this.configContext;
    }
}

