/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.metadata.InterfaceName;
import org.apache.axis2.addressing.metadata.ServiceName;
import org.apache.axis2.addressing.metadata.WSDLLocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointReferenceHelper {
    private static final Log log = LogFactory.getLog(EndpointReferenceHelper.class);
    private static final Map finalQNames = new IdentityHashMap();
    private static final Map submissionQNames = new IdentityHashMap();

    static {
        finalQNames.put("Address", new QName("http://www.w3.org/2005/08/addressing", "Address"));
        finalQNames.put("ReferenceParameters", new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters"));
        finalQNames.put("Metadata", new QName("http://www.w3.org/2005/08/addressing", "Metadata"));
        submissionQNames.put("Address", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address"));
        submissionQNames.put("ReferenceParameters", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceParameters"));
        submissionQNames.put("ReferenceProperties", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceProperties"));
    }

    public static void fromOM(EndpointReference epr, OMElement eprOMElement, String addressingNamespace) throws AxisFault {
        String namespace = EndpointReferenceHelper.fromOM(epr, eprOMElement);
        if (!namespace.equals(addressingNamespace)) {
            throw new AxisFault("The endpoint reference does not match the specified namespace.");
        }
    }

    public static String fromOM(EndpointReference epr, OMElement eprOMElement) throws AxisFault {
        boolean isFinalAddressingNamespace = false;
        Map map = null;
        OMElement address = eprOMElement.getFirstChildWithName((QName)finalQNames.get("Address"));
        if (address != null) {
            map = finalQNames;
            isFinalAddressingNamespace = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)"fromOM: Found address element for namespace, http://www.w3.org/2005/08/addressing");
            }
        } else {
            address = eprOMElement.getFirstChildWithName((QName)submissionQNames.get("Address"));
            if (address != null) {
                map = submissionQNames;
                isFinalAddressingNamespace = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"fromOM: Found address element for namespace, http://schemas.xmlsoap.org/ws/2004/08/addressing");
                }
            } else {
                throw new AxisFault("Unable to locate an address element for the endpoint reference type.");
            }
        }
        if (epr != null) {
            EndpointReferenceHelper.fromOM(epr, eprOMElement, map, isFinalAddressingNamespace);
        }
        return ((QName)map.get("Address")).getNamespaceURI();
    }

    public static EndpointReference fromString(String eprString) throws AxisFault {
        try {
            return EndpointReferenceHelper.fromOM(AXIOMUtil.stringToOM((String)eprString));
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static EndpointReference fromOM(OMElement eprOMElement) throws AxisFault {
        EndpointReference epr = new EndpointReference("");
        EndpointReferenceHelper.fromOM(epr, eprOMElement);
        return epr;
    }

    public static OMElement toOM(OMFactory factory, EndpointReference epr, QName qname, String addressingNamespace) throws AxisFault {
        Object eprElement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("toOM: Factory, " + factory));
            log.debug((Object)("toOM: Endpoint reference, " + epr));
            log.debug((Object)("toOM: Element qname, " + qname));
            log.debug((Object)("toOM: Addressing namespace, " + addressingNamespace));
        }
        if (addressingNamespace == null) {
            throw new AxisFault("Addressing namespace cannot be null.");
        }
        if (qname.getPrefix() != null) {
            ArrayList<OMElement> extensibleElements;
            ArrayList<OMAttribute> attributes;
            Map<QName, OMElement> referenceParameters;
            ArrayList<OMNode> metaData;
            OMNamespace wrapNs = factory.createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
            eprElement = factory instanceof SOAPFactory ? ((SOAPFactory)factory).createSOAPHeaderBlock(qname.getLocalPart(), wrapNs) : factory.createOMElement(qname.getLocalPart(), wrapNs);
            OMNamespace wsaNS = factory.createOMNamespace(addressingNamespace, "wsa");
            OMElement addressE = factory.createOMElement("Address", wsaNS, (OMContainer)eprElement);
            String address = epr.getAddress();
            addressE.setText(address);
            ArrayList<OMAttribute> addressAttributes = epr.getAddressAttributes();
            if (addressAttributes != null) {
                for (OMAttribute omAttribute : addressAttributes) {
                    addressE.addAttribute((OMAttribute)factory.importInformationItem((OMInformationItem)omAttribute));
                }
            }
            if ((metaData = epr.getMetaData()) != null && "http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                OMElement metadataE = factory.createOMElement("Metadata", wsaNS, (OMContainer)eprElement);
                int i = 0;
                int size = metaData.size();
                while (i < size) {
                    OMElement omElement = (OMElement)metaData.get(i);
                    metadataE.addChild((OMNode)((OMElement)factory.importInformationItem((OMInformationItem)omElement)));
                    ++i;
                }
                ArrayList<OMAttribute> metadataAttributes = epr.getMetadataAttributes();
                if (metadataAttributes != null) {
                    for (OMAttribute omAttribute : metadataAttributes) {
                        metadataE.addAttribute((OMAttribute)factory.importInformationItem((OMInformationItem)omAttribute));
                    }
                }
            }
            if ((referenceParameters = epr.getAllReferenceParameters()) != null) {
                OMElement refParameterElement = factory.createOMElement("ReferenceParameters", wsaNS, (OMContainer)eprElement);
                for (OMElement omElement : referenceParameters.values()) {
                    refParameterElement.addChild((OMNode)((OMElement)factory.importInformationItem((OMInformationItem)omElement)));
                }
            }
            if ((attributes = epr.getAttributes()) != null) {
                int i = 0;
                int size = attributes.size();
                while (i < size) {
                    OMAttribute omAttribute = (OMAttribute)attributes.get(i);
                    eprElement.addAttribute((OMAttribute)factory.importInformationItem((OMInformationItem)omAttribute));
                    ++i;
                }
            }
            if ((extensibleElements = epr.getExtensibleElements()) != null) {
                int i = 0;
                int size = extensibleElements.size();
                while (i < size) {
                    OMElement omElement = (OMElement)extensibleElements.get(i);
                    eprElement.addChild((OMNode)((OMElement)factory.importInformationItem((OMInformationItem)omElement)));
                    ++i;
                }
            }
        } else {
            throw new AxisFault("prefix must be specified");
        }
        return eprElement;
    }

    private static void fromOM(EndpointReference epr, OMElement eprOMElement, Map map, boolean isFinalAddressingNamespace) {
        Iterator childElements = eprOMElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement element;
            Iterator iterator;
            OMElement eprChildElement = (OMElement)childElements.next();
            QName qname = eprChildElement.getQName();
            if (map.get("Address").equals(qname)) {
                epr.setAddress(eprChildElement.getText());
                Iterator allAddrAttributes = eprChildElement.getAllAttributes();
                ArrayList<OMAttribute> addressAttributes = new ArrayList<OMAttribute>();
                while (allAddrAttributes.hasNext()) {
                    OMAttribute attribute = (OMAttribute)allAddrAttributes.next();
                    addressAttributes.add(attribute);
                }
                epr.setAddressAttributes(addressAttributes);
                continue;
            }
            if (map.get("ReferenceParameters").equals(qname)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    element = (OMElement)iterator.next();
                    epr.addReferenceParameter(element);
                }
                continue;
            }
            if (isFinalAddressingNamespace && map.get("Metadata").equals(qname)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    OMNode node = (OMNode)iterator.next();
                    epr.addMetaData(node);
                }
                Iterator allMDAttributes = eprChildElement.getAllAttributes();
                ArrayList<OMAttribute> metadataAttributes = new ArrayList<OMAttribute>();
                while (allMDAttributes.hasNext()) {
                    OMAttribute attribute = (OMAttribute)allMDAttributes.next();
                    metadataAttributes.add(attribute);
                }
                epr.setMetadataAttributes(metadataAttributes);
                continue;
            }
            if (!isFinalAddressingNamespace && map.get("ReferenceProperties").equals(qname)) {
                iterator = eprChildElement.getChildElements();
                while (iterator.hasNext()) {
                    element = (OMElement)iterator.next();
                    epr.addReferenceParameter(element);
                }
                continue;
            }
            epr.addExtensibleElement(eprChildElement);
        }
        Iterator attributes = eprOMElement.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributes.next();
            epr.addAttribute(attribute);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fromOM: Endpoint reference, " + epr));
        }
    }

    public static ServiceName getServiceNameMetadata(EndpointReference epr, String addressingNamespace) throws AxisFault {
        ServiceName serviceName = new ServiceName();
        ArrayList<Object> elements = null;
        elements = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace) ? epr.getExtensibleElements() : epr.getMetaData();
        if (elements != null) {
            int i = 0;
            int size = elements.size();
            while (i < size) {
                OMElement omElement = (OMElement)elements.get(i);
                if (ServiceName.isServiceNameElement(omElement)) {
                    serviceName.fromOM(omElement);
                    break;
                }
                ++i;
            }
        }
        return serviceName;
    }

    public static InterfaceName getInterfaceNameMetadata(EndpointReference epr, String addressingNamespace) throws AxisFault {
        InterfaceName interfaceName = new InterfaceName();
        ArrayList<Object> elements = null;
        elements = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace) ? epr.getExtensibleElements() : epr.getMetaData();
        if (elements != null) {
            int i = 0;
            int size = elements.size();
            while (i < size) {
                OMElement omElement = (OMElement)elements.get(i);
                if (InterfaceName.isInterfaceNameElement(omElement)) {
                    interfaceName.fromOM(omElement);
                    break;
                }
                ++i;
            }
        }
        return interfaceName;
    }

    public static WSDLLocation getWSDLLocationMetadata(EndpointReference epr, String addressingNamespace) throws AxisFault {
        WSDLLocation wsdlLocation = new WSDLLocation();
        ArrayList<OMAttribute> attributes = null;
        attributes = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace) ? epr.getAttributes() : epr.getMetadataAttributes();
        if (attributes != null) {
            int i = 0;
            int size = attributes.size();
            while (i < size) {
                OMAttribute omAttribute = (OMAttribute)attributes.get(i);
                if (WSDLLocation.isWSDLLocationAttribute(omAttribute)) {
                    wsdlLocation.fromOM(omAttribute);
                    break;
                }
                ++i;
            }
        }
        return wsdlLocation;
    }

    public static void setServiceNameMetadata(OMFactory factory, EndpointReference epr, String addressingNamespace, ServiceName serviceName) throws AxisFault {
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
            OMElement omElement = serviceName.toOM(factory, ServiceName.subQName);
            epr.addExtensibleElement(omElement);
        } else {
            OMElement omElement = serviceName.toOM(factory, ServiceName.wsamQName);
            epr.addMetaData((OMNode)omElement);
        }
    }

    public static void setInterfaceNameMetadata(OMFactory factory, EndpointReference epr, String addressingNamespace, InterfaceName interfaceName) throws AxisFault {
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
            OMElement omElement = interfaceName.toOM(factory, InterfaceName.subQName);
            epr.addExtensibleElement(omElement);
        } else {
            OMElement omElement = interfaceName.toOM(factory, InterfaceName.wsamQName);
            epr.addMetaData((OMNode)omElement);
        }
    }

    public static void setWSDLLocationMetadata(OMFactory factory, EndpointReference epr, String addressingNamespace, WSDLLocation wsdlLocation) throws AxisFault {
        OMAttribute attribute = wsdlLocation.toOM(factory);
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
            epr.addAttribute(attribute);
        } else {
            ArrayList<OMAttribute> list = new ArrayList<OMAttribute>();
            list.add(attribute);
            epr.setMetadataAttributes(list);
        }
    }
}

