/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tk.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TKJNIClassLoader
extends URLClassLoader {
    private static ClassLoader m_oldSystemCL;
    private Map<String, Object> m_loadedPluginNameVersions;

    public TKJNIClassLoader(URL[] urls) {
        super(urls);
        m_oldSystemCL = this.findVJRClassLoader();
        if (m_oldSystemCL == null) {
            // empty if block
        }
    }

    public TKJNIClassLoader(URL[] urls, ClassLoader cl) {
        super(urls, cl);
        m_oldSystemCL = this.findVJRClassLoader();
        if (m_oldSystemCL == null) {
            // empty if block
        }
    }

    public TKJNIClassLoader(URL[] urls, ClassLoader cl, URLStreamHandlerFactory factory) {
        super(urls, cl, factory);
        m_oldSystemCL = this.findVJRClassLoader();
        if (m_oldSystemCL == null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getLoadedPluginNameVersions() {
        TKJNIClassLoader tKJNIClassLoader = this;
        synchronized (tKJNIClassLoader) {
            int n;
            if (this.m_loadedPluginNameVersions != null && (n = this.m_loadedPluginNameVersions.size()) > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>(this.m_loadedPluginNameVersions);
                return Collections.unmodifiableMap(map);
            }
            return Collections.emptyMap();
        }
    }

    private ClassLoader findVJRClassLoader() {
        ClassLoader OBJ_oldSystemCL = null;
        String prop = System.getProperty("java.system.class.loader");
        if (prop != null) {
            ClassLoader OBJ_systemcl = ClassLoader.getSystemClassLoader();
            Class<?> CLS_systemcl = OBJ_systemcl.getClass();
            OBJ_oldSystemCL = CLS_systemcl.getClassLoader();
        }
        return OBJ_oldSystemCL;
    }

    protected Class<?> loadWithOldSystemCL(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = m_oldSystemCL.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return clazz;
    }

    protected URL[] getRepositoryURLs(Object picklist) throws Exception {
        URL[] ARR_urls = null;
        String name = null;
        Object version = null;
        Object[] ARR_plugins = null;
        Method method1 = null;
        Method method2 = null;
        try {
            Class<?> CLS_repos = this.loadWithOldSystemCL("com.sas.app.Repository");
            Class<?> CLS_plugin = this.loadWithOldSystemCL("com.sas.app.Plugin");
            Class<?> CLS_picklist = this.loadWithOldSystemCL("com.sas.app.PickList");
            method1 = CLS_repos.getMethod("getDefaultRepository", new Class[0]);
            Object OBJ_repos = method1.invoke(null, new Object[0]);
            method1 = CLS_repos.getMethod("find", CLS_picklist);
            ARR_plugins = (Object[])method1.invoke(OBJ_repos, picklist);
            if (this.m_loadedPluginNameVersions == null) {
                this.m_loadedPluginNameVersions = new HashMap<String, Object>();
            }
            method1 = CLS_plugin.getMethod("getName", new Class[0]);
            method2 = CLS_plugin.getMethod("getVersion", new Class[0]);
            for (int i = 0; i < ARR_plugins.length; ++i) {
                Object OBJ_plugin = ARR_plugins[i];
                name = (String)method1.invoke(OBJ_plugin, new Object[0]);
                if (this.m_loadedPluginNameVersions.containsKey(name)) continue;
                version = method2.invoke(OBJ_plugin, new Object[0]);
                this.m_loadedPluginNameVersions.put(name, version);
            }
            Class<?> CLS_ARR_plugin = ARR_plugins.getClass();
            method1 = CLS_repos.getMethod("getClasspath", CLS_ARR_plugin);
            ARR_urls = (URL[])method1.invoke(null, new Object[]{ARR_plugins});
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = e.getCause()) != null && t instanceof Exception) {
                e = (Exception)t;
            }
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return ARR_urls;
    }

    protected void addNewURL(URL url) throws Exception {
        try {
            this.addURL(url);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    protected void addArrayURLs(URL[] ARR_urls) throws Exception {
        try {
            for (int i = 0; i < ARR_urls.length; ++i) {
                this.addURL(ARR_urls[i]);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }
}

