/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.security.PermissionFactory;
import com.sas.security.omipermissions.PermissionProxyPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class PermissionCheckProxy {
    private static final PermissionFactory factory = PermissionFactory.getInstance();

    private PermissionCheckProxy() {
    }

    public static void checkPermission(Permission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new PermissionProxyPermission("PermissionProxy"));
        }
        Permission permissiontoCheck = factory.getPermission(permission);
        if (sm != null) {
            sm.checkPermission(permissiontoCheck);
        }
    }

    public static void checkPermission(final Subject subject, Permission perm) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new PermissionProxyPermission("PermissionProxy"));
        }
        final PermissionCheckAction checkAction = new PermissionCheckAction(perm);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return (String)Subject.doAsPrivileged(subject, checkAction, null);
                }
                catch (PrivilegedActionException e) {
                    throw new AccessControlException(e.getMessage());
                }
            }
        });
    }

    private static class PermissionCheckAction
    implements PrivilegedExceptionAction {
        private Permission permissiontoCheck;

        PermissionCheckAction(Permission permissiontoCheck) {
            this.permissiontoCheck = permissiontoCheck;
        }

        public Object run() {
            this.permissiontoCheck = factory.getPermission(this.permissiontoCheck);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(this.permissiontoCheck);
            }
            return null;
        }
    }
}

