/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.option.sql.SQLConnect;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLDelete
extends ExtensionInstruction {
    Expression connection;
    String table;
    Expression where;

    public void prepareAttributes() throws XPathException {
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
            this.table = "saxon-error-table";
        }
        this.table = SQLConnect.quoteSqlName(this.table);
        String dbWhere = this.getAttributeList().getValue("", "where");
        this.where = dbWhere == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(dbWhere);
        String connectAtt = this.getAttributeList().getValue("", "connection");
        if (connectAtt == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(connectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        super.validate(decl);
        this.where = this.typeCheck("where", this.where);
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return new DeleteInstruction(this.connection, "DELETE FROM " + this.table, this.where);
    }

    private static class DeleteInstruction
    extends SimpleExpression {
        private static final long serialVersionUID = -4234440812734827279L;
        public static final int CONNECTION = 0;
        public static final int WHERE = 1;
        String statement;

        public DeleteInstruction(Expression connection, String statement, Expression where) {
            Expression[] sub = new Expression[]{connection, where};
            this.statement = statement;
            this.setArguments(sub);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:delete";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item evaluateItem(XPathContext context) throws XPathException {
            Item conn = this.arguments[0].evaluateItem(context);
            if (!(conn instanceof ObjectValue) || !(((ObjectValue)conn).getObject() instanceof Connection)) {
                this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQ0001", context);
            }
            Connection connection = (Connection)((ObjectValue)conn).getObject();
            PreparedStatement ps = null;
            String dbWhere = ((Object)this.arguments[1].evaluateAsString(context)).toString();
            String localstmt = this.statement;
            if (!dbWhere.equals("")) {
                localstmt = localstmt + " WHERE " + dbWhere;
            }
            try {
                ps = connection.prepareStatement(localstmt);
                ps.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException ex) {
                this.dynamicError("SQL DELETE failed: " + ex.getMessage(), "SXSQ0004", context);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
            return null;
        }
    }
}

