/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.regex.Pattern;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class SQLConnect
extends ExtensionInstruction {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;
    Expression autoCommit = new Literal((Value)EmptySequence.getInstance());
    private static Pattern namePattern = Pattern.compile("\"[^\"]+\"|[A-Za-z_][A-Za-z0-9_]*");

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        String dbAtt = this.getAttributeValue("", "database");
        if (dbAtt == null) {
            this.reportAbsence("database");
            dbAtt = "";
        }
        this.database = this.makeAttributeValueTemplate(dbAtt);
        String dbDriver = this.getAttributeValue("", "driver");
        if (dbDriver == null) {
            if (dbAtt.length() > 9 && dbAtt.substring(0, 9).equals("jdbc:odbc")) {
                dbDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(dbDriver);
        String userAtt = this.getAttributeValue("", "user");
        this.user = userAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(userAtt);
        String pwdAtt = this.getAttributeValue("", "password");
        this.password = pwdAtt == null ? new StringLiteral(StringValue.EMPTY_STRING) : this.makeAttributeValueTemplate(pwdAtt);
        String autoCommitAtt = this.getAttributeValue("", "auto-commit");
        if (autoCommitAtt != null) {
            this.autoCommit = this.makeAttributeValueTemplate(autoCommitAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        super.validate(decl);
        if (!this.getConfiguration().isLicensedFeature(64)) {
            throw new XPathException("sql:connect is not licensed in this Configuration");
        }
        this.database = this.typeCheck("database", this.database);
        this.driver = this.typeCheck("driver", this.driver);
        this.user = this.typeCheck("user", this.user);
        this.password = this.typeCheck("password", this.password);
        this.autoCommit = this.typeCheck("auto-commit", this.autoCommit);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return new ConnectInstruction(this.database, this.driver, this.user, this.password, this.autoCommit);
    }

    public static String quoteSqlName(String name) throws IllegalArgumentException {
        if (namePattern.matcher(name).matches()) {
            return name;
        }
        return "\"" + name + "\"";
    }

    private static class ConnectInstruction
    extends SimpleExpression {
        public static final int DATABASE = 0;
        public static final int DRIVER = 1;
        public static final int USER = 2;
        public static final int PASSWORD = 3;
        public static final int AUTOCOMMIT = 4;

        public ConnectInstruction(Expression database, Expression driver, Expression user, Expression password, Expression autoCommit) {
            Expression[] subs = new Expression[]{database, driver, user, password, autoCommit};
            this.setArguments(subs);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public int computeCardinality() {
            return 16384;
        }

        public String getExpressionType() {
            return "sql:connect";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            Connection connection = null;
            String dbString = ((Object)this.arguments[0].evaluateAsString(context)).toString();
            String dbDriverString = ((Object)this.arguments[1].evaluateAsString(context)).toString();
            String userString = ((Object)this.arguments[2].evaluateAsString(context)).toString();
            String pwdString = ((Object)this.arguments[3].evaluateAsString(context)).toString();
            String autoCommitString = ((Object)this.arguments[4].evaluateAsString(context)).toString();
            try {
                Class.forName(dbDriverString);
                connection = DriverManager.getConnection(dbString, userString, pwdString);
                if (autoCommitString.length() > 0) {
                    connection.setAutoCommit("yes".equals(autoCommitString));
                }
            }
            catch (Exception ex) {
                this.dynamicError("JDBC Connection Failure: " + ex.getMessage(), "SXSQ0003", context);
            }
            return new ObjectValue((Object)connection);
        }
    }
}

