/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.subscriber;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.messagequeue.MessageQueueConnectionType;
import com.sas.metadata.logical.server.BasePathConnectionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.subscriber.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.information.metadata.MessageQueueInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.ServerInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SubscriberExportListener
extends AbstractExportListener {
    protected static final Class[] CONNECTION_TYPES = new Class[]{OtherServerConnectionType.class, MessageQueueConnectionType.class, BasePathConnectionType.class};

    public SubscriberExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int analyzeConnections(ExportOperationInterface operation, List exportItems) throws MdException, RemoteException {
        int retVal = 0;
        for (ExportItemInterface exportItem : exportItems) {
            ConnectionManagerInterface connMgr = operation.getConnectionManager();
            block5: for (ConnectionPointInterface cp : new ArrayList(exportItem.getConnectionPoints())) {
                String classId;
                if (cp.getMetadataType().equals("Directory")) {
                    classId = PromotionUtil.getValue((String)cp.getSourceSearchString(), (String)"DeployedComponents/*[@ClassIdentifier");
                    String serverName = PromotionUtil.getValue((String)cp.getSourceSearchString(), (String)"DeployedComponents/*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name");
                    try {
                        DirectoryInterface dir = (DirectoryInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)cp.getSourceID(), (String)cp.getMetadataType());
                        for (ServerInterface server : dir.getServers()) {
                            if (!server.getClassIdentifier().equals(classId) || !server.getName().equals(serverName)) continue;
                            ConnectionPointInterface newCp = connMgr.createConnection("ServerComponent", server.getReposId(), server.getName());
                            newCp.addAssociatedObject((PromotionItemInterface)exportItem);
                            StringBuffer b = new StringBuffer();
                            b.append("*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name='");
                            b.append(server.getName());
                            b.append("']");
                            newCp.addSourceSearch(b.toString());
                            if (!exportItem.getTypeInterface().getMetadataType().equals("ITContentSubscriber")) continue block5;
                            cp.addUserDefinedProperty("DAV_REQUIRED", "1");
                        }
                    }
                    catch (Exception ex) {
                        retVal = 8;
                        Log exportLogger = operation.getLogger();
                        exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SEL.UpdateConnErr.fmt.txt"), (Object)exportItem.getName(), (Object)ex.getMessage()));
                    }
                    continue;
                }
                if (!cp.getMetadataType().equals("Transformation")) continue;
                classId = PromotionUtil.getValue((String)cp.getSourceSearchString(), (String)"DeployedComponents/*[@ClassIdentifier");
                try {
                    MessageQueueInterface q = (MessageQueueInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)cp.getSourceID(), (String)cp.getMetadataType());
                    ServerComponentInterface sci = q.getQueueManager();
                    if (sci == null) continue;
                    ConnectionPointInterface newCp = connMgr.createConnection("ServerComponent", sci.getReposId(), sci.getName());
                    newCp.addAssociatedObject((PromotionItemInterface)exportItem);
                    StringBuffer b = new StringBuffer();
                    b.append("*[@ClassIdentifier='");
                    b.append(classId);
                    b.append("' and @Name='");
                    b.append(sci.getName());
                    b.append("']");
                    newCp.addSourceSearch(b.toString());
                }
                catch (Exception ex) {
                    retVal = 8;
                    Log exportLogger = operation.getLogger();
                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("SEL.UpdateConnErr.fmt.txt"), (Object)exportItem.getName(), (Object)ex.getMessage()));
                }
            }
        }
        return retVal;
    }
}

