/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.scheduling;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.CommandSubstitutionType;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.PortSubstitutionType;
import com.sas.metadata.logical.server.SpawnerConnectionType;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import java.util.List;

public class SchedulingServerImportListener
extends BaseServerImportListener {
    private ConfigurablePropertiesHandler confPropHandler;
    protected static final Class[] CONNECTION_TYPES = new Class[]{SpawnerConnectionType.class};

    public SchedulingServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    @Override
    public Class[] getSubstitutionTypes() {
        return new Class[]{HostSubstitutionType.class, PortSubstitutionType.class, CommandSubstitutionType.class, DirectoryPathSubstitutionType.class};
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean backupSuccess = AppServerConnectionUtil.backupConfigurableProperties(this.confPropHandler, objects);
        return backupSuccess ? 0 : 4;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.confPropHandler = ConfigurablePropertiesHandler.getInstance();
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean restored = AppServerConnectionUtil.restoreConfigurableProperties(this.confPropHandler, objects);
        return restored ? 0 : 4;
    }
}

