/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.sas;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.PortSubstitutionType;
import com.sas.metadata.logical.server.sas.RB;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import java.rmi.RemoteException;
import java.util.List;

public class LASRServerImportListener
extends BaseServerImportListener {
    public static final String LASRSERVER_TEMPLATE = "<Templates><ServerComponent><SourceConnections/></ServerComponent><SASClientConnection><Properties/></SASClientConnection></Templates>";
    public static final String PROPERTY_SUFFIX_SIGNER = "SIGNER";
    public static final String LASR_DEPLOYEDCOMPONENT = "LASRKeyRegistrationService REST";

    public LASRServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    @Override
    public Class[] getSubstitutionTypes() {
        return new Class[]{HostSubstitutionType.class, PortSubstitutionType.class, DirectoryPathSubstitutionType.class};
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean restored = this.setConnectionProperty(operation, objects);
        return restored ? 0 : 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setConnectionProperty(ImportOperationInterface operation, List objects) {
        boolean bMetadataChanges = true;
        int options = 396;
        if (objects != null) {
            ImportItemInterface importItem = null;
            for (Object object : objects) {
                importItem = (ImportItemInterface)object;
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("LASRServerImportListener.UpdateStatusIndicator.fmt.txt"), (Object)importItem.getName()));
                operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("LASRServerImportListener.UpdateStatusIndicator.fmt.txt"), (Object)importItem.getName()));
                String sTargetFqid = importItem.getTargetID();
                Object lasrServer = null;
                MdObjectStore mdStore = null;
                try {
                    mdStore = operation.getMetadataFactory().createObjectStore(null, "LASRServerImportListener:setConnectionProperty");
                    CMetadata servers = mdStore.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "ServerComponent", sTargetFqid, null, null, LASRSERVER_TEMPLATE, options);
                    ServerComponent sc = (ServerComponent)servers;
                    String reposid = "A0000001." + sc.getRepositoryID();
                    String url = this.getSignerDefaultValue(options, mdStore, reposid);
                    AssociationList lstCon = sc.getSourceConnections();
                    if (lstCon != null && lstCon.size() > 0) {
                        Connection con = (Connection)lstCon.get(0);
                        AssociationList lstProp = con.getProperties();
                        for (Property prop : lstProp) {
                            if (!prop.getPropertyName().equalsIgnoreCase(PROPERTY_SUFFIX_SIGNER)) continue;
                            prop.setDefaultValue(url);
                        }
                    }
                    sc.updateMetadataAll();
                }
                catch (RemoteException e) {
                    bMetadataChanges = false;
                    operation.getLogger().warn((Object)e.getLocalizedMessage());
                }
                catch (MdException e) {
                    bMetadataChanges = false;
                    operation.getLogger().warn((Object)e.getLocalizedMessage());
                }
                finally {
                    try {
                        if (mdStore == null || mdStore.isDisposed()) continue;
                        mdStore.dispose();
                    }
                    catch (RemoteException e) {
                        bMetadataChanges = false;
                        operation.getLogger().warn((Object)e.getLocalizedMessage());
                    }
                }
            }
        }
        return bMetadataChanges;
    }

    private String getSignerDefaultValue(int options, MdObjectStore mdStore, String reposId) throws RemoteException, MdException {
        String url = null;
        String searchStr = "/register";
        String xmlSelect = "<XMLSelect search=\"*[@Name='LASRKeyRegistrationService REST']\"/>";
        List objects = mdStore.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)mdStore, reposId, "DeployedComponent", options, xmlSelect);
        if (objects != null && objects.size() > 0) {
            DeployedComponent dcom = (DeployedComponent)objects.get(0);
            String host = ((TCPIPConnection)dcom.getSourceConnections().get(0)).getHostName();
            String service = ((TCPIPConnection)dcom.getSourceConnections().get(0)).getService();
            int port = ((TCPIPConnection)dcom.getSourceConnections().get(0)).getPort();
            String urlService = service.endsWith(searchStr) ? service.substring(0, service.indexOf(searchStr)) : service;
            String protocol = ((TCPIPConnection)dcom.getSourceConnections().get(0)).getCommunicationProtocol();
            url = protocol + "://" + host + ":" + port + urlService;
        }
        return url;
    }
}

