/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.objectspawner;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.server.objectspawner.RB;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ObjectSpawnerExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public ObjectSpawnerExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        try {
            ArrayList<SimpleLogicalObjectInterface> lLogicalObjects = new ArrayList<SimpleLogicalObjectInterface>();
            MdFactory factory = this._exportOperation.getMetadataFactory();
            MdObjectStore mdStore = factory.createObjectStore(null, "objectspawnerExportItem.getRelatedObjects");
            int iOptions = 268;
            try {
                ServerComponent mdObjectSpawner = (ServerComponent)factory.getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "ServerComponent", this.getID(), null, null, "<Templates><ServerComponent><Notes/><AssociatedMachine/><SoftwareTrees/><SourceConnections/><UsedByComponents/></ServerComponent></Templates>", iOptions);
                if (mdObjectSpawner == null) {
                    throw new LogicalTypeException(Message.format((String)RB.getStringResource("ObjectspawnerExportItem.ObjectNotFound.fmt"), (Object)this.getName()));
                }
                if (relationshipType == 0) {
                    AssociationList lDoc = mdObjectSpawner.getDocuments();
                    for (int iDoc = 0; iDoc < lDoc.size(); ++iDoc) {
                        SimpleLogicalObjectInterface lo;
                        Document mdIdocument = (Document)lDoc.get(iDoc);
                        if (!"Document".equals(mdIdocument.getPublicType()) || (lo = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)mdIdocument)) == null) continue;
                        lLogicalObjects.add(lo);
                    }
                    AssociationList lServercomponent = mdObjectSpawner.getUsedByComponents();
                    for (int iDoc = 0; iDoc < lServercomponent.size(); ++iDoc) {
                        SimpleLogicalObjectInterface lo;
                        ServerComponent srv;
                        CMetadata cm = (CMetadata)lServercomponent.get(iDoc);
                        if (!cm.getCMetadataType().equalsIgnoreCase("ServerComponent") || !"Server.Workspace".equals((srv = (ServerComponent)cm).getPublicType()) || (lo = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)srv)) == null) continue;
                        lLogicalObjects.add(lo);
                    }
                } else if (relationshipType == 1) {
                    AssociationList lMembers = mdObjectSpawner.getDependentComponents();
                    for (Root metadataObject : lMembers) {
                        SimpleLogicalObjectInterface logicalObj = PrivateObjectImportUtility.getLogicalFromJOMAObject(metadataObject);
                        if (logicalObj == null) continue;
                        lLogicalObjects.add(logicalObj);
                    }
                    AssociationList lServercomponent = mdObjectSpawner.getUsedByComponents();
                    for (int iOs = 0; iOs < lServercomponent.size(); ++iOs) {
                        SimpleLogicalObjectInterface lo;
                        ServerComponent srv;
                        CMetadata cm = (CMetadata)lServercomponent.get(iOs);
                        if (!cm.getCMetadataType().equalsIgnoreCase("ServerComponent") || !"Server.OSScheduler".equals((srv = (ServerComponent)cm).getPublicType()) || (lo = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)srv)) == null) continue;
                        lLogicalObjects.add(lo);
                    }
                }
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            finally {
                mdStore.dispose();
            }
            return lLogicalObjects;
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }
}

