/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server.connectspawner;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.BaseServerImportListener;
import com.sas.metadata.logical.server.ConfigurablePropertiesHandler;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.logical.server.connectspawner.ConnectSpawnerImportItem;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import java.rmi.RemoteException;
import java.util.List;

public class ConnectSpawnerImportListener
extends BaseServerImportListener {
    private ConfigurablePropertiesHandler confPropHandler;

    public ConnectSpawnerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    @Override
    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new ConnectSpawnerImportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return null;
    }

    @Override
    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        try {
            iRC |= AppServerConnectionUtil.updateConnectionPointForServer(operation, connections);
            if (operation.getPromotionType() == 2) {
                try {
                    ServerUtil.updateHostConnection(operation);
                }
                catch (ServiceException exception) {
                    operation.getLogger().warn((Object)exception.getMessage());
                    iRC = 4;
                }
                catch (RemoteException exception) {
                    operation.getLogger().warn((Object)exception.getMessage());
                    iRC = 4;
                }
            }
            for (ImportItemInterface importItem : objects) {
                List lConnectionPoints = importItem.getConnectionPoints();
                for (ConnectionPointInterface connPoint : lConnectionPoints) {
                    int flags;
                    String searchCriteria;
                    if ("Machine".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + connPoint.getSourceSearchString() + "\"/>";
                        flags = 8576;
                        List MachineList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Machine", flags, searchCriteria);
                        if (!MachineList.isEmpty()) {
                            Machine machineObj = (Machine)MachineList.get(0);
                            connPoint.setTargetID(machineObj.getFQID());
                            connections.add(connPoint);
                        }
                    }
                    if ("ServerComponent".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + connPoint.getSourceSearchString() + "\"/>";
                        flags = 8576;
                        List serverList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "ServerComponent", flags, searchCriteria);
                        if (!serverList.isEmpty()) {
                            ServerComponent serverObj = (ServerComponent)serverList.get(0);
                            connPoint.setTargetID(serverObj.getFQID());
                            connections.add(connPoint);
                        }
                    }
                    if (!"ServerContext".equals(connPoint.getMetadataType())) continue;
                    searchCriteria = "<XMLSelect search=\"" + connPoint.getSourceSearchString() + "\"/>";
                    flags = 8576;
                    List ContextList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "ServerContext", flags, searchCriteria);
                    if (ContextList.isEmpty()) continue;
                    ServerContext ContextObj = (ServerContext)ContextList.get(0);
                    connPoint.setTargetID(ContextObj.getFQID());
                    connections.add(connPoint);
                }
            }
        }
        catch (MdException mde) {
            iRC = 8;
        }
        catch (RemoteException e) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)e);
        }
        return iRC;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean backupSuccess = AppServerConnectionUtil.backupConfigurableProperties(this.confPropHandler, objects);
        return backupSuccess ? 0 : 4;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.confPropHandler = ConfigurablePropertiesHandler.getInstance();
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        boolean restored = AppServerConnectionUtil.restoreConfigurableProperties(this.confPropHandler, objects);
        return restored ? 0 : 4;
    }
}

