/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.AppServerValidationUtil;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SpawnerConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    public static final String TYPE_NAME = "Spawner";
    private static String CLASS_NAME = SpawnerConnectionType.class.getName();
    private Map<String, List<TargetConnectionInterface>> targetConnections = new HashMap<String, List<TargetConnectionInterface>>(2);
    private SPAWNER_CONNECTIONS connection;
    private List _spawnerConnectionPoints;

    public SpawnerConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceValue) throws MdException, RemoteException {
        String sourceConnectionPublicType = sourceValue.getConnectionPoint().getPublicType();
        TargetConnectionInterface targetConnection = sourceValue.getConnectionType().getTargetConnection(sourceValue);
        AppServerValidationUtil.validateSpawners(importOperation, sourceValue, response);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public static String getTypeClassName() {
        return CLASS_NAME;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("ObjectSpawnerConnectionType.Spawner.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.SpawnerConnectionPanel";
    }

    public List getSourceConnections() {
        boolean bothConnections = false;
        if (this._spawnerConnectionPoints == null) {
            this._spawnerConnectionPoints = new ArrayList();
            List objectSpawners = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "Spawner.IOM");
            List connectSpawners = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "Spawner.Connect");
            if (objectSpawners.size() > 0 || connectSpawners.size() > 0) {
                LinkedHashMap<String, SourceConnectionInterface> serverMap = new LinkedHashMap<String, SourceConnectionInterface>();
                ArrayList servers = new ArrayList();
                if (objectSpawners.size() > 0) {
                    bothConnections = true;
                    servers.addAll(objectSpawners);
                    this.connection = SPAWNER_CONNECTIONS.IOM;
                }
                if (connectSpawners.size() > 0) {
                    bothConnections &= true;
                    servers.addAll(connectSpawners);
                    this.connection = SPAWNER_CONNECTIONS.CONNECT;
                } else {
                    bothConnections = false;
                }
                if (bothConnections) {
                    this.connection = SPAWNER_CONNECTIONS.BOTH;
                }
                for (ConnectionPointInterface pt : servers) {
                    SourceConnectionInterface source;
                    String SpawnerName = SpawnerConnectionType.getSpawnerName(pt);
                    if (serverMap.containsKey(SpawnerName)) {
                        source = (SourceConnectionInterface)serverMap.get(SpawnerName);
                        source.addConnectionPoint(pt);
                        continue;
                    }
                    source = this.createSourceConnection(pt, SpawnerName);
                    serverMap.put(SpawnerName, source);
                }
                this._spawnerConnectionPoints.addAll(serverMap.values());
            }
        }
        return this._spawnerConnectionPoints;
    }

    public static String getSpawnerName(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@Name='");
        return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
    }

    public List getTargetConnections() throws MdException, RemoteException {
        if (this.connection != SPAWNER_CONNECTIONS.BOTH) {
            return this.getTargetConnections(this.connection.getType());
        }
        ArrayList<TargetConnectionInterface> spawners = new ArrayList<TargetConnectionInterface>(this.getTargetConnections(SPAWNER_CONNECTIONS.IOM.getType()));
        spawners.addAll(this.getTargetConnections(SPAWNER_CONNECTIONS.CONNECT.getType()));
        return spawners;
    }

    List<TargetConnectionInterface> getTargetConnections(String spawnerType) throws MdException, RemoteException {
        List<TargetConnectionInterface> targetSpawners = null;
        if (this.targetConnections.containsKey(spawnerType)) {
            targetSpawners = this.targetConnections.get(spawnerType);
        } else {
            List<ServerInterface> spawners = this.getTargetSpawners(spawnerType);
            if (spawners != null) {
                targetSpawners = new ArrayList<TargetConnectionInterface>(spawners.size());
                for (ServerInterface server : spawners) {
                    try {
                        targetSpawners.add(this.createTargetConnection(server.getIdentifier(), "ServerComponent", server.getName()));
                    }
                    catch (ServiceException serviceException) {}
                }
                this.targetConnections.put(spawnerType, targetSpawners);
            }
        }
        return targetSpawners;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        String targetId = connection.getConnectionPoint().getTargetID();
        return targetId != null;
    }

    private List<ServerInterface> getTargetSpawners(String type) {
        List spawners = null;
        try {
            Filter f = new Filter();
            f.setFilterComponent(new FilterComponent("PublicType", 0, type));
            spawners = this._operation.getServer().search((FilterInterface)f);
        }
        catch (ServiceException exception) {
            this._operation.getLogger().error((Object)exception.getLocalizedMessage());
        }
        catch (RemoteException exception) {
            this._operation.getLogger().error((Object)exception.getLocalizedMessage());
        }
        return spawners == null ? Collections.EMPTY_LIST : spawners;
    }

    boolean bothSpawnerConnectionRequired() {
        return this.connection == SPAWNER_CONNECTIONS.BOTH;
    }

    private List<ServerInterface> filterConnectSpawners(List<ServerInterface> spawners) {
        boolean removeSpawner = true;
        ArrayList<ServerInterface> connectSpawners = new ArrayList<ServerInterface>(spawners.size());
        for (ServerInterface connectSpawner : spawners) {
            try {
                ServerComponent component = (ServerComponent)connectSpawner.getRepositoryEntity();
                ServerComponent connectServer = null;
                AssociationList connectServers = component.getUsedByComponents();
                if (connectServers != null && connectServers.size() > 0) {
                    connectServer = (ServerComponent)connectServers.get(0);
                    String targetContextId = this.getTargetContextId(connectServer);
                    List appServers = ((ImportOperationInterface)this._operation).getImportItems("ApplicationServer");
                    for (ImportItemInterface appServer : appServers) {
                        if (targetContextId == null || !targetContextId.equals(appServer.getTargetID())) continue;
                        removeSpawner = false;
                        break;
                    }
                } else {
                    removeSpawner = false;
                }
                if (removeSpawner) continue;
                connectSpawners.add(connectSpawner);
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException mdException) {}
        }
        return connectSpawners;
    }

    private String getTargetContextId(ServerComponent connectServer) throws MdException, RemoteException {
        ServerComponent serverContext;
        AssociationList serverContexts;
        ServerComponent server;
        AssociationList logicalServers = connectServer.getUsedByComponents();
        if (logicalServers != null && logicalServers.size() > 0 && (server = (ServerComponent)logicalServers.get(0)) != null && (serverContexts = server.getUsedByComponents()) != null && serverContexts.size() > 0 && (serverContext = (ServerComponent)serverContexts.get(0)) != null) {
            return serverContext.getId();
        }
        return null;
    }

    private static enum SPAWNER_CONNECTIONS {
        IOM("Spawner.IOM"),
        CONNECT("Spawner.Connect"),
        BOTH("");

        private final String type;

        private SPAWNER_CONNECTIONS(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }
    }
}

