/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ServersOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int m_iInitialContent;
    private TriStateCheckBox m_ckbIncludeContent;
    private SimpleLogicalObjectInterface[] m_items;
    private int m_promotionType;
    private PromotionPropertiesFile m_propertiesFile;
    private JButton m_btnViewColumns;

    public ServersOptionsPanel(int promotionType) {
        this.m_promotionType = promotionType;
        String cbText = "";
        String mnText = "V";
        this.m_ckbIncludeContent = new TriStateCheckBox();
        this.m_ckbIncludeContent.setSelected(true);
        this.m_ckbIncludeContent.setText(Util.getLabelWithoutMnemonic((String)cbText));
        this.m_ckbIncludeContent.setMnemonic(Util.getDisplayedMnemonic((String)cbText));
        this.m_ckbIncludeContent.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)cbText));
        this.m_ckbIncludeContent.setToolTipText(RB.getStringResource("ServerOptionPanel.ckbIncludeContent.Tooltip.txt"));
        this.m_ckbIncludeContent.setCycleEnabled(false);
        this.m_btnViewColumns.setMnemonic(Util.getDisplayedMnemonic((String)mnText));
        this.m_btnViewColumns.setText(RB.getStringResource("ServerOptionPanel.btnViewColumns.btText.txt"));
        this.m_btnViewColumns.setSize(20, 10);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_ckbIncludeContent, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 26;
        this.add((Component)this.m_btnViewColumns, gbc);
    }

    public void populateExportOptions(ExportItemInterface[] items, ExportOperationInterface exportHandler) {
        this.m_items = items;
        this.m_propertiesFile = exportHandler.getPropertiesFile();
        boolean bNoXmlLibraries = true;
        boolean bAllXmlLibraries = true;
        boolean bAllInclude = true;
        boolean bNoInclude = true;
        try {
            for (int i = 0; i < this.m_items.length; ++i) {
                ExportItemInterface exportItem = items[i];
                String engine = exportHandler.getMetadataFactory().getOMIUtil().getMetadataSimple("SASLibrary", exportItem.getID(), "Engine");
                if (engine.equalsIgnoreCase("XML")) {
                    bNoXmlLibraries &= false;
                    continue;
                }
                bAllXmlLibraries &= false;
            }
        }
        catch (MdException mde) {
            UtilGui.displayMdException((MdException)mde);
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
        }
        if (bNoXmlLibraries) {
            this.m_iInitialContent = 0;
            this.m_ckbIncludeContent.setEnabled(false);
        } else {
            if (bAllXmlLibraries) {
                this.m_ckbIncludeContent.setEnabled(true);
            } else {
                this.m_ckbIncludeContent.setEnabled(false);
            }
            this.m_iInitialContent = bAllInclude ? 2 : (bNoInclude ? 0 : 1);
        }
        this.m_ckbIncludeContent.setSelectedValue(this.m_iInitialContent);
    }

    public void populateImportOptions(ImportItemInterface[] items, ImportOperationInterface importHandler) {
        this.m_items = items;
        this.m_propertiesFile = importHandler.getPropertiesFile();
        this.m_btnViewColumns.setVisible(true);
        boolean bAllHaveContent = true;
        boolean bNoneHaveContent = true;
        boolean bAllInclude = true;
        boolean bNoInclude = true;
        for (int i = 0; i < this.m_items.length; ++i) {
            String sOptionalContent = this.m_propertiesFile.getProperty(this.m_items[i].getID() + "Optional Content: ");
            String string = sOptionalContent = sOptionalContent == null ? "false" : sOptionalContent;
            if (sOptionalContent.equalsIgnoreCase("true")) {
                bNoneHaveContent &= false;
                continue;
            }
            bAllHaveContent &= false;
        }
        if (bNoneHaveContent) {
            this.m_ckbIncludeContent.setEnabled(false);
            this.m_iInitialContent = 0;
        } else {
            if (bAllHaveContent) {
                this.m_ckbIncludeContent.setEnabled(true);
            } else {
                this.m_ckbIncludeContent.setEnabled(false);
            }
            this.m_iInitialContent = bAllInclude ? 2 : (bNoInclude ? 0 : 1);
        }
        this.m_ckbIncludeContent.setSelectedValue(this.m_iInitialContent);
        boolean enableUnMatched = this.enableUnmatchedView(importHandler);
        this.m_btnViewColumns.setEnabled(enableUnMatched);
    }

    private boolean enableUnmatchedView(ImportOperationInterface importHandler) {
        boolean returnValue;
        block5: {
            returnValue = false;
            if (this.m_items != null && this.m_items.length > 0) {
                DefaultImportItem item = (DefaultImportItem)this.m_items[0];
                Log logger = item.getImportOperation().getLogger();
                AbstractImportListener listener = (AbstractImportListener)item.getImportOperation().getImportListener(item.getTypeInterface().getPublicType());
                try {
                    if (listener != null && item.getImportOperation() != null) {
                        returnValue = true;
                        break block5;
                    }
                    returnValue = false;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                returnValue = false;
            }
        }
        return returnValue;
    }

    public void saveSettings() {
        int iState = this.m_ckbIncludeContent.getSelectedValue();
        if (this.m_iInitialContent != iState) {
            for (int i = 0; i < this.m_items.length; ++i) {
                if (this.m_promotionType != 0) continue;
            }
            this.m_iInitialContent = iState;
        }
    }
}

