/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.common.ResourceTemplateUtil;
import com.sas.metadata.logical.security.authenticationdomain.AuthDomain;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class ServerUtil {
    public static final String APP_SERVER_CLASSID = "SAS Application Server";
    public static final String SERVER_DEPENDENCIES_TEMPLATE = "<Templates><ServerComponent><AssociatedMachine/><UsingComponents/></ServerComponent></Templates>";

    public static Map getServersForClassIdentifiers(MdFactory factory, String reposID, List classIdentifierList) {
        Map displayMap = ResourceTemplateUtil.getDisplayNameForClassIdentifiers(factory, reposID, "Server", classIdentifierList);
        for (Map.Entry entry : displayMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value != null && value.length() != 0) continue;
            value = RB.getStringResource("Common.Unknown.txt");
            displayMap.put(entry.getKey(), value);
        }
        return displayMap;
    }

    public static ServerContext findAppServer(MdObjectStore store, String reposID, String serverName) throws RemoteException, MdException {
        if (serverName == null) {
            return null;
        }
        int flags = 16776;
        String xmlSelect = "<XMLSelect search=\"*[@Name='" + serverName + "' and @ClassIdentifier='" + APP_SERVER_CLASSID + "']\"/>";
        MdFactory factory = store.getFactory();
        List objects = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "ServerContext", flags, xmlSelect);
        if (objects != null && objects.size() > 0) {
            return (ServerContext)objects.get(0);
        }
        return null;
    }

    public static int updateAuthDomainConnectionPoint(List connections, ConnectionManagerInterface connectionManager, ServerInterface server, RepositoryInterface repo, Log logger) {
        List listConnectionPoint = connectionManager.getConnections(ConnectionObjectType.MetadataType, "AuthenticationDomain");
        PublicObjectInterface object = null;
        String objectId = null;
        AuthenticationDomain authDomain = null;
        int iRC = 0;
        try {
            for (ConnectionPointInterface cp : listConnectionPoint) {
                if (null != cp.getTargetID()) continue;
                object = ServerUtil.searchByName(cp.getName(), cp.getMetadataType(), server);
                if (null == object) {
                    authDomain = ServerUtil.createAuthDomain(repo, cp);
                    objectId = authDomain.getFQID();
                } else {
                    objectId = object.getIdentifier();
                }
                if (null == objectId) continue;
                cp.setTargetID(objectId);
                connections.add(cp);
            }
            return iRC;
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (MdException mde) {
            iRC |= 4;
            logger.warn((Object)mde.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    private static AuthenticationDomain createAuthDomain(RepositoryInterface repo, ConnectionPointInterface cp) throws ServiceException, RemoteException, MdException {
        AuthenticationDomain authDomain = (AuthenticationDomain)((OMIRepositoryInterface)repo).createMetadata(cp.getName(), cp.getPublicType());
        authDomain.setDesc(cp.getDescription());
        authDomain.setPublicType(cp.getPublicType());
        authDomain.setUsageVersion(AuthDomain.CURRENT_VERSION.encode());
        authDomain.updateMetadataAll();
        return authDomain;
    }

    public static PublicObjectInterface searchByName(String name, String type, ServerInterface server) throws ServiceException, RemoteException {
        Filter filter = new Filter("Name", 0, name);
        filter.setType(type);
        List domainList = server.search((FilterInterface)filter);
        return domainList != null && domainList.size() > 0 ? (PublicObjectInterface)domainList.get(0) : null;
    }

    public static int updateHostConnection(ImportOperationInterface operation) throws ServiceException, RemoteException {
        int rc = 0;
        ConnectionManagerInterface manager = operation.getConnectionManager();
        List cpPoints = manager.getConnections(ConnectionObjectType.MetadataType, "Machine");
        if (cpPoints != null) {
            for (ConnectionPointInterface hostConn : cpPoints) {
                MetadataInterface host = (MetadataInterface)ServerUtil.searchByName(hostConn.getName(), "Machine", operation.getServer());
                if (host == null) continue;
                hostConn.setTargetID(host.getIdentifier());
                if (hostConn.isActive()) continue;
                hostConn.setActive(true);
            }
        }
        return rc;
    }
}

