/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.management.deployment.BaseDeploymentObject;
import com.sas.management.deployment.ConnectionPoint;
import com.sas.management.deployment.DeploymentObject;
import com.sas.management.deployment.ReferencePoint;
import java.util.ArrayList;
import java.util.List;

public class PhysicalLocationConnection {
    public static final String LOCATION_CONNECTION = "PhysicalLocation";
    public static final String LOCATION_SERVER = "LocationServer";
    public static final String LOCATION_TYPE = "LocationType";
    public static final String LOCATION_FILE = "FILE";
    public static final String LOCATION_DIRECTORY = "DIRECTORY";
    private List m_connections = new ArrayList();
    private String m_sSourceName;

    public static ReferencePoint createFileReferencePoint(String sName, String sServerName) {
        ReferencePoint refPoint = new ReferencePoint("File", sName);
        refPoint.setUserObject((Object)LOCATION_CONNECTION);
        refPoint.addAttribute(LOCATION_TYPE, LOCATION_FILE);
        if (sServerName != null) {
            refPoint.addAttribute(LOCATION_SERVER, sServerName);
        }
        return refPoint;
    }

    public static ReferencePoint createDirectoryReferencePoint(String sName, String sServerName) {
        ReferencePoint refPoint = new ReferencePoint("Directory", sName);
        refPoint.setUserObject((Object)LOCATION_CONNECTION);
        refPoint.addAttribute(LOCATION_TYPE, LOCATION_DIRECTORY);
        if (sServerName != null) {
            refPoint.addAttribute(LOCATION_SERVER, sServerName);
        }
        return refPoint;
    }

    public PhysicalLocationConnection(String sourceName) {
        this.m_sSourceName = sourceName;
    }

    public void addConnection(BaseDeploymentObject connection) {
        this.m_connections.add(connection);
    }

    public String getSourceName() {
        return this.m_sSourceName;
    }

    public List getConnections() {
        return this.m_connections;
    }

    public String toString() {
        return this.m_sSourceName;
    }

    public List getDependentObjects() {
        ArrayList<DeploymentObject> dependentObjects = new ArrayList<DeploymentObject>();
        List connectionPoints = this.getConnections();
        for (int i = 0; i < connectionPoints.size(); ++i) {
            BaseDeploymentObject conn = (BaseDeploymentObject)connectionPoints.get(i);
            List objects = null;
            if (conn instanceof ConnectionPoint) {
                objects = ((ConnectionPoint)conn).getAssociatedObjects();
            } else if (conn instanceof ReferencePoint) {
                objects = ((ReferencePoint)conn).getAssociatedObjects();
            }
            int size = objects == null ? 0 : objects.size();
            for (int j = 0; j < size; ++j) {
                DeploymentObject obj = (DeploymentObject)objects.get(j);
                if (!obj.isTopLevelObject()) continue;
                dependentObjects.add(obj);
            }
        }
        return dependentObjects;
    }
}

