/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionComparatorInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class OtherServerConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface,
ConnectionComparatorInterface {
    private static final String TYPE_NAME = "Other Server";
    public static final String SERVER_TYPE_KEY = "ServerType";
    public static final String SERVER_TYPE_VALUE_SCHEDULER = "Scheduler";
    private List _serverConnectionPoints = null;
    private static String CLASS_NAME = OtherServerConnectionType.class.getName();

    public OtherServerConnectionType(PromotionInterface operation) {
        super(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public static String getTypeClassName() {
        return CLASS_NAME;
    }

    public List getSourceConnections() {
        if (this._serverConnectionPoints == null) {
            this._serverConnectionPoints = new ArrayList();
            List servers = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "ServerComponent");
            for (ConnectionPointInterface pt : servers) {
                if (!this.isValidOtherServerConnection(pt)) continue;
                this._serverConnectionPoints.add(this.createSourceConnection(pt, pt.getName()));
            }
        }
        return this._serverConnectionPoints;
    }

    private boolean isValidOtherServerConnection(ConnectionPointInterface cp) {
        String publicType = cp.getPublicType();
        return !"Spawner.Connect".equalsIgnoreCase(publicType) && !"Spawner.IOM".equalsIgnoreCase(publicType) && !SERVER_TYPE_VALUE_SCHEDULER.equalsIgnoreCase(cp.getUserDefinedProperty(SERVER_TYPE_KEY));
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SourceConnectionInterface sourceConnection) throws MdException, RemoteException {
        ConnectionPointInterface pt = sourceConnection.getConnectionPoint();
        if (pt != null && pt.getTargetID() != null) {
            String sourceClassID = OtherServerConnectionType.getClassIdentifier(pt);
            MdFactory factory = importOperation.getMetadataFactory();
            Map target = factory.getOMIUtil().getMetadataNoCache("ServerComponent", pt.getTargetID(), "", 8);
            String targetClassID = (String)target.get("ClassIdentifier");
            if (targetClassID != null) {
                if (targetClassID.equalsIgnoreCase(sourceClassID)) {
                    return;
                }
                response.setReturnCode(2);
                response.setMessage(Message.format((ResourceBundle)RB.getResources(), (String)"OtherServerConnectionType.InvalidSelection.fmt.txt", (Object)sourceConnection.getDisplayName()));
            }
        }
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("OtherServerConnectionType.TypeName.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.OtherServerConnectionPanel";
    }

    public List getTargetConnections() throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        int flags = 8584;
        List targetServers = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._operation.getStore(), this._operation.getRepositoryID(), "ServerComponent", flags, "", false);
        ArrayList<TargetConnectionInterface> servers = new ArrayList<TargetConnectionInterface>(targetServers.size());
        for (ServerComponent server : targetServers) {
            servers.add(this.createTargetConnection((CMetadata)server, server.getName()));
        }
        return servers;
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public static String getClassIdentifier(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int endIndex = searchAttribute.indexOf(93);
        int index = searchAttribute.indexOf("@ClassIdentifier='");
        if (index < endIndex && index > -1) {
            return searchAttribute.substring(index + 18, searchAttribute.indexOf(39, index + 18));
        }
        return "";
    }

    public boolean compareConnection(SourceConnectionInterface source, TargetConnectionInterface target) {
        ConnectionPointInterface pt = source.getConnectionPoint();
        String sourceClassID = OtherServerConnectionType.getClassIdentifier(pt);
        String targetClassID = null;
        CMetadata meta = target.getMetadataObject();
        try {
            if (meta instanceof ServerComponent) {
                targetClassID = ((ServerComponent)meta).getClassIdentifier();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sourceClassID.equalsIgnoreCase(targetClassID);
    }
}

