/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import com.sas.metadata.promotion.visuals.connections.AbstractPromptingPanel;
import com.sas.metadata.promotion.visuals.connections.PromotionTable;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.swing.models.CollectionToComboBoxModelAdapter;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.workspace.WATableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class OtherServerConnectionPanel
extends AbstractConnectionPanel
implements ActionListener {
    public static final String PANEL_NAME = "OtherServerPanel";
    private Map _targetServerMap = new HashMap();
    protected OtherServerMappingTableEditor m_cellEditor;
    private boolean m_bInitDone;

    public OtherServerConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
    }

    public String getHelpTopicSuffix() {
        return "otherserverwin";
    }

    public String getPanelBorderLabel() {
        return RB.getStringResource("OtherServerConnectionPanel.BorderTitle.txt");
    }

    public String getDefaultSelectionValue() {
        return RB.getStringResource("OtherServerConnectionPanel.DefaultSelection.txt");
    }

    public String getPanelDescription() {
        return RB.getStringResource("OtherServerConnectionPanel.Desc.txt");
    }

    public String getPanelTitle() {
        return RB.getStringResource("OtherServerConnectionPanel.Title.txt");
    }

    private Map getServerTypeMap() {
        ArrayList<String> classIDList = new ArrayList<String>();
        List connections = this.getConnectionPoints();
        for (SourceConnectionInterface source : connections) {
            ConnectionPointInterface pt = source.getConnectionPoint();
            if (pt == null) continue;
            String classID = OtherServerConnectionType.getClassIdentifier(pt);
            classIDList.add(classID);
        }
        return ServerUtil.getServersForClassIdentifiers(this._importOperation.getMetadataFactory(), this._importOperation.getRepositoryID(), classIDList);
    }

    public void populatePanel() {
        this.m_bInitDone = false;
        Map serverTypeMap = this.getServerTypeMap();
        super.populatePanel();
        Table3ColumnsModel tableModel = new Table3ColumnsModel();
        TransformInterface transform = this.getTargetTableTransform();
        this.m_cellEditor = new OtherServerMappingTableEditor((JComboBox)this._comboBox);
        this.m_cellEditor.setClickCountToStart(1);
        this.m_cellEditor.setTransform(transform);
        this.m_cellEditor.setOutputTransform((TransformInterface)IdentityTransform.identityTransform);
        this._comboBox.addActionListener((ActionListener)this);
        this._mappingTable.setCellEditor(-1, 3, (TableCellEditor)((Object)this.m_cellEditor));
        this._mappingTable.setCellEditor(-1, 2, (TableCellEditor)new DefaultTableCellEditor());
        this._mappingTable.setCellRenderer(-1, 2, (TableCellRenderer)new DefaultTableCellRenderer());
        AbstractPromptingPanel.MyComparator myComparator = new AbstractPromptingPanel.MyComparator((AbstractPromptingPanel)this);
        SortableTableModelAdapter sortingModel = new SortableTableModelAdapter((TableModel)((Object)tableModel));
        sortingModel.setDefaultComparator((Comparator)myComparator);
        sortingModel.setSortAllowed(true);
        this._mappingTable.setClearRowSelectionPostSortingAllowed(false);
        this._mappingTable.setModel2((TableModel)sortingModel);
        Map targetMapping = this.getMappingsForTarget();
        Iterator iter = targetMapping.keySet().iterator();
        while (iter.hasNext()) {
            Vector<String> row = new Vector<String>(3);
            SourceConnectionInterface source = (SourceConnectionInterface)iter.next();
            ConnectionPointInterface pt = source.getConnectionPoint();
            String sType = (String)serverTypeMap.get(OtherServerConnectionType.getClassIdentifier(pt));
            if (sType != null) {
                row.add(sType);
            } else {
                row.add(RB.getStringResource("Common.Unknown.txt"));
            }
            row.add((String)source);
            row.add((String)targetMapping.get(source));
            ((Table3ColumnsModel)((Object)sortingModel.getModel())).addRow(row);
        }
        this.m_bInitDone = true;
        int rowCount = this._mappingTable.getRowCount();
        if (rowCount > 0) {
            this._mappingTable.setRowSelectionInterval(0, 0);
        }
        this._infoTabber.getModel().addChangeListener((ChangeListener)((Object)this));
        this.updateTab();
    }

    public List getTargetValuesList(Object source) {
        if (source instanceof SourceConnectionInterface) {
            List servers;
            block4: {
                SourceConnectionInterface sourceConnection = (SourceConnectionInterface)source;
                ConnectionPointInterface pt = sourceConnection.getConnectionPoint();
                String classID = OtherServerConnectionType.getClassIdentifier(pt);
                if (this._targetServerMap.containsKey(classID)) {
                    return (List)this._targetServerMap.get(classID);
                }
                String TEMPLATE = "<XMLSelect Search=\"*[@ClassIdentifier='" + classID + "']\"/><Templates><ServerComponent Name=\"\"></ServerComponent></Templates>";
                servers = null;
                try {
                    servers = this.getTargetServers(TEMPLATE);
                    this._targetServerMap.put(classID, servers);
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block4;
                    this._log.error((Object)e.getLocalizedMessage());
                }
            }
            return servers;
        }
        return new ArrayList();
    }

    private List getTargetServers(String template) throws MdException, RemoteException {
        MdFactory factory = this._importOperation.getMetadataFactory();
        int flags = 8580;
        List targetServers = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._importOperation.getStore(), this._importOperation.getRepositoryID(), "ServerComponent", flags, template);
        ArrayList<TargetConnectionInterface> servers = new ArrayList<TargetConnectionInterface>(targetServers.size());
        for (ServerComponent server : targetServers) {
            TargetConnectionInterface target = ((OtherServerConnectionType)this._connectionType).createTargetConnection((CMetadata)server, server.getName());
            servers.add(target);
        }
        return servers;
    }

    protected void updateTab() {
        int row;
        PromotionTable table;
        JPanel panel;
        Component comp = this.getInfoTabber().getSelectedComponent();
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0 && (comp = panel.getComponent(0)) instanceof AbstractPromotionPanel && (table = this.getCurrentMappingTable()) != null && (row = table.getSelectedRow()) != -1) {
            ((AbstractPromotionPanel)comp).loadComponent(table.getValueAt(row, 1), null);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.m_bInitDone) {
            super.valueChanged(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source;
        if (e != null && (source = e.getSource()) == this._comboBox) {
            Map mapping;
            Object selectedItem = this._comboBox.getSelectedItem();
            PromotionTable table = this.getCurrentMappingTable();
            SourceConnectionInterface mappingSource = null;
            if (table != null && table.isEditing()) {
                table.getCellEditor().cancelCellEditing();
                mappingSource = (SourceConnectionInterface)((OtherServerMappingTableEditor)((Object)table.getCellEditor())).getLastSource();
            }
            if (selectedItem != null && (mapping = this.getMappingsForTarget()) != null) {
                for (Map.Entry entry : mapping.entrySet()) {
                    if (!entry.getKey().equals(mappingSource)) continue;
                    entry.setValue(selectedItem);
                }
            }
        }
    }

    class Table3ColumnsModel
    extends WATableModel {
        Vector vectorTableData = new Vector();

        Table3ColumnsModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return this.vectorTableData.size();
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return RB.getStringResource("OtherServerConnectionPanel.TableColumn.ServerType.txt");
            }
            if (col == 1) {
                return RB.getStringResource("OtherServerConnectionPanel.TableColumn.ServerName.txt");
            }
            if (col == 2) {
                return RB.getStringResource("OtherServerConnectionPanel.TableColumn.ServerTarget.txt");
            }
            return "Undef";
        }

        public Object getValueAt(int row, int col) {
            try {
                Vector rowData = (Vector)this.vectorTableData.elementAt(row);
                if (rowData != null) {
                    return rowData.elementAt(col);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isCellEditable(int row, int col) {
            return col > 1;
        }

        public void setValueAt(Object value, int row, int col) {
            ((Vector)this.vectorTableData.elementAt(row)).setElementAt(value, col);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow(Vector someVector) {
            this.vectorTableData.addElement(someVector);
            this.fireTableRowsInserted(this.vectorTableData.size() - 1, this.vectorTableData.size() - 1);
        }

        public void removeRow(int row) {
            this.vectorTableData.removeElementAt(row);
            this.fireTableRowsDeleted(this.vectorTableData.size(), this.vectorTableData.size());
        }

        public Vector getRow(int row) {
            return (Vector)this.vectorTableData.elementAt(row);
        }

        public void removeAll() {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.removeRow(i);
            }
        }
    }

    class OtherServerMappingTableEditor
    extends DefaultTableCellEditor {
        int m_currentRow;
        int m_currentCol;
        JTable m_Table;
        Object m_Value;
        Object m_lastSource;
        private CollectionToComboBoxModelAdapter comboAdapter;

        public OtherServerMappingTableEditor(JComboBox comboBox) {
            super(comboBox);
            this.comboAdapter = new CollectionToComboBoxModelAdapter();
            comboBox.setModel(this.comboAdapter);
            AbstractPromptingPanel.MappingComboListCellRenderer comboRenderer = new AbstractPromptingPanel.MappingComboListCellRenderer((AbstractPromptingPanel)OtherServerConnectionPanel.this, OtherServerConnectionPanel.this.getTargetTableTransform());
            comboBox.setRenderer(comboRenderer);
        }

        public void cancelCellEditing() {
            this.m_Table.setValueAt(this.m_Value, this.m_currentRow, this.m_currentCol);
            this.m_lastSource = this.m_Table.getValueAt(this.m_currentRow, 1);
        }

        public Object getLastSource() {
            return this.m_lastSource;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_currentRow = row;
            this.m_currentCol = column;
            this.m_Table = table;
            this.m_Value = value;
            List listData = OtherServerConnectionPanel.this.getTargetValuesList(table.getValueAt(row, 1));
            this.comboAdapter.setModel((Collection)listData);
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            JComboBox combo = (JComboBox)comp;
            if (listData.contains(value)) {
                combo.setSelectedItem(value);
            } else if (value != null) {
                for (Object availItem : listData) {
                    if (availItem != null && availItem.toString().trim().equals(value.toString().trim())) {
                        combo.setSelectedItem(availItem);
                        this.m_Value = availItem;
                        break;
                    }
                    if (OtherServerConnectionPanel.this.getTargetTableTransform() == null) continue;
                    try {
                        Object transformedValue = OtherServerConnectionPanel.this.getTargetTableTransform().transform(availItem);
                        if (transformedValue == null || !transformedValue.toString().trim().equals(value.toString().trim())) continue;
                        combo.setSelectedItem(availItem);
                        this.m_Value = availItem;
                        break;
                    }
                    catch (TransformException transformException) {
                    }
                }
            } else {
                combo.setSelectedItem(value);
            }
            return combo;
        }
    }
}

