/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.AbstractPathSubstitutionType;
import com.sas.metadata.logical.server.PhysicalDirectoryManager;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionPropertiesInterface;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class FilePathSubstitutionType
extends AbstractPathSubstitutionType
implements SubstitutionTypeInterface,
SubstitutionPropertiesInterface {
    public static final String TYPE_NAME = "FilePath";
    private PhysicalDirectoryManager _dirManager;

    public String getSubstitutionTypeName() {
        return TYPE_NAME;
    }

    public boolean isSubstitutionRequired(SubstitutionInterface substitution) {
        return true;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("FilePathSubstitutionType.TypeName.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.FilePathSubstitutionPanel";
    }

    public String getLocalizedContextName() {
        return RB.getStringResource("FilePathSubstitutionType.Server.txt");
    }

    public String getLocalizedSubstitutionName() {
        return this.getLocalizedTypeName();
    }

    public void validate(ValidationResponse response, ImportOperationInterface importOperation, SubstitutionInterface substitution) throws MdException, RemoteException {
        block9: {
            if (substitution != null) {
                String targetServer;
                if (importOperation.isInstallProcess()) {
                    return;
                }
                Object prop = substitution.getOption(1);
                if (prop != null && prop.equals(Boolean.FALSE)) {
                    return;
                }
                String targetValue = substitution.getTargetValue();
                if (targetValue != null && targetValue.length() > 0 && (targetServer = substitution.getTargetContextValue()) != null) {
                    try {
                        boolean exists;
                        ServerContext server = this.getServerByName(targetServer, (PromotionInterface)importOperation);
                        if (server == null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FilePathSubstitutionType.NoServer.fmt.txt", (Object)targetValue, (Object)targetServer);
                            importOperation.getLogger().info((Object)msg);
                            return;
                        }
                        if (this._dirManager == null) {
                            this._dirManager = new PhysicalDirectoryManager((PromotionInterface)importOperation);
                        }
                        if (!(exists = this._dirManager.exists(server, targetValue))) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FilePathSubstitutionType.DoesNotExist.fmt.txt", (Object)targetValue, (Object)targetServer);
                            response.setReturnCode(1);
                            response.setMessage(msg);
                        }
                    }
                    catch (Exception e) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FilePathSubstitutionType.UnableToValidate.fmt.txt", (Object)targetValue, (Object)targetServer);
                        importOperation.getLogger().info((Object)msg);
                        if (!importOperation.getLogger().isDebugEnabled()) break block9;
                        importOperation.getLogger().debug((Object)e);
                    }
                }
            }
        }
    }
}

