/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurablePropertiesHandler {
    private Map<String, ConfigurableProperties> conProperties = new HashMap<String, ConfigurableProperties>();
    private static List<String> configurableTypes = new ArrayList<String>(4);

    private ConfigurablePropertiesHandler() {
    }

    public static ConfigurablePropertiesHandler getInstance() {
        return new ConfigurablePropertiesHandler();
    }

    public boolean backup(ImportItemInterface importItem) throws ServiceException, RemoteException, MdException {
        PublicObjectInterface object = ObjectConverter.getInstance().convertToTargetPublicObject(importItem, importItem.getImportOperation().getServer());
        boolean backedup = false;
        if (object != null) {
            HashMap publicProperties = new HashMap();
            HashMap privateProperties = new HashMap();
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)((ServerComponent)((MetadataInterface)object).getRepositoryEntity()), publicProperties, privateProperties);
            if (publicProperties.size() > 0 || privateProperties.size() > 0) {
                this.conProperties.put(importItem.getName(), new ConfigurableProperties(importItem.getTargetID(), privateProperties, publicProperties));
                backedup = true;
            }
        }
        if (importItem.containsNestedItems()) {
            List children = importItem.getNestedItems();
            for (ImportItemInterface child : children) {
                if (!this.backupRequired(child)) continue;
                this.backup(child);
            }
        }
        return backedup;
    }

    public boolean backupRequired(ImportItemInterface importItem) {
        return this.isConfigurableObject(importItem) && importItem.getImportState() == 2;
    }

    private boolean isConfigurableObject(ImportItemInterface importItem) {
        return configurableTypes.contains(importItem.getTypeInterface().getMetadataType()) || configurableTypes.contains(importItem.getTypeInterface().getPublicType());
    }

    public void restore(ImportItemInterface importItem) throws ServiceException, RemoteException, MdException {
        SoftwareComponent softwareComponent = this.getTargetObject(importItem);
        if (softwareComponent != null) {
            if (this.removeProperties(importItem)) {
                ConfigurablePropertiesUtil.removeObjectProperties((SoftwareComponent)softwareComponent);
            } else if (importItem.getImportState() == 2) {
                ConfigurableProperties props = this.getProperties(importItem);
                if (props != null) {
                    ConfigurablePropertiesUtil.setObjectProperties((SoftwareComponent)softwareComponent, props.publicProperties, props.privateProperties);
                } else {
                    ConfigurablePropertiesUtil.removeObjectProperties((SoftwareComponent)softwareComponent);
                }
            }
        }
        if (importItem.containsNestedItems()) {
            List children = importItem.getNestedItems();
            for (ImportItemInterface child : children) {
                if (!this.restoreRequired(child)) continue;
                this.restore(child);
            }
        }
    }

    private boolean removeProperties(ImportItemInterface importItem) {
        boolean removeProps = false;
        removeProps = importItem instanceof NestedImportItemInterface ? importItem.getImportState() == -1 : importItem.getImportState() == 1;
        return removeProps;
    }

    private SoftwareComponent getTargetObject(ImportItemInterface importItem) throws MdException, RemoteException {
        String searchCriteria = "<XMLSelect Search=\"*[ @Name='" + importItem.getName() + "']\" />";
        int flags = 8576;
        ImportOperationInterface operation = importItem.getImportOperation();
        MdObjectStore store = operation.getMetadataFactory().createObjectStore();
        List servers = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, operation.getRepositoryID(), importItem.getTypeInterface().getMetadataType(), flags, searchCriteria);
        return servers != null && servers.size() > 0 ? (SoftwareComponent)servers.get(0) : null;
    }

    private ConfigurableProperties getProperties(ImportItemInterface importItem) {
        String key = importItem.isRenamed() ? importItem.getOriginalName() : importItem.getName();
        return this.conProperties.get(key);
    }

    public boolean restoreRequired(ImportItemInterface importItem) {
        return this.isConfigurableObject(importItem);
    }

    static {
        configurableTypes.add("ServerContext");
        configurableTypes.add("LogicalServer");
        configurableTypes.add("Spawner.IOM");
        configurableTypes.add("Spawner.Connect");
    }

    private class ConfigurableProperties {
        Map<String, String> publicProperties;
        Map<String, String> privateProperties;
        String objectRef;

        private ConfigurableProperties(String id, Map<String, String> privateP, Map<String, String> publicP) {
            this.objectRef = id;
            this.publicProperties = publicP;
            this.privateProperties = privateP;
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof ConfigurableProperties) {
                return this.objectRef.equals(((ConfigurableProperties)anObject).objectRef);
            }
            return false;
        }

        public int hashCode() {
            return this.objectRef.hashCode();
        }
    }
}

