/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.server.BaseServerImportItem;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.PortSubstitutionType;
import com.sas.metadata.logical.server.ServerUniqueNameValidator;
import com.sas.metadata.logical.server.ServerUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import java.rmi.RemoteException;
import java.util.List;

public class BaseServerImportListener
extends AbstractImportListener {
    public BaseServerImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new BaseServerImportItem(name, id, type);
    }

    public Class[] getSubstitutionTypes() {
        return new Class[]{HostSubstitutionType.class, PortSubstitutionType.class};
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        Log logger = operation.getLogger();
        try {
            ConnectionManagerInterface connectionManager = ConnectionManager.getInstance((PromotionInterface)operation);
            ServerInterface server = operation.getServer();
            RepositoryInterface repo = server.getFoundationRepository();
            for (ImportItemInterface importItem : objects) {
                iRC |= ServerUtil.updateAuthDomainConnectionPoint(connections, connectionManager, server, repo, logger);
            }
            if (operation.getPromotionType() == 2) {
                ServerUtil.updateHostConnection(operation);
            }
            return iRC;
        }
        catch (RemoteException re) {
            iRC |= 4;
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            iRC |= 4;
            logger.warn((Object)se.getMessage());
        }
        catch (Exception e) {
            iRC |= 4;
            logger.warn((Object)e.getMessage());
        }
        return iRC;
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        ServerUniqueNameValidator uniqueNameValidator = ServerUniqueNameValidator.getRepositoryNameValidator();
        uniqueNameValidator.setNestedNamevalidate(true);
        return uniqueNameValidator;
    }
}

