/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.AppServerConnectionUtil;
import com.sas.metadata.logical.server.ApplicationServerExportItem;
import com.sas.metadata.logical.server.CommandSubstitutionType;
import com.sas.metadata.logical.server.HostSubstitutionType;
import com.sas.metadata.logical.server.PortSubstitutionType;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.logical.server.SpawnerConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public class ApplicationServerExportListener
extends AbstractExportListener {
    private Class[] CONNECTION_TYPES = new Class[]{SpawnerConnectionType.class};
    private Class[] SUBSTITUTION_TYPES = new Class[]{HostSubstitutionType.class, PortSubstitutionType.class, CommandSubstitutionType.class};
    private static final String APPLICATION_NAME_PREFIX = "Web Infra Platform Services";
    private static final String SERVER_CONTEXT_PROPERTIES = "ServerContextProperties";
    private static final String CONNECTED_APPLICATION_TEMPLATE = "<Templates><ServerContext><ImplementedObjects/></ServerContext><PropertySet><SetProperties/><OwningObject/></PropertySet><DeployedComponent><DescriptiveComponent/></DeployedComponent></Templates>";

    public ApplicationServerExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ApplicationServerExportItem(name, id, type);
    }

    public int analyzeConnections(ExportOperationInterface operation, List objects) throws MdException, RemoteException {
        int rc = 0;
        rc = AppServerConnectionUtil.updateExportSpawnerConnection(objects);
        return rc |= this.analyzeServerContextConnectionsOnExport(operation, objects);
    }

    public Class[] getConnectionTypes() {
        return this.CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return this.SUBSTITUTION_TYPES;
    }

    private int analyzeServerContextConnectionsOnExport(ExportOperationInterface operation, List objects) throws RemoteException, MdException {
        int rc = 0;
        if (operation.getPromotionType() == 2) {
            return rc;
        }
        for (Object o : objects) {
            ExportItemInterface exportItem = (ExportItemInterface)o;
            String exportItemID = exportItem.getID();
            try {
                ServerContext context = (ServerContext)UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"ServerContext", (String)exportItemID, (String)CONNECTED_APPLICATION_TEMPLATE);
                AssociationList implementors = context.getImplementedObjects();
                if (implementors == null || implementors.isEmpty()) continue;
                for (CMetadata prop : implementors) {
                    SoftwareComponent application;
                    Root owningComponent;
                    PropertySet ps;
                    Root owningPropertySet;
                    if (!"PropertySet".equalsIgnoreCase(prop.getCMetadataType()) || !SERVER_CONTEXT_PROPERTIES.equalsIgnoreCase(prop.getName()) || !((owningPropertySet = (ps = (PropertySet)prop).getOwningObject()) instanceof PropertySet) || !((owningComponent = ((PropertySet)owningPropertySet).getOwningObject()) instanceof DeployedComponent) || (application = ((DeployedComponent)owningComponent).getDescriptiveComponent()) == null || !application.getName().startsWith(APPLICATION_NAME_PREFIX)) continue;
                    operation.getLogger().debug((Object)("Creating a connection between the server " + exportItem.getName() + " and the Web Infra Platform Services application."));
                    ConnectionManagerInterface connectionManager = operation.getConnectionManager();
                    ConnectionPointInterface cp = connectionManager.createConnection("PropertySet", ps.getId(), SERVER_CONTEXT_PROPERTIES);
                    cp.addAssociatedObject((PromotionItemInterface)exportItem);
                    cp.addUserDefinedProperty("ApplicationName", APPLICATION_NAME_PREFIX);
                    cp.addUserDefinedProperty("ComponentClassId", ((DeployedComponent)owningComponent).getClassIdentifier());
                    StringBuilder sb = new StringBuilder();
                    sb.append("<Properties>");
                    AssociationList properties = ps.getSetProperties();
                    for (Property property : properties) {
                        sb.append("<Property ");
                        sb.append("Name=\"").append(property.getName()).append("\" ");
                        sb.append("DefaultValue=\"").append(XMLUtil.normalize((String)property.getDefaultValue())).append("\" ");
                        sb.append("SQLType=\"").append(property.getSQLType()).append("\" ");
                        sb.append("/>");
                    }
                    sb.append("</Properties>");
                    cp.addUserDefinedProperty("SetProperties", sb.toString());
                }
            }
            catch (MdException e) {
                rc |= 8;
                operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServerExportListener.connection.retrieval.err.fmt", (Object)exportItem.getName(), (Object)APPLICATION_NAME_PREFIX));
                if (!operation.getLogger().isDebugEnabled()) continue;
                operation.getLogger().debug((Object)"Cause:", (Throwable)e);
            }
        }
        return rc;
    }
}

