/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

class AppServerValidationUtil {
    AppServerValidationUtil() {
    }

    static void validatePort(String targetPort, ValidationResponse response) {
        response.setReturnCode(0);
        if (targetPort != null) {
            try {
                Integer.parseInt(targetPort);
            }
            catch (NumberFormatException exception) {
                response.setReturnCode(2);
                response.setMessage(Message.format((String)RB.getStringResource("ApplicationServer.portsub.nonint.err.fmt.txt"), (Object)targetPort));
            }
        }
    }

    static void validateHost(String hostName, ValidationResponse response) {
        response.setReturnCode(0);
        if (hostName == null || hostName.equals("")) {
            response.setReturnCode(2);
            response.setMessage(RB.getStringResource("ApplicationServer.hostconnection.blank.err.txt"));
        }
    }

    static void validateSpawners(ImportOperationInterface operation, SourceConnectionInterface sourceValue, ValidationResponse response) {
        String targetId = sourceValue.getConnectionPoint().getTargetID();
        String sourcePublicType = sourceValue.getConnectionPoint().getPublicType();
        if (targetId != null) {
            try {
                String objectKey = SASFoldersUtil.getISEntityKey((String)targetId, (String)"ServerComponent");
                MetadataInterface spawner = operation.getServer().fetch(objectKey);
                if (spawner != null) {
                    if (sourcePublicType.equals(spawner.getType())) {
                        response.setReturnCode(0);
                    } else {
                        response.setReturnCode(2);
                        response.setMessage(Message.format((ResourceBundle)RB.getResources(), (String)"ApplicationServer.invalid.spawnertype.err.fmt", (Object)sourceValue.getConnectionPoint().getName(), (Object)sourcePublicType.substring(sourcePublicType.indexOf("."))));
                    }
                }
            }
            catch (ServiceException exception) {
                operation.getLogger().error((Object)exception.getLocalizedMessage());
            }
            catch (RemoteException exception) {
                operation.getLogger().error((Object)exception.getLocalizedMessage());
            }
        }
    }
}

