/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class AppServerConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    private static final String TYPE_NAME = "Application Server";
    private static final String CLSID_GRID_SERVER = "d7e796b4-654c-4ab3-b690-657ee79309fb";
    private static final String SERVER_TEMPLATE = "<XMLSelect Search=\"*[@ClassIdentifier='SAS Application Server']\"/><Templates><ServerContext Name=\"\"><UsingComponents/></ServerContext><LogicalServer Name=\"\" ClassIdentifier=\"\"/></Templates>";
    private static Map<String, String> SERVER_TYPE_MAP = new HashMap<String, String>(4);
    private static String CLASS_NAME;
    private List<SourceConnectionInterface> _serverConnectionPoints;

    public AppServerConnectionType(PromotionInterface operation) {
        super(operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public static String getTypeClassName() {
        return CLASS_NAME;
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._serverConnectionPoints == null) {
            this._serverConnectionPoints = new ArrayList<SourceConnectionInterface>();
            List logicalServers = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "LogicalServer");
            List serverContexts = this._connectionManager.getConnections(ConnectionObjectType.MetadataType, "ServerContext");
            if (logicalServers.size() > 0 || serverContexts.size() > 0) {
                LinkedHashMap<String, SourceConnectionInterface> serverMap = new LinkedHashMap<String, SourceConnectionInterface>();
                ArrayList servers = new ArrayList();
                servers.addAll(logicalServers);
                servers.addAll(serverContexts);
                for (ConnectionPointInterface pt : servers) {
                    SourceConnectionInterface source;
                    if (!AppServerConnectionType.isAppServerConnection(pt)) continue;
                    String serverContextName = AppServerConnectionType.getServerContextName(pt);
                    if (serverMap.containsKey(serverContextName)) {
                        source = (SourceConnectionInterface)serverMap.get(serverContextName);
                        source.addConnectionPoint(pt);
                        continue;
                    }
                    source = this.createSourceConnection(pt, serverContextName);
                    serverMap.put(serverContextName, source);
                }
                this._serverConnectionPoints.addAll(serverMap.values());
            }
        }
        return this._serverConnectionPoints;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("AppServerConnectionType.TypeName.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.AppServerConnectionPanel";
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public String getTargetConnectionID(ConnectionPointInterface pt, TargetConnectionInterface targetValue) throws MdException, RemoteException {
        CMetadata meta = targetValue.getMetadataObject();
        if (meta instanceof ServerContext) {
            if ("ServerContext".equals(pt.getMetadataType())) {
                return targetValue.getTargetID();
            }
            if ("LogicalServer".equals(pt.getMetadataType())) {
                ServerContext server = (ServerContext)meta;
                AssociationList logicalServers = server.getUsingComponents(false);
                if (logicalServers.size() == 0) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AppServerConnectionType.NoLogicalServers.fmt.txt", (Object)server.getName());
                    throw new MdException(msg);
                }
                String classID = AppServerConnectionType.getClassIdentifier(pt.getSourceSearchString());
                for (DeployedComponent comp : logicalServers) {
                    if (!comp.getClassIdentifier().equalsIgnoreCase(classID)) continue;
                    return comp.getId();
                }
                StringBuilder sb = new StringBuilder();
                String serverType = SERVER_TYPE_MAP.get(classID.toLowerCase());
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"AppServerConnectionType.ServerNotFound.fmt.txt", (Object)server.getName(), (Object)serverType));
                sb.append("\n");
                List objects = pt.getAssociatedObjects();
                int count = 0;
                for (ImportItemInterface item : objects) {
                    if (item.getImportState() == 0) continue;
                    if (count > 0) {
                        sb.append(", ");
                    }
                    String object = Message.format((ResourceBundle)RB.getResources(), (String)"AppServerConnectionType.ObjectName.fmt.txt", (Object)item.getName(), (Object)item.getTypeInterface().getDisplayType());
                    sb.append(object);
                    if (++count <= 8) continue;
                    sb.append(", ");
                    sb.append(RB.getStringResource("AppServerConnectionType.Others.txt"));
                    break;
                }
                throw new MdException(sb.toString());
            }
        } else if (meta instanceof LogicalServer && "LogicalServer".equals(pt.getMetadataType())) {
            return targetValue.getTargetID();
        }
        return null;
    }

    public List<TargetConnectionInterface> getTargetConnections() throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        int flags = 8580;
        List targetServers = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)this._operation.getStore(), this._operation.getRepositoryID(), "ServerContext", flags, SERVER_TEMPLATE, false);
        ArrayList<TargetConnectionInterface> servers = new ArrayList<TargetConnectionInterface>(targetServers.size());
        for (ServerContext server : targetServers) {
            servers.add(this.createTargetConnection((CMetadata)server, server.getName()));
        }
        return servers;
    }

    private static boolean isAppServerConnection(ConnectionPointInterface pt) {
        String attr;
        if ("LogicalServer".equals(pt.getMetadataType())) {
            String attr2 = pt.getSourceSearchString();
            if (attr2 != null) {
                int startIndex = attr2.indexOf("UsedByComponents");
                return "SAS Application Server".equals(AppServerConnectionType.getServerContextClassID(attr2, startIndex));
            }
        } else if ("ServerContext".equals(pt.getMetadataType()) && (attr = pt.getSourceSearchString()) != null) {
            return "SAS Application Server".equals(AppServerConnectionType.getServerContextClassID(attr, 0));
        }
        return false;
    }

    public static String getServerContextName(ConnectionPointInterface pt) {
        int startIndex;
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@Name='", startIndex = searchAttribute.indexOf("UsedByComponents"));
        if (index > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    public static String getServerContextName(SourceConnectionInterface source) {
        int startIndex;
        ConnectionPointInterface pt;
        String searchAttribute;
        int index;
        List connections = source.getConnectionPoints();
        if (connections.size() > 0 && (index = (searchAttribute = (pt = (ConnectionPointInterface)connections.get(0)).getSourceSearchString()).indexOf("@Name='", startIndex = searchAttribute.indexOf("DeployedComponents"))) > -1) {
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }

    private static String getServerContextClassID(String attr, int startPos) {
        int index;
        if (startPos > -1 && (index = attr.indexOf("@ClassIdentifier='", startPos)) > -1) {
            return attr.substring(index + 18, attr.indexOf(39, index + 18));
        }
        return null;
    }

    private static String getClassIdentifier(String searchAttribute) {
        int endIndex = searchAttribute.indexOf(93);
        int index = searchAttribute.indexOf("@ClassIdentifier='");
        if (index < endIndex && index > -1) {
            return searchAttribute.substring(index + 18, searchAttribute.indexOf(39, index + 18));
        }
        return "";
    }

    static {
        SERVER_TYPE_MAP.put("440196d4-90f0-11d0-9f41-00a024bb830c", RB.getStringResource("AppServerConnectionType.WorkspaceServer.txt"));
        SERVER_TYPE_MAP.put("15931e31-667f-11d5-8804-00c04f35ac8c", RB.getStringResource("AppServerConnectionType.StoredProcessServer.txt"));
        SERVER_TYPE_MAP.put("620963ee-32bf-4128-bf5f-4b0df8ff90eb", RB.getStringResource("AppServerConnectionType.PooledWorkspaceServer.txt"));
        SERVER_TYPE_MAP.put("f3f46472-1e31-11d5-87c2-00c04f38f9f6", RB.getStringResource("AppServerConnectionType.OLAPServer.txt"));
        SERVER_TYPE_MAP.put(CLSID_GRID_SERVER, RB.getStringResource("AppServerConnectionType.GridServer.txt"));
        CLASS_NAME = AppServerConnectionType.class.getName();
    }
}

