/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class AbstractSpawnerConnectionType
extends AbstractConnectionType
implements ConnectionTypeInterface {
    public static final String TYPE_NAME = "Spawner";
    private List<SourceConnectionInterface> _spawnerConnectionPoints;
    private static final String[] SPAWNER_TYPES = new String[]{"Spawner.IOM", "Spawner.Connect"};

    public AbstractSpawnerConnectionType(PromotionInterface promotionOperation) {
        super(promotionOperation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("ObjectSpawnerConnectionType.Spawner.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.server.ObjectSpawnerConnectionPanel";
    }

    public List<SourceConnectionInterface> getSourceConnections() {
        if (this._spawnerConnectionPoints == null) {
            this._spawnerConnectionPoints = new ArrayList<SourceConnectionInterface>();
            List ObjectSpawners = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "Spawner.IOM");
            List connectSpawners = this._connectionManager.getConnections(ConnectionObjectType.PublicType, "Spawner.Connect");
            if (ObjectSpawners.size() > 0 || connectSpawners.size() > 0) {
                LinkedHashMap<String, SourceConnectionInterface> serverMap = new LinkedHashMap<String, SourceConnectionInterface>();
                ArrayList servers = new ArrayList();
                servers.addAll(ObjectSpawners);
                servers.addAll(connectSpawners);
                for (ConnectionPointInterface pt : servers) {
                    String SpawnerName = AbstractSpawnerConnectionType.getSpawnerName(pt);
                    for (String spawnerType : SPAWNER_TYPES) {
                        SourceConnectionInterface source;
                        if (serverMap.containsKey(spawnerType)) {
                            source = (SourceConnectionInterface)serverMap.get(spawnerType);
                            source.addConnectionPoint(pt);
                            continue;
                        }
                        source = this.createSourceConnection(pt, spawnerType);
                        serverMap.put(spawnerType, source);
                    }
                }
                this._spawnerConnectionPoints.addAll(serverMap.values());
            }
        }
        return this._spawnerConnectionPoints;
    }

    public static String getSpawnerName(ConnectionPointInterface pt) {
        String searchAttribute = pt.getSourceSearchString();
        int index = searchAttribute.indexOf("@Name='");
        return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
    }

    public boolean isConnectionRequired(SourceConnectionInterface connection) {
        return true;
    }

    public List getTargetConnections() throws MdException, RemoteException {
        List spawners = null;
        ArrayList<TargetConnectionInterface> targetSpawners = null;
        try {
            Filter f = new Filter();
            f.setFilterComponent(new FilterComponent("PublicType", 0, this.getSpawnerType()));
            spawners = this._operation.getServer().search((FilterInterface)f);
            if (spawners != null) {
                targetSpawners = new ArrayList<TargetConnectionInterface>(spawners.size());
                for (ServerInterface server : spawners) {
                    targetSpawners.add(this.createTargetConnection(server.getIdentifier(), "ServerComponent", server.getName()));
                }
            }
        }
        catch (ServiceException ex) {
            throw new MdException((Throwable)ex);
        }
        return targetSpawners;
    }

    public abstract String getSpawnerType();
}

