/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.server;

import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.RB;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractSubstitutionPanel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ServerContext;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractPathSubstitutionPanel
extends AbstractSubstitutionPanel {
    private static final String DEFAULT_SELECTION = RB.getStringResource("AbstractPathSubstitutionPanel.DefaultSelection.txt");
    public static final int PATH_TYPE_DIRECTORIES = 0;
    public static final int PATH_TYPE_FILES = 1;

    public AbstractPathSubstitutionPanel(ImportOperationInterface operation, SubstitutionTypeInterface type, List substitutions) {
        super(operation, type, substitutions);
    }

    public abstract int getPathType();

    public String getDefaultSelectionValue() {
        return DEFAULT_SELECTION;
    }

    public int getSelectionType() {
        return 2;
    }

    public void populatePanel() {
        String serverTypeName;
        ConnectionTypeInterface connectionType;
        super.populatePanel();
        Map mappings = this.getMappingsForTarget();
        if (mappings != null && (connectionType = this._importOperation.getConnectionType(serverTypeName = AppServerConnectionType.getTypeClassName())) != null) {
            List sourceServerConnections = connectionType.getSourceConnections();
            block0: for (SubstitutionInterface substitution : mappings.keySet()) {
                String sourceServerName = substitution.getContextValue();
                if (sourceServerName == null) continue;
                for (SourceConnectionInterface source : sourceServerConnections) {
                    if (!sourceServerName.equals(source.getDisplayName())) continue;
                    TargetConnectionInterface target = connectionType.getTargetConnection(source);
                    substitution.setTargetContextValue(target.getDisplayName());
                    continue block0;
                }
            }
        }
    }

    protected TableCellRenderer getTableCellRenderer() {
        return new BrowsableTextFieldCellRenderer();
    }

    protected TableCellEditor getTableCellEditor() {
        BrowsableTextFieldCellEditor editor = new BrowsableTextFieldCellEditor();
        editor.setClickCountToStart(1);
        return editor;
    }

    protected void launchBrowseDialog(int iRow, int iColumn) {
        SubstitutionInterface substitution = (SubstitutionInterface)this._mappingTable.getValueAt(iRow, 0);
        String serverName = substitution.getContextValue();
        String targetLocation = (String)this._mappingTable.getValueAt(iRow, iColumn);
        targetLocation = serverName == null ? this.browseOnLocalFileSystem(targetLocation) : this.browseOnServer(targetLocation, serverName);
        if (targetLocation != null) {
            this._mappingTable.setValueAt((Object)targetLocation, iRow, iColumn);
        }
    }

    private String browseOnLocalFileSystem(String targetLocation) {
        File selectedFile;
        JFileChooser chooser = new JFileChooser(targetLocation);
        chooser.setApproveButtonText(RB.getStringResource("AbstractPathSubstitutionPanel.OKButton.txt"));
        chooser.setDialogTitle(RB.getStringResource("AbstractPathSubstitutionPanel.BrowseTitle.txt"));
        chooser.setFileSelectionMode(this.getPathType() == 1 ? 0 : 1);
        int rc = chooser.showOpenDialog((Component)((Object)this));
        if (rc == 0 && (selectedFile = chooser.getSelectedFile()) != null) {
            targetLocation = selectedFile.getPath();
        }
        return targetLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String browseOnServer(String targetLocation, String serverName) {
        WsAppServer appServer = null;
        String serverTypeName = AppServerConnectionType.getTypeClassName();
        ConnectionTypeInterface connectionType = this._importOperation.getConnectionType(serverTypeName);
        if (connectionType != null) {
            List sourceConnections = connectionType.getSourceConnections();
            for (SourceConnectionInterface source : sourceConnections) {
                TargetConnectionInterface target;
                CMetadata meta;
                if (!serverName.equals(source.getDisplayName()) || !((meta = (target = connectionType.getTargetConnection(source)).getMetadataObject()) instanceof ServerContext)) continue;
                appServer = WsAppServer.createAppServer((ServerContext)((ServerContext)meta));
                break;
            }
        }
        if (appServer != null) {
            try {
                appServer.open();
                int pathType = this.getPathType();
                if (pathType == 0) {
                    targetLocation = appServer.promptForDirectory(RB.getStringResource("AbstractPathSubstitutionPanel.BrowseTitle.txt"), targetLocation, null);
                } else if (pathType == 1) {
                    targetLocation = appServer.promptForFilename(RB.getStringResource("AbstractPathSubstitutionPanel.BrowseTitle.txt"), targetLocation, null);
                }
            }
            catch (Exception e) {
                String sMsg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractPathSubstitutionPanel.BrowseError.fmt", (Object)e.getMessage());
                MessageUtil.displayMessage((String)sMsg, (String)RB.getStringResource("AbstractPathSubstitutionPanel.ErrorTitle.txt"), (int)0);
            }
            finally {
                appServer.dispose();
            }
        }
        return targetLocation;
    }

    class BrowsableTextFieldCellRenderer
    extends DefaultTableCellRenderer {
        private JPanel m_pnlRenderer = new JPanel();
        private JLabel m_lblEditable = new JLabel();
        private JLabel m_lblNonEditable = new JLabel();
        private JButton m_btnBrowse = WsUIUtilities.createBrowseButton();

        BrowsableTextFieldCellRenderer() {
            this.m_lblEditable.setOpaque(true);
            this.m_lblEditable.setBackground(SystemColor.window);
            this.m_lblEditable.setForeground(SystemColor.windowText);
            this.m_pnlRenderer.setLayout(new BorderLayout());
            this.m_pnlRenderer.add((Component)this.m_lblEditable, "Center");
            this.m_pnlRenderer.add((Component)this.m_btnBrowse, "East");
            this.m_lblNonEditable.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean bSelected, boolean hasFocus, int row, int column) {
            int iColumnModelIndex = table.convertColumnIndexToModel(column);
            if (table.getModel().isCellEditable(row, iColumnModelIndex)) {
                String s;
                Object myValue = AbstractPathSubstitutionPanel.this._mappingTable.getValueAt(row, column);
                String sLabel = DEFAULT_SELECTION;
                if (myValue != null && myValue instanceof String && (s = myValue.toString()).length() > 0) {
                    sLabel = s;
                }
                this.m_lblEditable.setText(sLabel);
                return this.m_pnlRenderer;
            }
            this.m_lblNonEditable.setText(value.toString());
            this.m_lblNonEditable.setBackground(bSelected ? table.getSelectionBackground() : SystemColor.control);
            this.m_lblNonEditable.setForeground(bSelected ? table.getSelectionForeground() : SystemColor.controlText);
            return this.m_lblNonEditable;
        }
    }

    class BrowsableTextFieldCellEditor
    extends DefaultTableCellEditor {
        private int m_iRow;
        private int m_iCol;
        private JPanel m_pnlEditor = new JPanel();
        private WATextField m_tfEditor = new WATextField();
        private JButton m_btnBrowse = WsUIUtilities.createBrowseButton();

        BrowsableTextFieldCellEditor() {
            this.m_btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowsableTextFieldCellEditor.this.stopCellEditing();
                    AbstractPathSubstitutionPanel.this.launchBrowseDialog(BrowsableTextFieldCellEditor.this.m_iRow, BrowsableTextFieldCellEditor.this.m_iCol);
                }
            });
            this.m_pnlEditor.setLayout(new BorderLayout());
            this.m_pnlEditor.add((Component)this.m_tfEditor, "Center");
            this.m_pnlEditor.add((Component)this.m_btnBrowse, "East");
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_iRow = row;
            this.m_iCol = column;
            String sLabel = value != null ? value.toString() : "";
            this.m_tfEditor.setText(sLabel);
            return this.m_pnlEditor;
        }

        public Object getCellEditorValue() {
            return this.m_tfEditor.getText();
        }
    }
}

