/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.role;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.security.LogConnectionSkipped;
import com.sas.metadata.logical.security.SecurityValidationUtil;
import com.sas.metadata.logical.security.role.RB;
import com.sas.metadata.logical.security.role.RoleImportItem;
import com.sas.metadata.logical.security.role.RoleUtil;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.AccessControlTemplate;
import com.sas.metadata.remote.ApplicationAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RoleImportListener
extends AbstractImportListener {
    protected ExportOperationInterface _exportOperation;

    public RoleImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new RoleImportItem(name, id, type);
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        try {
            for (ImportItemInterface importItem : objects) {
                List lConnectionPoints = importItem.getConnectionPoints();
                Iterator iterConnections = lConnectionPoints.iterator();
                while (iterConnections.hasNext()) {
                    String searchCriteria;
                    int flags = 8576;
                    ConnectionPointInterface connPoint = (ConnectionPointInterface)iterConnections.next();
                    if ("IdentityGroup".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List UsergroupList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "IdentityGroup", flags, searchCriteria);
                        if (UsergroupList.isEmpty()) continue;
                        IdentityGroup UsergroupObj = (IdentityGroup)UsergroupList.get(0);
                        connPoint.setTargetID(UsergroupObj.getFQID());
                        connections.add(connPoint);
                        continue;
                    }
                    if ("Person".equals(connPoint.getMetadataType())) {
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List userList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Person", flags, searchCriteria);
                        if (userList.isEmpty()) continue;
                        Person user = (Person)userList.get(0);
                        connPoint.setTargetID(user.getFQID());
                        connections.add(connPoint);
                        continue;
                    }
                    if (!"AccessControlTemplate".equals(connPoint.getMetadataType())) continue;
                    searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                    List ActList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "AccessControlTemplate", flags, searchCriteria);
                    if (ActList.isEmpty()) continue;
                    AccessControlTemplate ActObj = (AccessControlTemplate)ActList.get(0);
                    connPoint.setTargetID(ActObj.getFQID());
                    connections.add(connPoint);
                }
            }
        }
        catch (MdException mde) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)mde);
        }
        catch (RemoteException e) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)e);
        }
        return iRC;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) {
        int returnValue = 0;
        try {
            returnValue |= this.UpdateCapabilities(operation, objects);
            returnValue |= LogConnectionSkipped.logLostConnections(operation, objects);
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            returnValue = 4;
        }
        catch (MdException me) {
            operation.getLogger().error((Object)me.getLocalizedMessage());
            returnValue = 4;
        }
        return returnValue;
    }

    private int UpdateCapabilities(ImportOperationInterface operation, List objects) throws RemoteException, MdException {
        int returnValue = 0;
        MdObjectStore mdStore = null;
        mdStore = operation.getMetadataFactory().createObjectStore(null, "RoleImportListener:UpdateCapabilities");
        for (RoleImportItem RoleImportItem2 : objects) {
            String logString = "";
            HashSet<String> missingApp = null;
            HashSet<String> missingSw = null;
            int flags = 532876;
            IdentityGroup objRole = (IdentityGroup)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "IdentityGroup", RoleImportItem2.getTargetID(), null, null, "<Templates><IdentityGroup><AccessControlEntries/></IdentityGroup><AccessControlEntry><objects/></AccessControlEntry></Templates>", flags);
            List Connection = RoleImportItem2.getConnectionPoints();
            for (ConnectionPointInterface connPoint : Connection) {
                if (!"AccessControlEntry".equalsIgnoreCase(connPoint.getMetadataType())) continue;
                AssociationList lstAce = null;
                String strSearch = "";
                ApplicationAction aa = null;
                String strRequired = XMLUtil.normalize((String)connPoint.getSourceSearchString());
                String appName = connPoint.getUserDefinedProperty("ApplicationName");
                if (strRequired == null || strRequired.isEmpty()) continue;
                String strXmlSelect = "";
                if (strRequired.contains("]*[")) {
                    int idx = strRequired.indexOf("]*[");
                    strRequired = strRequired.substring(0, idx) + " and " + strRequired.substring(idx + 3);
                }
                strSearch = this.getApplicationSearchString(strRequired, appName);
                strXmlSelect = "<XMLSelect search=\"" + strSearch + "\"/>";
                List lstApp = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "ApplicationAction", flags, strXmlSelect);
                if (lstApp != null && lstApp.size() > 0) {
                    aa = (ApplicationAction)lstApp.get(0);
                    lstAce = aa.getAccessControls();
                    if (lstAce != null && lstAce.size() > 0) {
                        String inXML = RoleUtil.generateUpdateXML(objRole, (List)lstAce);
                        operation.getMetadataFactory().getOMIUtil().DoRequest(inXML);
                        continue;
                    }
                    returnValue |= 4;
                    if (missingApp == null) {
                        missingApp = new HashSet<String>();
                    }
                    missingApp.add(aa.getName());
                    continue;
                }
                returnValue |= 4;
                if (appName == null || appName.length() <= 0) continue;
                if (missingSw == null) {
                    missingSw = new HashSet<String>();
                }
                missingSw.add(appName);
            }
            if (missingApp != null && missingApp.size() > 0) {
                logString = this.getLogStringFromHashSet(missingApp);
                operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("RoleimportListener.MissingApplicationError.fmt"), (Object)logString, (Object)RoleImportItem2.getDisplayName(), (Object)RoleImportItem2.getTypeInterface().getDisplayType()));
            }
            if (missingSw == null || missingSw.size() <= 0) continue;
            logString = this.getLogStringFromHashSet(missingSw);
            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("RoleimportListener.MissingSoftwareComponentError.fmt"), (Object)"SoftwareComponent", (Object)logString));
        }
        mdStore.dispose();
        return returnValue;
    }

    private String getLogStringFromHashSet(HashSet<String> missingApp) {
        String logString = "";
        for (String val : missingApp) {
            logString = logString + val + ", ";
        }
        return logString.substring(0, logString.length() - 2);
    }

    private String getApplicationSearchString(String strRequired, String appName) {
        int startApp = strRequired.indexOf("ApplicationAction");
        String search = strRequired.substring(startApp, strRequired.length());
        search = search.replace("]/Trees", "][Trees");
        if (appName != null && !appName.isEmpty()) {
            String appString = "/SoftwareComponents/*[@Name='" + appName + "']]";
            search = search.substring(0, search.length() - 1).concat(appString);
        }
        return search;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        iRC |= SecurityValidationUtil.isUniqueIdentity(operation, objects);
        return iRC |= SecurityValidationUtil.analyzeRights(operation, objects);
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
    }
}

