/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.authenticationdomain;

import com.sas.metadata.logical.security.authenticationdomain.AuthDomain;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.List;

public class AuthDomainUtil {
    private AuthDomainUtil() {
    }

    public static AuthenticationDomain createAuthDomain(RepositoryInterface repo, ConnectionPointInterface cp) throws ServiceException, RemoteException, MdException {
        AuthenticationDomain authDomain = (AuthenticationDomain)((OMIRepositoryInterface)repo).createMetadata(cp.getName(), cp.getPublicType());
        authDomain.setDesc(cp.getDescription());
        authDomain.setPublicType(cp.getPublicType());
        authDomain.setUsageVersion(AuthDomain.CURRENT_VERSION.encode());
        authDomain.updateMetadataAll();
        return authDomain;
    }

    public static void updateAuthDomainConnectionPoint(List connections, ConnectionManagerInterface connectionManager, ServerInterface server, RepositoryInterface repo, Log logger) {
        List listConnectionPoint = connectionManager.getConnections(ConnectionObjectType.MetadataType, "AuthenticationDomain");
        PublicObjectInterface object = null;
        String objectId = null;
        AuthenticationDomain authDomain = null;
        try {
            for (ConnectionPointInterface cp : listConnectionPoint) {
                if (null != cp.getTargetID()) continue;
                object = AuthDomainUtil.searchByName(cp.getName(), cp.getMetadataType(), server);
                if (null == object) {
                    authDomain = AuthDomainUtil.createAuthDomain(repo, cp);
                    objectId = authDomain.getFQID();
                } else {
                    objectId = object.getIdentifier();
                }
                if (null == objectId) continue;
                cp.setTargetID(objectId);
                connections.add(cp);
            }
        }
        catch (RemoteException re) {
            logger.warn((Object)re.getMessage());
        }
        catch (ServiceException se) {
            logger.warn((Object)se.getMessage());
        }
        catch (MdException mde) {
            logger.warn((Object)mde.getMessage());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
    }

    private static PublicObjectInterface searchByName(String name, String type, ServerInterface server) {
        Filter filter = new Filter("Name", 0, name);
        filter.setType(type);
        List domainList = null;
        try {
            domainList = server.search((FilterInterface)filter);
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return domainList != null && domainList.size() > 0 ? (PublicObjectInterface)domainList.get(0) : null;
    }
}

