/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.authenticationdomain;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.security.authenticationdomain.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ListIterator;

public class AuthDomain
extends LogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public AuthDomain(AuthenticationDomain mdoAuthenticationDomain, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoAuthenticationDomain, type, factory);
        this.setCompatibility(new UsageVersion(0, 0), CURRENT_VERSION);
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return true;
    }

    public boolean isDeleteAllowed() throws LogicalTypeException {
        return true;
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        UtilPlatformServices.DetachedTransaction detachedTransaction = null;
        String msgTitle = RB.getStringResource("RmvAuthDomainsTableAction.ConfirmationTitle.txt");
        boolean hasLogins = false;
        boolean hasServerConnections = false;
        AuthenticationDomain jomaAuthDomain = null;
        Login login = null;
        String folderName = "";
        try {
            detachedTransaction = UtilPlatformServices.getDetachedTransaction();
            MetadataInterface smartAuthDomain = detachedTransaction.getSmartObject((SimpleLogicalObjectInterface)this);
            try {
                Root root = (Root)smartAuthDomain.getRepositoryEntity();
                AssociationList al = root.getTrees();
                if (al.size() == 1) {
                    Tree tree = (Tree)root.getTrees().get(0);
                    folderName = tree.getName();
                }
            }
            catch (Exception root) {
                // empty catch block
            }
            if (!(smartAuthDomain.getRepositoryEntity() instanceof AuthenticationDomain)) {
                boolean root = false;
                return root;
            }
            jomaAuthDomain = (AuthenticationDomain)smartAuthDomain.getRepositoryEntity();
            if (jomaAuthDomain != null && jomaAuthDomain.getLogins().size() > 0) {
                hasLogins = true;
            }
            if (jomaAuthDomain != null && jomaAuthDomain.getConnections().size() > 0) {
                hasServerConnections = true;
            }
            if (hasLogins || hasServerConnections) {
                int response;
                String prompt;
                if (hasLogins) {
                    prompt = RB.getStringResource("RmvAuthDomainsTableAction.DeleteDomains.LoginsDefined.ConfirmationPrompt.txt");
                    response = MessageUtil.displayMessage((String)prompt, (String)msgTitle, (int)2, (int)0);
                    if (response == 1) {
                        boolean root = false;
                        return root;
                    }
                    ListIterator iterLogins = jomaAuthDomain.getLogins().listIterator();
                    while (iterLogins.hasNext()) {
                        login = (Login)iterLogins.next();
                        iterLogins.remove();
                        login.delete();
                    }
                    smartAuthDomain.update();
                }
                if (hasServerConnections && (response = MessageUtil.displayMessage((String)(prompt = RB.getStringResource("RmvAuthDomainsTableAction.DeleteDomains.ServerDefined.ConfirmationPrompt.txt")), (String)msgTitle, (int)2, (int)0)) == 1) {
                    boolean iterLogins = false;
                    return iterLogins;
                }
            }
            smartAuthDomain.delete();
            boolean iterLogins = true;
            return iterLogins;
        }
        catch (ServiceException e) {
            if (oui.continueOperationWithPrompting()) {
                String messageText = folderName.length() == 0 ? UtilMisc.getMessage((String)RB.getStringResource("COM.DelExcpOccrdNoFolder.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)((Object)e))) : UtilMisc.getMessage((String)RB.getStringResource("COM.DelExcpOccrd.fmt.txt"), (Object)this._ti.getDisplayType(), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)((Object)e)));
                int choice = oui.displayMessage(RB.getStringResource("COM.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new LogicalTypeException(e);
        }
        finally {
            if (detachedTransaction != null) {
                detachedTransaction.rollback();
            }
        }
    }
}

