/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security.act;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.security.act.ActExportItem;
import com.sas.metadata.logical.security.act.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ActExportListener
extends AbstractExportListener {
    public ActExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ActExportItem(name, id, type);
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException {
        int rc = 0;
        if (objects != null && !objects.isEmpty()) {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            for (ExportItemInterface exportItem : objects) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ActExportListener.RetrievingDetails.fmt.txt", (Object)exportItem.toString());
                this.fireDisplayMessage(msg);
                operation.getLogger().info((Object)msg);
                rc |= this.exportDetails(operation, outputFactory, exportItem.getID());
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exportDetails(ExportOperationInterface operation, XMLOutputFactory outputFactory, String id) {
        XMLStreamWriter streamWriter = null;
        try {
            MetadataInterface mi = PromotionUtil.getSmartObject((ServerInterface)operation.getServer(), (String)id, (String)"AccessControlTemplate");
            if (mi instanceof AccessControlTemplateInterface) {
                AccessControlTemplateInterface act = (AccessControlTemplateInterface)mi;
                StringWriter sw = new StringWriter();
                streamWriter = outputFactory.createXMLStreamWriter(sw);
                streamWriter.writeStartDocument("UTF-8", "1.0");
                streamWriter.writeStartElement("Objects");
                this.addObjects(operation, act, streamWriter);
                streamWriter.writeEndElement();
                streamWriter.writeEndDocument();
                StringReader sr = new StringReader(sw.toString());
                operation.getContentHandler().addTextContent(id, null, (Reader)sr);
            }
        }
        catch (ServiceException e) {
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ActExportListener.MetadataError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error retrieving metadata", (Throwable)e);
            }
            int n = 8;
            return n;
        }
        catch (XMLStreamException e) {
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ActExportListener.WritingError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error creating xml", (Throwable)e);
            }
            int n = 8;
            return n;
        }
        catch (IOException e) {
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ActExportListener.SaveContentsError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error adding content", (Throwable)e);
            }
            int n = 8;
            return n;
        }
        catch (Exception e) {
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"ActExportListener.ContentError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Exception occurred", (Throwable)e);
            }
            int n = 8;
            return n;
        }
        finally {
            try {
                if (streamWriter != null) {
                    streamWriter.close();
                }
            }
            catch (Exception e) {
                operation.getLogger().debug((Object)"Unable to close input/output streams.");
            }
        }
        return 0;
    }

    private void addObjects(ExportOperationInterface operation, AccessControlTemplateInterface act, XMLStreamWriter streamWriter) throws ServiceException, RemoteException, XMLStreamException {
        List objects = act.getObjects();
        for (MetadataInterface object : objects) {
            CMetadata meta = (CMetadata)object.getRepositoryEntity();
            streamWriter.writeStartElement(meta.getCMetadataType());
            streamWriter.writeAttribute("Id", object.getIdentifier());
            streamWriter.writeAttribute("Name", object.getName());
            TypeDescriptorInterface desc = object.getTypeDescriptor();
            if (desc != null) {
                streamWriter.writeAttribute("PublicType", desc.getTypeName());
            }
            streamWriter.writeEndElement();
        }
    }
}

