/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.security;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.security.RB;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.services.util.XMLUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogConnectionSkipped {
    public static int logLostConnections(ImportOperationInterface operation, List objects) {
        boolean Connection = false;
        boolean statusFlag = false;
        int iRC = 0;
        int flags = 8576;
        try {
            for (ImportItemInterface importItem : objects) {
                List lConnectionPoints = importItem.getConnectionPoints();
                Iterator iterConnections = lConnectionPoints.iterator();
                while (iterConnections.hasNext()) {
                    ArrayList lstPermission;
                    Map ActPermissionMap;
                    boolean flagAct;
                    String searchCriteria;
                    boolean checkFlag = false;
                    Connection = false;
                    ConnectionPointInterface connPoint = (ConnectionPointInterface)iterConnections.next();
                    if ("IdentityGroup".equals(connPoint.getMetadataType())) {
                        checkFlag = true;
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List identityGroupList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "IdentityGroup", flags, searchCriteria);
                        if (!identityGroupList.isEmpty()) {
                            Connection = true;
                        } else {
                            flagAct = LogConnectionSkipped.checkIfimpoerItemIsAct(importItem);
                            if (flagAct) {
                                ActPermissionMap = operation.getAssociationsForObject((PromotionItemInterface)importItem, "<Template Type=\"ACT\" ><AccessControlTemplate><AccessControlItems><AccessControlTemplate TemplateExpand=\"connect\" ConnectionAction=\"F\"/><AccessControlEntry TemplateExpand=\"yes\"><Permissions><Permission/></Permissions></AccessControlEntry></AccessControlItems></AccessControlTemplate></Template>");
                                lstPermission = new ArrayList();
                                LogConnectionSkipped.GetPermissionPattern(importItem, ActPermissionMap, lstPermission);
                                statusFlag = LogConnectionSkipped.checkPermission(lConnectionPoints, lstPermission);
                            }
                        }
                    } else if ("AccessControlTemplate".equals(connPoint.getMetadataType())) {
                        checkFlag = true;
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List lstAct = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "AccessControlTemplate", flags, searchCriteria);
                        if (!lstAct.isEmpty()) {
                            Connection = true;
                        }
                    } else if ("Person".equals(connPoint.getMetadataType())) {
                        checkFlag = true;
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List lstPerson = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Person", flags, searchCriteria);
                        if (!lstPerson.isEmpty()) {
                            Connection = true;
                        } else {
                            flagAct = LogConnectionSkipped.checkIfimpoerItemIsAct(importItem);
                            if (flagAct) {
                                ActPermissionMap = operation.getAssociationsForObject((PromotionItemInterface)importItem, "<Template Type=\"ACT\" ><AccessControlTemplate><AccessControlItems><AccessControlTemplate TemplateExpand=\"connect\" ConnectionAction=\"F\"/><AccessControlEntry TemplateExpand=\"yes\"><Permissions><Permission/></Permissions></AccessControlEntry></AccessControlItems></AccessControlTemplate></Template>");
                                lstPermission = new ArrayList();
                                LogConnectionSkipped.GetPermissionPattern(importItem, ActPermissionMap, lstPermission);
                                statusFlag = LogConnectionSkipped.checkPermission(lConnectionPoints, lstPermission);
                            }
                        }
                    } else if ("SoftwareComponent".equals(connPoint.getMetadataType())) {
                        checkFlag = true;
                        searchCriteria = "<XMLSelect search=\"" + XMLUtil.normalize((String)connPoint.getSourceSearchString()) + "\"/>";
                        List UsergroupList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "SoftwareComponent", flags, searchCriteria);
                        if (!UsergroupList.isEmpty()) {
                            Connection = true;
                        }
                    }
                    if (!checkFlag) continue;
                    TypeInterface ti = Factory.getInstance().getTypeInterface(connPoint.getPublicType());
                    if (!Connection && !statusFlag) {
                        operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ObjectImportListener.ConnectionSkipped.fmt"), (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getDisplayName(), (Object)ti.getDisplayType(), (Object)connPoint.getName()));
                        iRC |= 4;
                        continue;
                    }
                    if (!statusFlag) continue;
                    iRC |= 8;
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ObjectImportListener.ConnectionSkipped.fmt"), (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getDisplayName(), (Object)ti.getDisplayType(), (Object)connPoint.getName()));
                }
            }
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.getLocalizedMessage());
            iRC = 8;
        }
        catch (RemoteException re) {
            operation.getLogger().error((Object)re.getLocalizedMessage());
            iRC = 8;
        }
        catch (MetadataPromotionException mp) {
            operation.getLogger().error((Object)mp.getLocalizedMessage());
            iRC = 8;
        }
        catch (LogicalTypeException le) {
            operation.getLogger().error((Object)le.getLocalizedMessage());
            iRC = 8;
        }
        return iRC;
    }

    private static void GetPermissionPattern(ImportItemInterface importItem, Map actPermissionMap, List lstPermission) {
        if (actPermissionMap.size() > 0) {
            Set objectHashMapSet = actPermissionMap.keySet();
            for (String ReadMapkey : objectHashMapSet) {
                if (importItem.getID().equalsIgnoreCase(ReadMapkey)) {
                    Map hmmTraverse = (Map)actPermissionMap.get(ReadMapkey);
                    LogConnectionSkipped.GetPermissionPattern(importItem, hmmTraverse, lstPermission);
                    continue;
                }
                if (!ReadMapkey.equalsIgnoreCase("AccessControlItems") && !ReadMapkey.equalsIgnoreCase("Permissions")) continue;
                List objList = (List)actPermissionMap.get(ReadMapkey);
                for (int i = 0; i < objList.size(); ++i) {
                    Map hmmTempMap = (Map)objList.get(i);
                    if (hmmTempMap.containsValue("Permission")) {
                        lstPermission.add(hmmTempMap.get("Id"));
                        continue;
                    }
                    LogConnectionSkipped.GetPermissionPattern(importItem, hmmTempMap, lstPermission);
                }
            }
        }
    }

    private static boolean checkIfimpoerItemIsAct(ImportItemInterface importItem) {
        return importItem.getTypeInterface().getMetadataType().equalsIgnoreCase("AccessControlTemplate");
    }

    private static boolean checkPermission(List lstConnection, List checkPermission) {
        boolean LoopFlag = false;
        for (ConnectionPointInterface connPoint : lstConnection) {
            if (!connPoint.getMetadataType().equalsIgnoreCase("Permission") || !checkPermission.contains(connPoint.getSourceID()) || !XMLUtil.normalize((String)connPoint.getSourceSearchString()).contains("DENY")) continue;
            LoopFlag = true;
            break;
        }
        return LoopFlag;
    }
}

