/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.search;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.search.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.search.SearchCriteriaModel;
import com.sas.services.information.search.SearchUtility;
import com.sas.text.Message;
import java.util.List;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SearchImportListener
extends AbstractImportListener {
    public SearchImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        SearchCriteriaModel scm = null;
        ServerInterface si = null;
        try {
            si = operation.getServer();
        }
        catch (Exception e) {
            operation.getLogger().warn((Object)RB.getStringResource("SearchImportListener.ValidatingMetadata.Exception.txt"), (Throwable)e);
            return 4;
        }
        for (DefaultImportItem item : objects) {
            String sfID = item.getID();
            String sfName = item.toString();
            try {
                String detailsStr;
                SearchUtility.ValidCriteriaResults results;
                NamedNodeMap attrs;
                Node detailsNode;
                Document doc = ImportUtil.getObjectDocument((ImportOperationInterface)operation, (String)sfID);
                Node searchNode = doc.getFirstChild();
                if (searchNode == null || (detailsNode = (attrs = searchNode.getAttributes()).getNamedItem("Details")) == null || (results = SearchUtility.validateSearchCriteria((SearchCriteriaModel)(scm = SearchUtility.createSearchCriteriaModel((ServerInterface)si, (String)(detailsStr = detailsNode.getNodeValue()))), (ServerInterface)si)) == null || results.isValidCriteria()) continue;
                rc = 4;
                operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"SearchImportListener.IdentifyingObject.Message.fmt", (Object)sfName));
                List errorMsgs = results.getCriteriaErrorMsgs();
                for (String msg : errorMsgs) {
                    operation.getLogger().warn((Object)msg);
                }
            }
            catch (Exception e) {
                operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"SearchImportListener.AnalyzingObject.Error.fmt", (Object)sfName), (Throwable)e);
                rc = 4;
            }
        }
        return rc;
    }
}

